
/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * template - argus client template.
 *
 *       this module should define these routines:
 *
 *   (void) usage ((char *) argv[0]);
 *                    this routine should print the standard usage message
 *                    for the specific application.
 *
 *          init ();
 *                    this is the application specific init
 *                    routine, which is called after all parsing
 *                    initialization is done, prior to reading the
 *                    first argus(1) datum.
 *
 *   (void) clientTimeout ();
 *                    this routine is called every second, when
 *                    the argus client is connected to a remote
 *                    data source using the -S flag.
 *
 *          process_tcp ((struct writeStruct *) ptr);
 *                    this routine should process tcp events;
 *
 *          process_udp ((struct writeStruct *) ptr);
 *                    this routine should process tcp events;
 *
 *          process_icmp ((struct writeStruct *) ptr);
 *                    this routine should process tcp events;
 *
 *          process_ip ((struct writeStruct *) ptr);
 *                    this routine should process tcp events;
 *
 *   (void) argus_parse_complete ();
 *                    this routine will be called after all the
 *                    monitor data has been read.
 *
 *
 * written by Carter Bullard
 * Software Engineering Institute
 * Carnegie Mellon Univeristy
 *
 */

#define ARGUS_CLIENT

#include <stdlib.h>
#include <unistd.h>

#include <compat.h>

#include <stdio.h>
#include <cons_out.h>


char *appOptstring = NULL;
extern int major_version, minor_version;

init () {}

void argus_parse_complete () {}

void clientTimeout () {}

parse_arg (argc, argv)
int argc;
char**argv;
{}

void
usage (ptr)
char *ptr;
{
   exit(1);
}


process_tcp (ptr)
struct writeStruct *ptr;
{
}


process_icmp (ptr)
struct writeStruct *ptr;
{
}

process_udp (ptr)
struct writeStruct *ptr;
{
}

process_ip (ptr)
struct writeStruct *ptr;
{
}

