
/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */


#include <netinet/tcp.h>

#define TCPOUTFLAGS
#define TCPSTATES
#define TCPTIMEOUT    120
#define MAXQUEUE  1024
#define MAX_KLUDGE   10000

#define FIN_WAIT                0x800
#define SYNSENT                 0x1000
#define SYNRECEIVED             0x2000
#define ESTABLISHED             0x4000
#define CLOSED                  0x8000


struct TCP_CON_OBJECT {
   tcp_seq seq_base, seq, ack;
   int retrans, strays, count, lastcount, lastbytes;
   u_short win, pad;
};

struct tcpcb {
   struct timeval startime, lasttime;
   int t_state, rev, status;
   struct TCP_CON_OBJECT src, dst;
};

struct TCP_OBJECT {
   struct QUEUE_HEADER qhdr;
   struct physLink link;
   struct tha addr;
   struct tcpcb tcp_cb;
};


#define TSEQ_HASHSIZE 9029

#ifdef CONS_TCP

static int closed = 0;
struct HASH_TABLE tcp_hash_table;
struct QUEUE tcp_display_list;
struct QUEUE tcp_timeout_list;

#else

extern int closed;
extern struct QUEUE tcp_display_list;
extern struct QUEUE tcp_timeout_list;
#endif
