
/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */


#define DEFAULT_POLICY   "policy.conf"
#define POLICY_STRING    "access-list"

#define POLICYFIELDNUM     11

#define POLICYSTRING       0
#define POLICYID           1
#define POLICYACTION       2
#define POLICYPROTO        3
#define POLICYSRCADDR      4
#define POLICYSRCMASK      5
#define POLICYDSTADDR      6
#define POLICYDSTMASK      7
#define POLICYPORTACT      8
#define POLICYPORT         9
#define POLICYNOTIFICATION 10

#define POLICYTESTCRITERIA 4

#define POLICYTESTPROTO    0
#define POLICYTESTSRC      1
#define POLICYTESTDST      2
#define POLICYTESTPORT     3

#define PERMIT    0x10000
#define DENY      0x20000

#define ICMP      0x01
#define TCP       0x02
#define UDP       0x04
#define IP        0x08

#define EQ        0x01
#define LT        0x02
#define GT        0x04
#define NEQ       0x08
#define EST       0x10

#define SRCROUTED      0x01
#define ACCESSLIST     0x02

struct netStruct {
   int operator;
   u_long addr;
   u_long mask;
};

struct policyStruct {
   struct policyStruct *prv, *nxt;
   int type, policyID;
   int flags;
   struct netStruct src, dst;
   u_short port, action;
   int notification;
   char *str;
};
