
/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * cons_ether.c - handle datagrams at link layer - ethernet specific.
 *                just branch to IP datagram handler if appropriate.
 *
 * written by Carter Bullard
 * Software Engineering Institute
 * Carnegie Mellon Univeristy
 *
 */

#include <stdlib.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/time.h>

#include <compat.h>
#include <pcap.h>

#include <cons_ether.h>
#include <argus.h>


#define TRUE    1
#define FALSE   0


void
cons_ether_init ()
{
}

struct timeval globaltvp;
int totalPktsRcv = 0;

void 
cons_ether_packet (user, h, p)
u_char *user;
struct pcap_pkthdr *h;
u_char *p;
{
   struct ether_header *ep = (struct ether_header *) p;
   struct timeval *tvp;
   u_short ether_type;
   int caplen = h->caplen;
   int length = h->len;

   if (p && caplen) {
      totalPktsRcv++;
      bcopy ((char *) &h->ts, (char *)&globaltvp, sizeof (struct timeval));
      tvp = &h->ts;
      p += sizeof (struct ether_header);

      if ((ether_type = ntohs (ep->ether_type)) == ETHERTYPE_IP) {
         switch (ether_type) {
            case ETHERTYPE_IP:
               length -= sizeof (struct ether_header);
               argus_ip_handler (ep, (struct ip *) p, length, tvp);
               break;

            default:
               break;
         }
      }
   }
}

