
/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * cons_icmp.c - supports ICMP tracking 
 *
 * Used to parse received icmp packets.
 *
 * written by Carter Bullard
 * Software Engineering Institute
 * Carnegie Mellon Univeristy
 */



#include <stdlib.h>
#include <unistd.h>

#include <compat.h>
#include <pcap.h>
#include <interface.h>

#include <argus.h>
#include <netinet/ip_icmp.h>
#include <cons_icmp.h>

extern int clienttags;
extern int clients[];
extern int ip_options;
extern int ip_eol;
extern int ip_nop;
extern int ip_ts;
extern int ip_rr;
extern int ip_sec;
extern int ip_lsrr;
extern int ip_ssrr;
extern int ip_satid;

static void log_icmp_relation ();

void cons_icmp (ep, dp, length, ip, tvp)
struct ether_header *ep;
struct icmp *dp;
int length;
struct ip *ip;
struct timeval *tvp;
{
   struct icmpStruct icmp;
   struct ip *oip;
   struct udphdr *ouh;
   int hlen;

   bzero ((char *) &icmp, sizeof (icmp));
   if (dp && length) {
      icmp.type = dp->icmp_type; icmp.code = dp->icmp_code;
      switch (icmp.type) {
         case ICMP_UNREACH:
            bcopy ((char *) &dp->icmp_ip.ip_src, (char *) &icmp.srcaddr, sizeof (u_long));
            bcopy ((char *) &dp->icmp_ip.ip_dst, (char *) &icmp.dstaddr, sizeof (u_long));
            switch (icmp.code) {
               case ICMP_UNREACH_PROTOCOL:
                  icmp.data = (unsigned short) dp->icmp_ip.ip_p;
                  break;

               case ICMP_UNREACH_PORT:
                  oip = &dp->icmp_ip;
                  hlen = oip->ip_hl << 2;
                  ouh = (struct udphdr *) (((u_char *) oip) + hlen);
                  NTOHS (ouh->uh_dport);
                  icmp.data = (unsigned short) ouh->uh_dport;
                  bcopy ((char *) &oip->ip_p, (char *) &icmp.gwaddr, sizeof (oip->ip_p));
                  break;
            } break;
   
         case ICMP_MASKREPLY:
            bcopy ((char *) &dp->icmp_mask, (char *) &icmp.srcaddr, sizeof (dp->icmp_mask));
            break;
            
         case ICMP_REDIRECT:
            bcopy ((char *) &dp->icmp_ip.ip_src, (char *) &icmp.srcaddr, sizeof (icmp.srcaddr));
            bcopy ((char *) &dp->icmp_ip.ip_dst, (char *) &icmp.dstaddr, sizeof (icmp.dstaddr));
            bcopy ((char *) &dp->icmp_gwaddr, (char *) &icmp.gwaddr, sizeof (icmp.gwaddr));
            break;
   
         case ICMP_ECHO:
         case ICMP_ECHOREPLY:
         case ICMP_IREQ:
         case ICMP_IREQREPLY:
         case ICMP_MASKREQ:
         case ICMP_PARAMPROB:
         case ICMP_SOURCEQUENCH:
         case ICMP_TIMXCEED:
         case ICMP_TSTAMP:
         case ICMP_TSTAMPREPLY:
            break;
      }
   
      log_icmp_relation (ep, &icmp, ip, tvp);
   }
}


#include <sys/stat.h>
#include <sys/errno.h>
 
extern char *sys_errlist[];
extern int sys_nerr;
extern int errno;
 
 
static void
log_icmp_relation (ep, icmp, ip, tvp)
struct ether_header *ep;
struct icmpStruct *icmp;
struct ip *ip;
struct timeval *tvp;
{
   int status = ICMPPROTO;
   struct writeStruct output;
   struct tha tha;

   if (ip) status |= IPPROTO;

   if (ip_options) {
      if (ip_ts)   status |= TIMESTAMP;
      if (ip_sec)  status |= SECURITY;
      if (ip_lsrr) status |= LSRCROUTE;
      if (ip_ssrr) status |= SSRCROUTE;
      if (ip_rr)   status |= RECORDROUTE;
      if (ip_satid) status |= SATNETID;
   }
 
   if (clienttags || wflag) {
      bcopy ((char *)&ep->ether_shost, (char *)&output.ethersrc, 6);
      bcopy ((char *)&ep->ether_dhost, (char *)&output.etherdst, 6);
      tha.src = ip->ip_src;
      tha.dst = ip->ip_dst;
      tha.port = 0;
      output.startime =  *tvp;
      output.lasttime =  *tvp;
      output.status   =  status;
      output.addr     =  tha;

      bcopy ((char *) icmp, (char *) &output.src_count, sizeof (*icmp));

      writeOutData (&output);
   }
}
