
/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Use in source and binary forms, with or without modification, is
 * permitted provided that source code modifications retain all
 * perintent copyright notices and this paragraph in its entirety.
 * This distribution includes software developed by Carnegie Mellon 
 * University, the Software Engineering Institute and the CERT
 * Coordination Center.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#define ARGUS_CLIENT

#include <stdlib.h>
#include <unistd.h>

#include <compat.h>

#include <stdio.h>
#include <sys/time.h>

#include <pcap.h>
#include <interface.h>
#include <addrtoname.h>
#include <nametoaddr.h>

#include <sys/types.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <sys/socket.h>

#include <cons_out.h>
#include <connections.h>
#include <argus_parse.h>


char *appOptstring = NULL;
extern char *progname, *wfile;
extern int major_version, minor_version;
extern struct tm tm_startime, tm_lasttime;
extern struct FILE_ENTRY *input_file_list;

#define   TRUE     1
#define   FALSE    0

struct HASH_TABLE hash_table;

int count = 0;
long startime = 0;
long endtime = 0;


struct writeStructHeader {
   struct writeStructHeader *nxt, *prv;
   struct WriteStruct *ws;
   u_char src_ttl, dst_ttl;
};

extern u_char src_ttl, dst_ttl;

struct writeStructHeader **sortArray = NULL;
struct writeStructHeader *startwsh = NULL;
struct writeStructHeader *endwsh = NULL;

void printoutdata();


void clientTimeout () {}
 
parse_arg (argc, argv)
int argc;
char**argv;
{}

void
usage (ptr)
char *ptr;
{
   fprintf (stderr, "usage: %s [-bcfghlmnux] ", ptr);
   fprintf (stderr, "[-C access-file] [-d debug-interval] [-F file] [-P port]\n");
   fprintf (stderr, "          [-r input_file] [-s Services_file] [-S argus_server]\n");
   fprintf (stderr, "          [-t time_range] [-w output_file] expression.\n");
   fprintf (stderr, "options: b - dump packet-matching code.\n");
   fprintf (stderr, "         c - print packet and byte counts.\n");
   fprintf (stderr, "         C - specify Cisco access-file.\n");
   fprintf (stderr, "         d - specify detail mode, interval in secs.\n");
   fprintf (stderr, "         f - print local hostnames only\n");
   fprintf (stderr, "         F - use file to define filter expression.\n");
   fprintf (stderr, "         g - print difference in start and last time values.\n");
   fprintf (stderr, "         h - print help.\n");
   fprintf (stderr, "         l - print last time values [default is start time].\n");
   fprintf (stderr, "         m - print MAC addresses.\n");
   fprintf (stderr, "         n - don't convert numbers to names.\n");
   fprintf (stderr, "         P - specify remote argus port.\n");
   fprintf (stderr, "         r - read Argus input file.\n");
   fprintf (stderr, "         S - specify remote argus host.\n");
   fprintf (stderr, "         s - specify remote argus host.\n");
   fprintf (stderr, "         t - specify time_range for search.\n         ");
   fprintf (stderr, "      format:    ");
   fprintf (stderr, "timeSpecification[-timeSpecification]\n");
   fprintf (stderr, "                          timeSpecification: ");
   fprintf (stderr, "[mm/dd[/yy].]hh[:mm[:ss]]\n");
   fprintf (stderr, "                                             ");
   fprintf (stderr, " mm/dd[/yy]\n");
   fprintf (stderr, "         u - print msecs timestamps (*)\n");
   fprintf (stderr, "         w - write Argus output file.\n");
   fprintf (stderr, "         x - flip ports on input (*)\n");
   exit(1);
}
extern int dowriteout;

init () {
   struct HASH_TABLE_HEADER **ptr;
   struct FILE_ENTRY *file = NULL;
   struct timeval tvp;

   dowriteout = 0;
   bzero ((char *) &hash_table, sizeof(hash_table));
   if (rflag && (file = input_file_list)) {
      if (file->nxt) {
         fprintf (stderr, "%s: only one input file at a time.\n", progname);
         usage (progname);
      }  
   }

   if (!(wfile)) wfile = "-";

   startime  = 0x7FFFFFFF;
   if (ptr = (struct HASH_TABLE_HEADER **) calloc
                          (TSEQ_HASHSIZE, sizeof(ptr))) {
      hash_table.hash_array = ptr;
      hash_table.size = TSEQ_HASHSIZE;
   }
}

extern int argusrecords;

void argus_parse_complete ()
{
   int count = 0;
   struct writeStructHeader *wsh = startwsh, *ptr = NULL;

   if (argusrecords) {
      if (sortArray = (struct writeStructHeader **) calloc (
                 ((endtime - startime) + 1), sizeof(wsh))) {
         while (wsh) {
            count++;
            ptr = wsh->nxt;
            sortws (wsh);
            wsh = ptr;
         }  

         printoutdata (sortArray);

      } else
         perror ("calloc: sortArray");
   }
}


#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>

extern struct WriteStruct *initCon;
extern struct WriteStruct wsOriginal;

void
printoutdata (array)
struct writeStructHeader *array[];
{
   int i, len = (endtime - startime) + 1;
   FILE *fd = NULL;
   struct stat buf;
   char buffer[64], *bufptr;

   struct writeStructHeader *wsh;

   if (wfile) {
      if (strcmp (wfile, "-")) {
         if (stat (wfile, &buf) < 0) {
            if (errno == ENOENT)
               if (fd = fopen (wfile, "a")) {
                  if (initCon) {
                     if (!(fwrite ((char *) initCon, sizeof(*initCon), 1, fd))) {
                        perror ("fwrite");
                        return;
                     }
                  } else
                     if (!(fprintf (fd, "Argus Version %d.%d\n",
                                           major_version, minor_version))) {
                        perror ("fprintf");
                        return;
                     }
               } else {
                  perror ("fopen");
                  return;
               }
         } else {
            if (!(fd = fopen (wfile, "a"))) {
               perror ("fopen");
               return;
            }
         }
      } else {
         fd = stdout;

/*
         if (initCon) {
            if (!(fwrite ((char *) initCon, sizeof(*initCon), 1, fd))) {
               perror ("fwrite");
               return;
            }
         }

         fflush (fd);
*/
      }

      for (i = 0; i < len; i++) {
         if (wsh = sortArray[i]) {
            do {
               unreformat_data (wsh);

               if (!(fwrite ((void *) wsh->ws, sizeof(*wsh->ws), 1, fd))) {
                  perror ("fwrite");
                  return;
               }
               wsh = wsh->nxt;
            } while (wsh != sortArray[i]);
         }
      }
   }

   fclose (fd);
}


#include <netinet/ip_icmp.h>

unreformat_data (wsh)
struct writeStructHeader *wsh;
{
   u_int difftime;

   if ((major_version > 1) || (minor_version > 6)) {
      difftime = wsh->ws->ws_ip.lasttime.tv_sec -
                 wsh->ws->ws_ip.startime.tv_sec;

      ((u_short *)&wsh->ws->ws_ip.lasttime.tv_sec)[1] = difftime;

      ((u_char *)&wsh->ws->ws_ip.lasttime.tv_sec)[0] = wsh->src_ttl;
      ((u_char *)&wsh->ws->ws_ip.lasttime.tv_sec)[1] = wsh->dst_ttl;
   }

   if (wsh->ws->status & REVERSE)
      wsh->ws->status &= ~REVERSE;

   wshton (wsh->ws);
}


update_hash_connection (ptr, proto)
struct WriteStruct *ptr;
unsigned int proto;
{
   int retn = FALSE, rev;
   struct WriteStruct *obj, *find_hash_entry();
   struct tha thabuf, *tha = &thabuf;

   if (create_tha (ptr, tha, proto, &rev)) {
      if (obj = find_hash_entry (&hash_table, tha)) {
         switch (proto) {
            case TCPPROTO:
               if ((ptr->status & (SAW_SYN | SAW_SYN_SENT)) &&
                   (!(ptr->status & (CON_ESTABLISHED)))) {
                  ptr->ws_ip_udp.src_bytes = 0;
                  ptr->ws_ip_udp.dst_bytes = 0;

                  if (obj->status & TIMED_OUT) {
                     if ((ptr->status & (SAW_SYN | SAW_SYN_SENT)) ==
                                        (SAW_SYN | SAW_SYN_SENT)) {
                        remove_hash_table_entry (&hash_table, tha);
                        break;
                     }
                  }
               }

               if ((obj->status & TIMED_OUT) &&
                       ((ptr->status & CON_ESTABLISHED) &&
                       (ptr->status & (NORMAL_CLOSE | RESET | TIMED_OUT)))) {
                  retn = update_tcp_hash (ptr, obj, rev);

                  if (ptr->status & (NORMAL_CLOSE | RESET))
                     remove_hash_table_entry (&hash_table, tha);
                  retn++;
                  break;
               }

               if (ptr->status & (NORMAL_CLOSE | RESET | TIMED_OUT)) {
                  bcopy ((u_char*) ptr, (u_char *) obj, sizeof(*obj));
                  if (ptr->status & (NORMAL_CLOSE | RESET))
                     remove_hash_table_entry (&hash_table, tha);
                  retn++;
                  break;
               }

               if (obj->status & CON_ESTABLISHED) {
                  retn = update_tcp_hash (ptr, obj, rev);
                  break;
               }

               bcopy ((u_char*) ptr, (u_char *) obj, sizeof(*obj));
               
               retn++;
               break;

            case  IPPROTO:
            case UDPPROTO:
               retn = update_udp_hash (ptr, obj, tha);
               break;

            case ICMPPROTO:
	       retn = update_icmp_hash (ptr, obj, tha);
	       break;
         }
      }
   }
   return (retn);
}


update_icmp_hash (ptr, obj, tha)
struct WriteStruct *ptr, *obj;
struct tha *tha;
{
   int retn = 1, count;
   unsigned char  ra_icmp_type, ra_icmp_code;
   unsigned short ra_icmp_data;
   unsigned long  ra_src_addr = 0, ra_dst_addr = 0, ra_gw_addr = 0;
   struct icmpWriteStruct *icmp;
   double thisstartime = 0.0, thislasttime = 0.0;
   double thatstartime = 0.0, thatlasttime = 0.0;

   icmp = &ptr->ws_ip_icmp;

   thisstartime =(double)((double)ptr->ws_ip.startime.tv_sec +
                         ((double)ptr->ws_ip.startime.tv_usec/1000000.0));
   thislasttime =(double)((double)ptr->ws_ip.lasttime.tv_sec +
                         ((double)ptr->ws_ip.lasttime.tv_usec/1000000.0));
 
   thatstartime =(double)((double)obj->ws_ip.startime.tv_sec +
                        ((double)obj->ws_ip.startime.tv_usec/1000000.0));
   thatlasttime =(double)((double)obj->ws_ip.lasttime.tv_sec +
                        ((double)obj->ws_ip.lasttime.tv_usec/1000000.0));

   if ((thislasttime - thatstartime) > 86400) {
      swapwsheader (ptr, obj, tha);
   } else {
      if (thatstartime > thisstartime)
         obj->ws_ip.startime = ptr->ws_ip.startime;
   
      if (thatlasttime < thislasttime)
         obj->ws_ip.lasttime = ptr->ws_ip.lasttime;
    
   
      if (!(obj->status & (CON_ESTABLISHED | TIMED_OUT))) {
         if (ptr->status & (CON_ESTABLISHED | TIMED_OUT)) {
            bcopy ((u_char*) ptr, (u_char *) obj, sizeof(*obj));
            return (retn);
         } else {
            ra_icmp_type = icmp->type;
            ra_icmp_code = icmp->code;
            ra_icmp_data = icmp->data;
            ra_src_addr =  icmp->srcaddr.s_addr;
            ra_dst_addr =  icmp->dstaddr.s_addr;
            ra_gw_addr  =  icmp->gwaddr.s_addr;
   
            obj->status |= CON_ESTABLISHED;
            ((unsigned char *) &obj->ws_ip_udp.src_bytes) [0] = ra_icmp_type;
            ((unsigned char *) &obj->ws_ip_udp.src_bytes) [1] = ra_icmp_code;
            ((unsigned short *)&obj->ws_ip_udp.src_bytes) [1] = ra_icmp_data;
            obj->ws_ip_udp.dst_bytes = ra_src_addr;
   
            obj->ws_ip_udp.src_count = 2;
        }
      } else {
         if (!(ptr->status & (CON_ESTABLISHED | TIMED_OUT))) {
            ra_icmp_type = icmp->type;
            ra_icmp_code = icmp->code;
            ra_icmp_data = icmp->data;
            ra_src_addr =  icmp->srcaddr.s_addr;
            ra_dst_addr =  icmp->dstaddr.s_addr;
            ra_gw_addr  =  icmp->gwaddr.s_addr;
   
            switch (ra_icmp_type) {
               case ICMP_ECHOREPLY:
               case ICMP_TSTAMPREPLY:
               case ICMP_IREQREPLY:
               case ICMP_MASKREPLY:
                  obj->ws_ip_udp.dst_count++;
                  break;
               case ICMP_ECHO:
               case ICMP_TSTAMP:
               case ICMP_IREQ:
               case ICMP_MASKREQ:
                  obj->ws_ip_udp.src_count++;
                  break;
               default:
                  break;
            }
            obj->status |= IP_INIT;
   
         } else {
            ra_icmp_type = ((unsigned char *) &ptr->ws_ip_udp.src_bytes) [0];
            ra_icmp_code = ((unsigned char *) &ptr->ws_ip_udp.src_bytes) [1];
            ra_icmp_data = ((unsigned short *)&ptr->ws_ip_udp.src_bytes) [1];
            ra_src_addr  =  (unsigned long) ptr->ws_ip_udp.dst_bytes;
            ra_dst_addr  =  (unsigned long) ptr->ws_ip_udp.dst_bytes;
            ra_gw_addr  =  (unsigned long) ptr->ws_ip_udp.dst_bytes;
   
            obj->ws_ip_udp.src_count += ptr->ws_ip_udp.src_count;
            obj->ws_ip_udp.dst_count += ptr->ws_ip_udp.dst_count;
         }
         if (obj->status & IP_INIT) {
            obj->status &= ~IP_INIT;
            if (obj->ws_ip_udp.src_count)
               obj->ws_ip_udp.src_count--;
         }
      }
   
      obj->status |= (ptr->status & ~IP_INIT);
   }

   return (retn);
}

update_udp_hash (ptr, obj, tha)
struct WriteStruct *ptr, *obj;
struct tha *tha;
{
   int retn = 0;

   double thisstartime = 0.0, thislasttime = 0.0;
   double thatstartime = 0.0, thatlasttime = 0.0;

   thisstartime =(double)((double)ptr->ws_ip.startime.tv_sec +
                         ((double)ptr->ws_ip.startime.tv_usec/1000000.0));
   thislasttime =(double)((double)ptr->ws_ip.lasttime.tv_sec +
                         ((double)ptr->ws_ip.lasttime.tv_usec/1000000.0));
       
   thatstartime =(double)((double)obj->ws_ip.startime.tv_sec +
                         ((double)obj->ws_ip.startime.tv_usec/1000000.0));
   thatlasttime =(double)((double)obj->ws_ip.lasttime.tv_sec +
                         ((double)obj->ws_ip.lasttime.tv_usec/1000000.0));
       
   if ((thislasttime - thatstartime) > 86400) {
      swapwsheader (ptr, obj, tha);
   } else {
      if (thatstartime > thisstartime)
         obj->ws_ip.startime = ptr->ws_ip.startime;
      if (thatlasttime < thislasttime)
         obj->ws_ip.lasttime = ptr->ws_ip.lasttime;
 
      if (ptr->status & CON_ESTABLISHED) {
         if ((ptr->ws_ip_udp.src_count == 1)&&(ptr->ws_ip_udp.dst_count == 1)) {
            *obj = *ptr;
         } else {
            obj->status |= ptr->status & ~IP_INIT;
            obj->ws_ip_udp.src_count += ptr->ws_ip_udp.src_count;
            obj->ws_ip_udp.dst_count += ptr->ws_ip_udp.dst_count;
            obj->ws_ip_udp.src_bytes += ptr->ws_ip_udp.src_bytes;
            obj->ws_ip_udp.dst_bytes += ptr->ws_ip_udp.dst_bytes;
         }
      }
   }

   retn = 1;
   return (retn);
}

update_tcp_hash (ptr, obj, rev)
struct WriteStruct *ptr, *obj;
int *rev;
{
   int retn = 0;
   double thisstartime = 0.0, thislasttime = 0.0;
   double thatstartime = 0.0, thatlasttime = 0.0;

   obj->status |= (ptr->status & ~REVERSE);
   if (ptr->status & NORMAL_CLOSE) obj->status &= ~(TIMED_OUT | RESET);
   if (rev) {
      obj->ws_ip_tcp.src_count += ptr->ws_ip_tcp.dst_count;
      obj->ws_ip_tcp.dst_count += ptr->ws_ip_tcp.src_count;
      obj->ws_ip_tcp.src_bytes += ptr->ws_ip_tcp.dst_bytes;
      obj->ws_ip_tcp.dst_bytes += ptr->ws_ip_tcp.src_bytes;
   } else {
      obj->ws_ip_tcp.src_count += ptr->ws_ip_tcp.src_count;
      obj->ws_ip_tcp.dst_count += ptr->ws_ip_tcp.dst_count;
      obj->ws_ip_tcp.src_bytes += ptr->ws_ip_tcp.src_bytes;
      obj->ws_ip_tcp.dst_bytes += ptr->ws_ip_tcp.dst_bytes;
   }

   thisstartime =(double)((double)ptr->ws_ip.startime.tv_sec +
                         ((double)ptr->ws_ip.startime.tv_usec/1000000.0));
   thislasttime =(double)((double)ptr->ws_ip.lasttime.tv_sec +
                         ((double)ptr->ws_ip.lasttime.tv_usec/1000000.0));

   thatstartime =(double)((double)obj->ws_ip.startime.tv_sec +
                        ((double)obj->ws_ip.startime.tv_usec/1000000.0));
   thatlasttime =(double)((double)obj->ws_ip.lasttime.tv_sec +
                        ((double)obj->ws_ip.lasttime.tv_usec/1000000.0));

   if (thatstartime > thisstartime)
      obj->ws_ip.startime = ptr->ws_ip.startime;
   if (thatlasttime < thislasttime)
      obj->ws_ip.lasttime = ptr->ws_ip.lasttime;

   retn = 1;
   return (retn);
}


create_tha (ptr, tha, proto, rev)
struct WriteStruct *ptr;
struct tha *tha;
unsigned int proto, *rev;
{
   unsigned int port;
   unsigned short dport, sport;
   unsigned int daddr, saddr;


   bzero ((unsigned char *) tha, sizeof(*tha));

   switch (proto) {
      case TCPPROTO:    
      case UDPPROTO:    
      case  IPPROTO:    
         saddr = ptr->ws_ip.src.s_addr;
         daddr = ptr->ws_ip.dst.s_addr;
         sport = ((unsigned short *) &ptr->ws_ip.port)[0];
         dport = ((unsigned short *) &ptr->ws_ip.port)[1];

         if (dport > sport || ((sport == dport) && (saddr < daddr))) {
            tha->src.s_addr = daddr, tha->dst.s_addr = saddr;
            ((unsigned short *)&tha->port)[0] = dport;
            ((unsigned short *)&tha->port)[1] = sport;       
            rev++;
         } else {
            tha->src.s_addr = saddr, tha->dst.s_addr = daddr;
            tha->port = ptr->ws_ip.port;
         }
         break;

      case ICMPPROTO: {
         unsigned int icmpData = 0;
         unsigned char  ra_icmp_type, ra_icmp_code;
         unsigned short ra_icmp_data;
         unsigned long  ra_src_addr = 0, ra_dst_addr = 0, ra_gw_addr = 0;
         struct icmpWriteStruct *icmp;

         icmp = &ptr->ws_ip_icmp;

         if (!(ptr->status & (CON_ESTABLISHED | TIMED_OUT))) {
            ra_icmp_type = icmp->type;
            ra_icmp_code = icmp->code;
            ra_icmp_data = icmp->data;
            ra_src_addr =  icmp->srcaddr.s_addr;
            ra_dst_addr =  icmp->dstaddr.s_addr;
            ra_gw_addr  =  icmp->gwaddr.s_addr;
   
         } else {
            ra_icmp_type = ((unsigned char *) &ptr->ws_ip_udp.src_bytes) [0];
            ra_icmp_code = ((unsigned char *) &ptr->ws_ip_udp.src_bytes) [1];
            ra_icmp_data = ((unsigned short *)&ptr->ws_ip_udp.src_bytes) [1];
            ra_src_addr  =  (unsigned long) ptr->ws_ip_udp.dst_bytes;
            ra_dst_addr  =  (unsigned long) ptr->ws_ip_udp.dst_bytes;
            ra_gw_addr  =  (unsigned long) ptr->ws_ip_udp.dst_bytes;
         }

   
         switch (ra_icmp_type) {
            case ICMP_ECHOREPLY:
               ra_icmp_type = ICMP_ECHO;
               ra_icmp_data = 0;
               tha->src.s_addr = ptr->ws_ip.dst.s_addr;
               tha->dst.s_addr = ptr->ws_ip.src.s_addr;
               break;
            case ICMP_TSTAMPREPLY:
               ra_icmp_type = ICMP_TSTAMP;
               tha->src.s_addr = ptr->ws_ip.dst.s_addr;
               tha->dst.s_addr = ptr->ws_ip.src.s_addr;
               break;
            case ICMP_IREQREPLY:
               ra_icmp_type = ICMP_IREQ;
               tha->src.s_addr = ptr->ws_ip.dst.s_addr;
               tha->dst.s_addr = ptr->ws_ip.src.s_addr;
               break;
            case ICMP_MASKREPLY:
               ra_icmp_type = ICMP_MASKREQ;
               tha->src.s_addr = ptr->ws_ip.dst.s_addr;
               tha->dst.s_addr = ptr->ws_ip.src.s_addr;
               break;

            case ICMP_ECHO:
               ra_icmp_data = 0;
            default:
               tha->src.s_addr = ptr->ws_ip.src.s_addr;
               tha->dst.s_addr = ptr->ws_ip.dst.s_addr;
               break;
         }
   
         ((unsigned char  *)&icmpData)[0] = ra_icmp_type;
         ((unsigned char  *)&icmpData)[1] = ra_icmp_code;
         ((unsigned short *)&icmpData)[1] = ra_icmp_data;
         tha->port = (unsigned int) icmpData;
   
         break;
      }
   }

   return (1);
}

struct WriteStruct *
find_hash_entry (table, tha)
struct HASH_TABLE *table;
struct tha *tha;
{
   struct WriteStruct *retn = NULL;
   struct HASH_TABLE_HEADER *entry, *start;
   unsigned short hash = 0;
   int i, len, s;

   for (i = 0, len = (sizeof(*tha) / sizeof(hash)); i < len; i++)
      hash += ((unsigned short *)tha)[i];

   if (entry = table->hash_array[hash % TSEQ_HASHSIZE]) {
      start = entry;
      do {
         if (!(bcmp ((char *)tha, (char *)&entry->tha, sizeof(*tha)))) {
            retn = entry->ws;
            break;
         } else
            entry = entry->nxt;
      } while (entry != start);
   }
 
   if (retn)
      table->hash_array[hash % TSEQ_HASHSIZE] = entry;
 
   return (retn);
}

remove_hash_table_entry (table, tha)
struct HASH_TABLE *table;
struct tha *tha;
{
   struct HASH_TABLE_HEADER *retn = NULL;
   struct HASH_TABLE_HEADER *entry = NULL, *start = NULL;
   unsigned short hash = 0;
   int i, len, s;

   for (i = 0, len = (sizeof(*tha) / sizeof(hash)); i < len; i++)
      hash += ((unsigned short *)tha)[i];

   if (entry = table->hash_array[hash % TSEQ_HASHSIZE]) {
      start = entry;
      do {
         if (!(bcmp ((char *)tha, (char *)&entry->tha, sizeof(*tha)))) {
            retn = entry;
            break;
         }
         entry = entry->nxt;
      } while (entry != start);
   }
 
   if (retn) {
      retn->prv->nxt = retn->nxt;
      retn->nxt->prv = retn->prv;
      if (retn == start) {
         if ((retn == retn->nxt) && (retn == retn->prv))
            table->hash_array[hash % TSEQ_HASHSIZE] = NULL;
         else
            table->hash_array[hash % TSEQ_HASHSIZE] = retn->nxt;
      }  
      free (retn);
   }
}

add_hash_table_entry (table, tha, ws)
struct HASH_TABLE *table;
struct tha *tha;
struct WriteStruct *ws;
{
   struct HASH_TABLE_HEADER *retn = NULL, *entry = NULL, *start = NULL;
   unsigned short hash = 0;
   int i, len, s;

   if (table->hash_array) {
      for (i = 0, len = (sizeof(*tha) / sizeof(hash)); i < len; i++)
         hash += ((unsigned short *)tha)[i];

      if (entry = table->hash_array[hash % TSEQ_HASHSIZE]) {
         start = entry;
         do {
            if (!(bcmp ((char *)tha, (char *)&entry->tha, sizeof(*tha)))) {
               retn = entry;
               break;
            }
            entry = entry->nxt;
         } while (entry != start);
      }
      if (retn == NULL) {
         if (retn = (struct HASH_TABLE_HEADER *) calloc (1, sizeof(*retn))) {
            retn->ws = ws;
            retn->hash = hash;
            bcopy ((char *)tha, (char *)&retn->tha, sizeof(*tha));
            if (start) {
               retn->nxt = start;
               retn->prv = start->prv;
               retn->prv->nxt = retn;
               retn->nxt->prv = retn;
            } else {
               retn->prv = retn;
               retn->nxt = retn;
            }
            table->hash_array[hash % TSEQ_HASHSIZE] = retn;
         }
      }
   }
}

hash_connection (ptr, proto)
struct WriteStruct *ptr;
unsigned int proto;
{
   struct WriteStruct *ws;
   struct writeStructHeader *wsh;
   struct tha thabuf, *tha = &thabuf;
   unsigned char type;
   int rev;
   
   if (ws = (struct WriteStruct *) malloc (sizeof(*ws)))
      bcopy ((u_char *) ptr, (u_char *) ws, sizeof(*ws));

   if (create_tha (ws, tha, proto, &rev)) {
      switch (proto) {
         case TCPPROTO:
            if (ptr->status & (NORMAL_CLOSE | RESET))
               break;
            if ((ptr->status & (SAW_SYN | SAW_SYN_SENT)) &&
                (!(ptr->status & CON_ESTABLISHED))) {
               ws->ws_ip_udp.src_bytes = 0;
               ws->ws_ip_udp.dst_bytes = 0;
            }

         case ICMPPROTO:
            if ((ptr->status & (CON_ESTABLISHED | TIMED_OUT)))
               ptr->status &= ~IP_INIT;
         case  IPPROTO:
         case UDPPROTO:
            add_hash_table_entry (&hash_table, tha, ws);
            break;
      }

      if (wsh = (struct writeStructHeader *) calloc (1, sizeof(*wsh))) {
         wsh->ws = ws;
         wsh->src_ttl = src_ttl;
         wsh->dst_ttl = dst_ttl;
         firstpass (wsh);
      }
   }
}

sortws(wsh)
struct writeStructHeader *wsh;
{
   struct timeval *this = NULL, *that = NULL;
   int startIndex = 0, done = 0;
   struct writeStructHeader *wsptr = NULL;
 
   startIndex = wsh->ws->ws_ip.startime.tv_sec - startime;
   if (wsptr = sortArray[startIndex]) {
      this = &wsh->ws->ws_ip.startime;
      do {
         that = &wsptr->ws->ws_ip.startime;
         if (this->tv_usec < that->tv_usec) {
            wsh->nxt = wsptr;
            wsh->prv = wsptr->prv;
            wsh->prv->nxt = wsh;
            wsptr->prv = wsh;
            if (sortArray[startIndex] == wsptr)
               sortArray[startIndex] = wsh;
            done = TRUE;
            break;
         }
         wsptr = wsptr->nxt;
      } while (wsptr != sortArray[startIndex]);
 
      if (!done) {
         wsptr = sortArray[startIndex];
         wsh->nxt = wsptr;
         wsh->prv = wsptr->prv;
         wsh->prv->nxt = wsh;
         wsptr->prv = wsh;
      }  

   } else {
      sortArray[startIndex] = wsh;
      wsh->nxt = wsh;
      wsh->prv = wsh;
   }
}


firstpass (wsh)
struct writeStructHeader *wsh;
{
   long tv_sec = wsh->ws->ws_ip.startime.tv_sec;
 
   if (tv_sec < startime) startime = tv_sec;
   if (tv_sec > endtime)   endtime = tv_sec;

   count++;

   if (!(startwsh)) {
      startwsh = wsh;
      endwsh = wsh;
   } else {
      endwsh->nxt = wsh;
      endwsh = wsh;
   }
   wsh->nxt = NULL;
}

swapwsheader (ptr, obj, tha)
struct WriteStruct *ptr, *obj;
struct tha *tha;
{
   struct HASH_TABLE_HEADER *entry, *start;
   struct writeStructHeader *wsh;
   unsigned short hash = 0;
   int i, len, s, found = 0;

   for (i = 0, len = (sizeof(*tha) / sizeof(hash)); i < len; i++)
      hash += ((unsigned short *)tha)[i];

   if (entry = hash_table.hash_array[hash % TSEQ_HASHSIZE]) {
      start = entry;
      do {
         if (!(bcmp ((char *)tha, (char *)&entry->tha, sizeof(*tha)))) {
            found++;
            break;
         } else
            entry = entry->nxt;
      } while (entry != start);
   }
 
   if (found) {
      struct WriteStruct *ws;

      if (ws = (struct WriteStruct *) malloc (sizeof(*ws))) {
         bcopy ((u_char *) ptr, (u_char *) ws, sizeof(*ws));
         entry->ws = ws;
         if (wsh = (struct writeStructHeader *) calloc (1, sizeof(*wsh))) {
            wsh->ws = ws;
            wsh->src_ttl = src_ttl;
            wsh->dst_ttl = dst_ttl;
            firstpass (wsh);
         }
      } else
         perror ("swapwsheader: malloc failed");
   } else
      perror ("swapwsheader: entry not found");
}


process_tcp (ptr)
struct WriteStruct *ptr;
{
   struct WriteStruct *prvptr;

   ptr->status &= ~DETAIL;
   if (update_hash_connection (ptr, TCPPROTO) == FALSE)
      hash_connection (ptr, TCPPROTO);
}

process_man (ptr)
struct WriteStruct *ptr;
{
}

process_icmp (ptr)
struct WriteStruct *ptr;
{
   if (update_hash_connection (ptr, ICMPPROTO) == FALSE)
      hash_connection (ptr, ICMPPROTO);
}

process_udp (ptr)
struct WriteStruct *ptr;
{
   unsigned short *ports = (unsigned short *)&ptr->ws_ip.port;

   adjust_group_port (ports, ports + 1);
   ptr->status &= ~DETAIL;
   if (update_hash_connection (ptr, UDPPROTO) == FALSE)
      hash_connection (ptr, UDPPROTO);
}

process_ip (ptr)
struct WriteStruct *ptr;
{
   ptr->status &= ~DETAIL;
   if (update_hash_connection (ptr, IPPROTO) == FALSE)
      hash_connection (ptr, IPPROTO);
}

process_arp (ptr)
struct WriteStruct *ptr;
{
}
