
/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 *
 * policy - parse policy configuration and report argus data that
 *          does not conform to this policy.   no policy will report
 *          all data.
 *
 *          this is the principle argus client that uses the client
 *          libraries which provide code to read argus archive files,
 *          attach to remote argus servers, parse policy configuration
 *          files, parse argus data streams and calls data specific
 *          subroutines that are provided in this file.
 *
 *          the principle funciton of this client is to print out
 *          argus data, and its intended use is to review argus data.
 *
 */

#define ARGUS_CLIENT

#if !defined(SOLARIS)
#include <stdlib.h>
#include <unistd.h>
#endif

#if defined(AIX)
#define _SUN 
#include <net/nh.h>
#endif

#include <compat.h>

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

#if !defined(SOLARIS) && !defined(sgi)
#include <strings.h>
#endif

#include <string.h>
#include <time.h>

#include <sys/socket.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>

#include <arpa/inet.h>
#include <netdb.h>

#include <policy.h>

#include <cons_out.h>
#include <argus_parse.h>

#include <pcap.h>
#include <interface.h>
#include <addrtoname.h>
#include <nametoaddr.h>

extern char *get_tcp_string ();
extern char *get_icmp_string ();
extern char *get_ip_string ();
extern char *get_udp_string ();
extern char *get_man_init_string ();
extern char *get_man_stat_string ();

char *appOptstring = NULL;

extern u_char src_ttl, dst_ttl;

init () {}
void argus_parse_complete () {}
void clientTimeout () {}
parse_arg (argc, argv)
int argc;
char**argv;
{}

void
usage (ptr)
char *ptr;
{
   fprintf (stderr, "usage: %s [-bcfghlmnux] ", ptr);
   fprintf (stderr, "[-C access-file] [-d debug-interval] [-F file] [-P port]\n");
   fprintf (stderr, "          [-r input_file] [-s Services_file] [-S argus_server]\n");
   fprintf (stderr, "          [-t time_range] [-w output_file] expression.\n");
   fprintf (stderr, "options: b - dump packet-matching code.\n");
   fprintf (stderr, "         c - print packet and byte counts.\n");
   fprintf (stderr, "         C - specify Cisco access-file.\n");
   fprintf (stderr, "         d - specify detail mode, interval in secs.\n");
   fprintf (stderr, "         f - print local hostnames only\n");
   fprintf (stderr, "         F - use file to define filter expression.\n");
   fprintf (stderr, "         g - print difference in start and last time values.\n");
   fprintf (stderr, "         h - print help.\n");
   fprintf (stderr, "         l - print last time values [default is start time].\n");
   fprintf (stderr, "         m - print MAC addresses.\n");
   fprintf (stderr, "         n - don't convert numbers to names.\n");
   fprintf (stderr, "         P - specify remote argus port.\n");
   fprintf (stderr, "         r - read Argus input file.\n");
   fprintf (stderr, "         S - specify remote argus host.\n");
   fprintf (stderr, "         s - specify remote argus host.\n");
   fprintf (stderr, "         t - specify time_range for search.\n         ");
   fprintf (stderr, "      format:    ");
   fprintf (stderr, "timeSpecification[-timeSpecification]\n");
   fprintf (stderr, "                          timeSpecification: ");
   fprintf (stderr, "[mm/dd[/yy].]hh[:mm[:ss]]\n");
   fprintf (stderr, "                                             ");
   fprintf (stderr, " mm/dd[/yy]\n");
   fprintf (stderr, "         u - print msecs timestamps (*)\n");
   fprintf (stderr, "         w - write Argus output file.\n");
   fprintf (stderr, "         x - flip ports on input (*)\n");
   exit(1);
}


#define FLAGSTRLEN   5

process_man (ptr)
struct WriteStruct *ptr;
{
   int vc = 0;
   char *str;
   char strbuf[256];

   switch (ptr->status & (INIT|STATUS|CLOSE)) {
      case   INIT:  str = get_man_init_string (ptr); break;
      case STATUS:  str = get_man_stat_string (ptr); break;
      case  CLOSE:  str = get_man_stat_string (ptr); break;
   }

   if (str) {
      switch (ptr->status & (INIT|STATUS|CLOSE)) {
         case   INIT: strcat (str, "INT"); ; break;
         case STATUS: strcat (str, "STA"); ; break;
         case  CLOSE: strcat (str, "CLO"); ; break;
      }
   
      (void) printf ("%s\n", str);
      fflush (stdout);
   }
}


process_frag (ptr)
struct WriteStruct *ptr;
{
   int vc = 0;
   char *str;
   char strbuf[256];
   struct fragWriteStruct *frag = &ptr->ws_ip_frag;

   switch (ptr->status & (UDPPROTO|ICMPPROTO|TCPPROTO)) {
      case UDPPROTO:  str = get_udp_string (ptr); break;
      case ICMPPROTO: str = get_icmp_string (ptr); break;
      case TCPPROTO:  str = get_tcp_string (ptr); break;
      default:        str = get_ip_string (ptr); break;
   }

   bcopy ((char *) "frag", (char *)&str[19], 4);

   if (mflag) vc += 17;
   str[vc + 50] = ' ';
   sprintf (&str[vc + 69], " %-5d ", frag->frag_id);

   if (cflag) {
      sprintf (strbuf, "pk %2d  ex %4d  ob %4d  max %4d ",
          frag->fragnum, frag->totlen, frag->currlen,
          frag->maxfraglen);
      strcat (str, strbuf);
   }

   strcat (str, "TIM");
   (void) printf ("%s\n", str);
   fflush (stdout);
}

process_tcp (ptr)
struct WriteStruct *ptr;
{
   printf ("%s\n", get_tcp_string (ptr));
}

process_icmp (ptr)
struct WriteStruct *ptr;
{
   printf ("%s\n", get_icmp_string (ptr));
   fflush (stdout);
}

process_udp (ptr)
struct WriteStruct *ptr;
{
   printf ("%s\n", get_udp_string (ptr));
   fflush (stdout);
}

process_ip (ptr)
struct WriteStruct *ptr;
{
   if (ptr->status & FRAG_ONLY)
      process_frag (ptr);
   else
      printf ("%s\n", get_ip_string (ptr));
   fflush (stdout);
}
