

/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * rasort - sort an argus file based on starttime.
 *
 */

#define ARGUS_CLIENT

#include <stdlib.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <compat.h>

#include <stdio.h>
#include <sys/time.h>
#ifndef SOLARIS
#include <strings.h>
#endif
#include <string.h>

#include <cons_out.h>
#include <argus_parse.h>

#ifndef TRUE
#define TRUE   ~0
#endif

char *appOptstring = NULL;

struct FILE_ENTRY {
   struct FILE_ENTRY *nxt;
   char *str;
};

extern char *progname, *wfile;
extern int major_version, minor_version;
extern struct FILE_ENTRY *input_file_list;

void usage();

int count = 0;
unsigned int startime = 0;
unsigned int endtime = 0;


struct writeStructHeader {
   struct writeStructHeader *nxt, *prv;
   struct WriteStruct *ws, *wsorig;
};
 
struct writeStructHeader **sortArray = NULL;
struct writeStructHeader *startwsh = NULL;
struct writeStructHeader *endwsh = NULL;


void sortws();
void printoutdata();
void firstpass();
void process();

extern int dowriteout;
void
init () {
   struct FILE_ENTRY *ptr = NULL;
   struct timeval tvp;

   dowriteout = 0;
   if (ptr = input_file_list) {
      if (ptr->nxt) {
         fprintf (stderr, "%s: only one input file at a time.\n", progname);
         usage (progname);
      }
   }

   if (!(wfile))
      usage (progname);

   if (!(gettimeofday (&tvp, NULL)))
      startime  = tvp.tv_sec;
   else
      startime  = 0xFFFFFFFF;
}

void
argus_parse_complete ()
{
   struct writeStructHeader *wsh = startwsh, *ptr = NULL;

   if (sortArray = (struct writeStructHeader **) calloc (
                 ((endtime - startime) + 1), sizeof (wsh))) {
      while (wsh) {
         ptr = wsh->nxt;
         sortws (wsh);
         wsh = ptr;
      }
      printoutdata (sortArray);
   } else
      perror ("calloc: sortArray");
}

#include <fcntl.h>
#include <sys/stat.h>

extern struct WriteStruct *initCon;
extern struct WriteStruct wsOriginal;

void
printoutdata (array)
struct writeStructHeader *array[];
{
   int len = (endtime - startime) + 1;
   int fd, i, retn, size;
   struct stat buf;
   char buffer[64], *bufptr;

   struct writeStructHeader *wsh;

   if ((fd = open (wfile, O_RDWR | O_APPEND | O_CREAT, 0x1a4)) >= 0) {
      if (fstat (fd, &buf) == 0) {
         if (buf.st_size == 0) {
            bufptr = (char *) initCon; size = sizeof (*initCon);
            if ((write (fd, bufptr, size)) < 0) {
               perror ("write");
               close (fd); unlink (wfile);
               return;
            } 
         }
      } else {
         perror ("fstat");
         close (fd); unlink (wfile);
         return;
      }

      for (i = 0; i < len; i++) {
         if (wsh = sortArray[i]) {
            do {
               if ((write (fd, wsh->wsorig, sizeof (*wsh->ws))) < 0)
                  perror ("write");
               wsh = wsh->nxt;
            } while (wsh != sortArray[i]);
         }
      }
      close (fd);
   }
}


void clientTimeout () {}
void parse_arg (argc, argv)
int argc;
char**argv;
{}

void
usage (ptr)
char *ptr;
{
   fprintf (stderr, "usage: %s [-r inputfile] -w outputfile\n", ptr);
   exit(1);
}


void
process_man (ptr)
struct WriteStruct *ptr;
{
   process (ptr);
}

void
process_tcp (ptr)
struct WriteStruct *ptr;
{
   process (ptr);
}

void
process_udp (ptr)
struct WriteStruct *ptr;
{
   process (ptr);
}

void
process_ip (ptr)
struct WriteStruct *ptr;
{
   process (ptr);
}

void
process_icmp (ptr)
struct WriteStruct *ptr;
{
   process (ptr);
}

void
process (ptr)
struct WriteStruct *ptr;
{
   struct WriteStruct *ws, *wsorig;
   struct writeStructHeader *wsh;

   if (ws = (struct WriteStruct *) malloc (sizeof (*ws)))
      bcopy ((u_char *) ptr, (u_char *) ws, sizeof (*ws));

   if (wsorig = (struct WriteStruct *) malloc (sizeof (*ws)))
      bcopy ((u_char *) &wsOriginal, (u_char *) wsorig, sizeof (*ws));

   if (wsh = (struct writeStructHeader *) malloc (sizeof (*wsh))) {
      wsh->ws = ws;
      wsh->wsorig = wsorig;
      firstpass (wsh);
   }
}


void
firstpass (wsh) 
struct writeStructHeader *wsh;
{
   int tv_sec;

   if (wsh->ws->status & ARGUSCONTROL)
      tv_sec = wsh->ws->ws_stat.now.tv_sec;
   else
      tv_sec = wsh->ws->ws_ip.startime.tv_sec;

   if (tv_sec < startime) startime = tv_sec;
   if (tv_sec > endtime)   endtime = tv_sec;
   count++;
   if (!(startwsh)) {
      startwsh = wsh;
      endwsh = wsh;
   } else {
      endwsh->nxt = wsh;
      endwsh = wsh;
   }
   wsh->nxt = NULL;
}


void
sortws(wsh)
struct writeStructHeader *wsh;
{
   struct argtimeval *this = NULL, *that = NULL;
   int startIndex = 0, done = 0;
   struct writeStructHeader *wsptr = NULL;
   unsigned int tv_sec;

   if (wsh->ws->status & ARGUSCONTROL) {
      tv_sec = wsh->ws->ws_stat.now.tv_sec;
      this = &wsh->ws->ws_stat.startime;
   } else {
      tv_sec = wsh->ws->ws_ip.startime.tv_sec;
      this = &wsh->ws->ws_ip.startime;
   }

   startIndex = tv_sec - startime;
   if (wsptr = sortArray[startIndex]) {
      this = &wsh->ws->ws_ip.startime;
      do {
         
         if (wsptr->ws->status & ARGUSCONTROL)
            that = &wsptr->ws->ws_stat.now;
         else
            that = &wsptr->ws->ws_ip.startime;

         if (this->tv_usec < that->tv_usec) {
            wsh->nxt = wsptr;
            wsh->prv = wsptr->prv;
            wsh->prv->nxt = wsh;
            wsptr->prv = wsh;
            if (sortArray[startIndex] == wsptr)
               sortArray[startIndex] = wsh;
            done = TRUE;
            break;
         }
         wsptr = wsptr->nxt;
      } while (wsptr != sortArray[startIndex]);

      if (!done) {
         wsptr = sortArray[startIndex];
         wsh->nxt = wsptr;
         wsh->prv = wsptr->prv;
         wsh->prv->nxt = wsh;
         wsptr->prv = wsh;
      }
         
   } else {
      sortArray[startIndex] = wsh;
      wsh->nxt = wsh;
      wsh->prv = wsh;
   }
}
