
/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * template - argus client template.
 *
 *  This module must define these routines:
 *
 *   (void) usage ((char *) argv[0]);
 *                    this routine should print the standard usage message
 *                    for the specific application.
 *
 *          init ();
 *                    this is the application specific init
 *                    routine, which is called after all parsing
 *                    initialization is done, prior to reading the
 *                    first argus(1) datum.
 *
 *   (void) clientTimeout ();
 *                    this routine is called every second, when
 *                    the argus client is connected to a remote
 *                    data source using the -S flag.
 *
 *          process_argus_record ((struct writeStruct *) ptr);
 *                    this routine is called from the other record
 *                    processing routines, to provide a common
 *                    argus processing function.
 *
 *          process_man ((struct writeStruct *) ptr);
 *                    this routine should process managment control events;
 *
 *          process_tcp ((struct writeStruct *) ptr);
 *                    this routine should process tcp events;
 *
 *          process_udp ((struct writeStruct *) ptr);
 *                    this routine should process tcp events;
 *
 *          process_icmp ((struct writeStruct *) ptr);
 *                    this routine should process tcp events;
 *
 *          process_ip ((struct writeStruct *) ptr);
 *                    this routine should process tcp events;
 *
 *   (void) argus_parse_complete ();
 *                    this routine will be called after all the
 *                    monitor data has been read.
 *
 *
 *
 *  These modules can optionally extend the common routines functions:
 *
 *          parse_arg (argc, argv)
 *                    this routine can process client specific command
 *                    line options, specified with appOptstring.
 *
 *
 *
 *
 * written by Carter Bullard
 * Software Engineering Institute
 * Carnegie Mellon Univeristy
 *
 */

#define ARGUS_CLIENT

#include <stdlib.h>
#include <unistd.h>

#include <compat.h>

#include <stdio.h>
#include <cons_out.h>


char *appOptstring = NULL;
extern int major_version, minor_version;

init () {}

void argus_parse_complete () {}

void clientTimeout () {}

parse_arg (argc, argv)
int argc;
char**argv;
{}

/*
  this sample usage reflects the capabilities of the common main getopt()
  routines.
*/

void
usage (ptr)
char *ptr;
{
   fprintf (stderr, "usage: %s [-bcfghlmnux] ", ptr);
   fprintf (stderr, "[-C access-file] [-d debug-interval] [-F file] [-P port]\n");
   fprintf (stderr, "          [-r input_file] [-s Services_file] [-S argus_server]\n");
   fprintf (stderr, "          [-t time_range] [-w output_file] expression.\n");
   fprintf (stderr, "options: b - dump packet-matching code.\n");
   fprintf (stderr, "         c - print packet and byte counts.\n");
   fprintf (stderr, "         C - specify Cisco access-file.\n");
   fprintf (stderr, "         d - specify detail mode, interval in secs.\n");
   fprintf (stderr, "         f - print local hostnames only\n");
   fprintf (stderr, "         F - use file to define filter expression.\n");
   fprintf (stderr, "         g - print difference in start and last time values.\n");
   fprintf (stderr, "         h - print help.\n");
   fprintf (stderr, "         l - print last time values [default is start time].\n");
   fprintf (stderr, "         m - print MAC addresses.\n");
   fprintf (stderr, "         n - don't convert numbers to names.\n");
   fprintf (stderr, "         P - specify remote argus port.\n");
   fprintf (stderr, "         r - read Argus input file.\n");
   fprintf (stderr, "         S - specify remote argus host.\n");
   fprintf (stderr, "         s - specify remote argus host.\n");
   fprintf (stderr, "         t - specify time_range for search.\n         ");
   fprintf (stderr, "      format:    ");
   fprintf (stderr, "timeSpecification[-timeSpecification]\n");
   fprintf (stderr, "                          timeSpecification: ");
   fprintf (stderr, "[mm/dd[/yy].]hh[:mm[:ss]]\n");
   fprintf (stderr, "                                             ");
   fprintf (stderr, " mm/dd[/yy]\n");
   fprintf (stderr, "         u - print msecs timestamps (*)\n");
   fprintf (stderr, "         w - write Argus output file.\n");
   fprintf (stderr, "         x - flip ports on input (*)\n");
   exit(1);
}

process_argus_record (ptr)
struct WriteStruct *ptr;
{
}

process_man (ptr)
struct WriteStruct *ptr;
{
   process_argus_record (ptr);
}

process_tcp (ptr)
struct WriteStruct *ptr;
{
   process_argus_record (ptr);
}


process_icmp (ptr)
struct WriteStruct *ptr;
{
   process_argus_record (ptr);
}

process_udp (ptr)
struct WriteStruct *ptr;
{
   process_argus_record (ptr);
}

process_ip (ptr)
struct WriteStruct *ptr;
{
   process_argus_record (ptr);
}

