
/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1988-1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /us/wcb/packages/argus/argus-1.6/common/RCS/util.c,v 1.3 1995/08/28 19:58:38 wcb Exp wcb $ (LBL)";
#endif


#define ARGUS_CLIENT

#include <stdio.h>
#ifdef __STDC__
#include <stdlib.h>
#endif

#include <unistd.h>

#include <errno.h>
#include <ctype.h>
#include <varargs.h>
#include <sys/file.h>
#include <sys/stat.h>
#ifdef HAVE_SOLARIS
#include <fcntl.h>
#endif


#include <sys/types.h>
#include <compat.h>

#if !defined(HAVE_SOLARIS) && !defined(sgi)
#include <strings.h>
#endif

#include <sys/socket.h>
#include <time.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>

#include <arpa/inet.h>
#include <netdb.h>

#include <policy.h>

#include <string.h>

#include <pcap.h>
#include <interface.h>
#include <addrtoname.h>
#include <nametoaddr.h>

#include <cons_out.h>
#include <argus_parse.h>

char * argus_strerror();
int target_flags = 0;

extern int major_version, minor_version;
extern struct tm tm_startime, tm_lasttime;



void print_date(ptr, date)
struct WriteStruct *ptr;
char *date;
{
   struct timeval buf, *time = &buf;
   struct tm *tm;
   double thistime;
   char tmp[32];
   
   if (lflag) {
      thistime = (double)((double)ptr->ws_ip.lasttime.tv_sec +
                          (double)ptr->ws_ip.lasttime.tv_usec/1000000.0);

      tm = &tm_lasttime;
   } else {
      if (gflag) {
         thistime = (double)(((double)ptr->ws_ip.lasttime.tv_sec +
                             ((double)ptr->ws_ip.lasttime.tv_usec/1000000.0)) -
                             ((double)ptr->ws_ip.startime.tv_sec +
                             ((double)ptr->ws_ip.startime.tv_usec/1000000.0)));

         tm = &tm_startime;
      } else {
         thistime = (double)((double)ptr->ws_ip.startime.tv_sec +
                            ((double)ptr->ws_ip.startime.tv_usec/1000000.0));

         tm = &tm_startime;
      }
   }

   if (uflag || gflag) {
      sprintf (date, "                              ");
      sprintf(tmp, "%9.08f", thistime);
      strcpy (&date[18 - strlen(tmp)], tmp);
   } else
      strftime ((char *) date, 128, "%a %m/%d %T", tm);
}

/*
char *interfacestr [INTERFACES] = {"ip", "icmp", "igmp", "ggp",
   "ipnip", "st", "tcp", "ucl", "egp", "igp", "bbn-rcc-mon", "nvp-ii",
*/


#define IPPROTOSTR 99
char *ip_proto_string [IPPROTOSTR] = {"ip", "icmp", "igmp", "ggp",
   "ipnip", "st", "tcp", "ucl", "egp", "igp", "bbn-rcc-mon", "nvp-ii",
   "pup", "argus", "emcon", "xnet", "chaos", "udp", "mux", "dcn-meas",
   "hmp", "prm", "xns-idp", "trunk-1", "trunk-2", "leaf-1", "leaf-2",
   "rdp", "irtp", "iso-tp4", "netblt", "mfe-nsp", "merit-inp", "sep",
   "3pc", "idpr", "xtp", "ddp", "idpr-cmtp", "tp++", "il", "unas",
   "unas", "unas", "unas", "unas", "unas", "unas", "unas", "unas",
   "unas", "unas", "unas", "unas", "unas", "unas", "unas", "unas",
   "unas", "unas", "unas", "any", "cftp", "any", "sat-expak", "kryptolan",
   "rvd", "ippc", "any", "sat-mon", "visa", "ipcv", "cpnx", "cphb", "wsn",
   "pvp", "br-sat-mon", "sun-nd", "wb-mon", "wb-expak", "iso-ip", "vmtp",
   "secure-vmtp", "vines", "ttp", "nsfnet-igp", "dgp", "tcf", "igrp",
   "ospfigp", "sprite-rpc", "larp", "mtp", "ax.25", "ipip", "micp",
   "aes-sp3-d", "etherip", "encap",
};

char *icmptypestr[ICMP_MAXTYPE + 1] = {
   "ECR", "   ", "   ", "UR", "SRC", "RED",
   "   ", "   ", "ECO", "   ", "   ", "TIM",
   "PAR", "TST", "TSR", "IRQ", "IRR", "MAS",
   "MSR",
};    



char argus_strbuf[256];

char *
get_man_init_string (ptr)
struct WriteStruct *ptr;
{
   int i, ind, vc = 0;
   unsigned int state;
   struct tm *tm;
   unsigned int *netAddr, *netMask;
   char *dstString, *srcString, *protoStr;
   char date [128], fmtstr[256], *blankstring = "     ";
   char *processStr = NULL;

   bzero (fmtstr, 256);
   bzero (argus_strbuf, sizeof (argus_strbuf));

   if (uflag) {
      double thistime;
      thistime = (double)((double)ptr->ws_ip.lasttime.tv_sec +
                          (double)ptr->ws_ip.lasttime.tv_usec/1000000.0);
      sprintf(date, "%9.08f", thistime);

   } else
      if (tm = localtime ((time_t *)&ptr->ws_init.now))
         strftime ((char *) date, 128, "%a %m/%d %T", tm);

   protoStr =  "man";

   if (mflag) {
      vc = 17;
      strcpy (fmtstr, 
         "%s %17.17s %17.17s       %3s %15.15s %-5.5s     %15.15s %-5.5s ");
   } else
      strcpy (fmtstr, "%s      %3s %15.15s %-5.5s     %15.15s %-5.5s ");

   if (cflag)
      strcat (fmtstr, "%-6d %-6d  %-9d %-9d");

   netAddr  = (unsigned int *) &ptr->ws_init.localnet;
   if (*netAddr)
      while ((*netAddr & 0xff000000) == 0)
         *netAddr <<= 8;

   netMask = (unsigned int *) &ptr->ws_init.netmask;
   if (*netMask)
      while ((*netMask & 0xff000000) == 0)
         *netMask <<= 8;

   srcString = ipaddr_string (netAddr);
   dstString = ipaddr_string (netMask);

   if (mflag)
      sprintf (argus_strbuf, fmtstr, date,
         blankstring, blankstring, protoStr,
         srcString, blankstring,
         dstString, blankstring,
         0, 0, 0, 0);
   else
      sprintf (argus_strbuf, fmtstr, date, protoStr,
         srcString, blankstring, dstString, blankstring,
         0, 0, 0, 0);

   return (argus_strbuf);
}


char *
get_man_stat_string (ptr)
struct WriteStruct *ptr;
{
   int i, ind, vc = 0;
   unsigned int state;
   struct tm *tm;
   long *netAddr, *netMask;
   char *dstString, *srcString, *protoStr;
   char date [128], fmtstr[256], *blankstring = "     ";
   char *processStr = NULL;

   bzero (fmtstr, 256);
   bzero (argus_strbuf, sizeof (argus_strbuf));

   if (uflag)
      sprintf(date, "%9ld.%-8ld", (unsigned long) ptr->ws_init.now.tv_sec,
	                          (unsigned long) ptr->ws_init.now.tv_usec);
   else
      if (tm = localtime ((time_t *)&ptr->ws_stat.now.tv_sec))
         strftime ((char *) date, 128, "%a %m/%d %T", tm);

   protoStr =  "man";

   if (mflag) {
      vc = 17;
      strcpy (fmtstr, 
         "%s %17.17s %17.17s       %3s  pkts %5d  drops %5d  ");
   } else
      strcpy (fmtstr, "%s      %3s  pkts %5d  drops %5d  ");

   if (cflag) {
      strcat (fmtstr, "ip %3hd %3hd  t %3hd %3hd  u %3hd %3hd  i %3hd %3hd  f %3hd %3hd  ");

      if (mflag)
         sprintf (argus_strbuf, fmtstr, date,
            blankstring, blankstring, protoStr,
            ptr->ws_stat.pktsRcvd, ptr->ws_stat.pktsDrop, 
            ptr->ws_stat.actIPcons, ptr->ws_stat.cloIPcons,
            ptr->ws_stat.actTCPcons, ptr->ws_stat.cloTCPcons,
            ptr->ws_stat.actUDPcons, ptr->ws_stat.cloUDPcons,
            ptr->ws_stat.actICMPcons, ptr->ws_stat.cloICMPcons,
            ptr->ws_stat.actFRAGcons, ptr->ws_stat.cloFRAGcons);
      else
         sprintf (argus_strbuf, fmtstr, date, protoStr,
            ptr->ws_stat.pktsRcvd, ptr->ws_stat.pktsDrop, 
            ptr->ws_stat.actIPcons, ptr->ws_stat.cloIPcons,
            ptr->ws_stat.actTCPcons, ptr->ws_stat.cloTCPcons,
            ptr->ws_stat.actUDPcons, ptr->ws_stat.cloUDPcons,
            ptr->ws_stat.actICMPcons, ptr->ws_stat.cloICMPcons,
            ptr->ws_stat.actFRAGcons, ptr->ws_stat.cloFRAGcons);
   } else {
      strcat (fmtstr, " flows %8d       ");

      if (mflag)
         sprintf (argus_strbuf, fmtstr, date,
            blankstring, blankstring, protoStr,
            ptr->ws_stat.pktsRcvd, ptr->ws_stat.pktsDrop,
            ptr->ws_stat.actIPcons + ptr->ws_stat.cloIPcons +
            ptr->ws_stat.actTCPcons + ptr->ws_stat.cloTCPcons +
            ptr->ws_stat.actUDPcons + ptr->ws_stat.cloUDPcons +
            ptr->ws_stat.actICMPcons + ptr->ws_stat.cloICMPcons +
            ptr->ws_stat.actFRAGcons + ptr->ws_stat.cloFRAGcons);
      else
         sprintf (argus_strbuf, fmtstr, date, protoStr,
            ptr->ws_stat.pktsRcvd, ptr->ws_stat.pktsDrop, 
            ptr->ws_stat.actIPcons + ptr->ws_stat.cloIPcons +
            ptr->ws_stat.actTCPcons + ptr->ws_stat.cloTCPcons +
            ptr->ws_stat.actUDPcons + ptr->ws_stat.cloUDPcons +
            ptr->ws_stat.actICMPcons + ptr->ws_stat.cloICMPcons +
            ptr->ws_stat.actFRAGcons + ptr->ws_stat.cloFRAGcons);
   }

   return (argus_strbuf);
}

char *
get_tcp_string (ptr)
struct WriteStruct *ptr;
{
   int i, src_bytes, dst_bytes, src_count, dst_count, ind, vc = 0;
   unsigned int state;
   struct in_addr *srcAddr, *dstAddr;
   struct ether_addr *esrcAddr, *edstAddr;
   char date[128], fmtstr[256];
   char *dstString, *srcString, *protoStr;
   char *edstString, *esrcString;
   char *processStr = NULL;
   unsigned short srcPort, dstPort;
   u_long port, srcSeq, dstSeq, srcDst, dstDst;

   bzero (fmtstr, 256);
   bzero (argus_strbuf, sizeof (argus_strbuf));
   bzero (date, 128);

   port = ptr->ws_ip.port;

   print_date (ptr, date);

   state = ptr->status & 
         (SAW_SYN | NORMAL_CLOSE | SAW_SYN_SENT | CON_ESTABLISHED);

   protoStr = (nflag > 1) ? "6  " : "tcp";
   if (mflag) {
      vc = 17;
      strcpy (fmtstr, 
         "%s %17.17s %17.17s       %3s %15.15s.%-5.5s  -  %15.15s.%-5.5s ");
   } else
      strcpy (fmtstr, "%s      %3s %15.15s.%-5.5s  -  %15.15s.%-5.5s ");

   if (cflag)
      strcat (fmtstr, "%-6d %-6d  %-9d %-9d");

   if (state) {
      if (state & NORMAL_CLOSE) {
         fmtstr[29 + vc] = '>';
         if (!(state & (SAW_SYN | SAW_SYN_SENT)))
               fmtstr[27 + vc] = '<';
         processStr = process_state_strings[3];
      } else {
         if (ptr->status & DETAIL) {
            if (state & CLOSE_WAITING) {
               fmtstr[27 + vc] = '<'; fmtstr[29 + vc] = '>';
               processStr = process_state_strings[6];
            } else
            if (state & CON_ESTABLISHED) {
               fmtstr[27 + vc] = '<'; fmtstr[29 + vc] = '>';
               processStr = process_state_strings[2];
            } else
            if (state & SAW_SYN_SENT) {
               fmtstr[27 + vc] = '<';
               processStr = process_state_strings[1];
            } else
            if (state & SAW_SYN) {
               fmtstr[29 + vc] = '>';
               processStr = process_state_strings[0];
            }
         } else {
            fmtstr[29 + vc] = '>';
            if (!(state & (SAW_SYN | SAW_SYN_SENT)))
               fmtstr[27 + vc] = '<';
            processStr = process_state_strings[3];
         }
      }
   }

   if (!(ptr->status & (SAW_SYN | SAW_SYN_SENT)) &&
      (!(ptr->ws_ip_tcp.src_count) || !(ptr->ws_ip_tcp.dst_count))) {
      fmtstr[28 + vc] = '?';
   }
   
   if (ptr->status & (SRC_RESET|DST_RESET)) {
      if (ptr->status & DST_RESET) {
         fmtstr[27 + vc] = '<';
         fmtstr[29 + vc] = ' ';
      }

      if (ptr->status & SRC_RESET) {
         fmtstr[27 + vc] = ' ';
         fmtstr[29 + vc] = '>';
      }

      fmtstr[28 + vc] = '|';
      processStr = process_state_strings[5];
   }

   if (ptr->status & TIMED_OUT) {
      fmtstr[28 + vc] = 'o';
      processStr = process_state_strings[4];
   }

   strcat (fmtstr, processStr);

   if (ptr->status & (PKTS_RETRANS)) {
      switch (ptr->status & PKTS_RETRANS) {
         case     PKTS_RETRANS: fmtstr[vc + 3] = '*'; break;
         case SRC_PKTS_RETRANS: fmtstr[vc + 3] = 's'; break;
         case DST_PKTS_RETRANS: fmtstr[vc + 3] = 'd'; break;
      }
   }

   if (ptr->status & IPOPTIONMASK) {
      switch (ptr->status & IPOPTIONMASK) {
         case SSRCROUTE:    fmtstr[vc + 2] = 'S'; break;
         case LSRCROUTE:    fmtstr[vc + 2] = 'L'; break;
         case TIMESTAMP:    fmtstr[vc + 2] = 'T'; break;
         case SECURITY:     fmtstr[vc + 2] = '+'; break;
         case RECORDROUTE:  fmtstr[vc + 2] = 'R'; break;
         case SATNETID:     fmtstr[vc + 2] = 'N'; break;
         case IPOPTIONMASK: fmtstr[vc + 2] = 'E'; break;
         default:           fmtstr[vc + 2] = 'O'; break;
      }
   }
   if (ptr->status & MULTIADDR) fmtstr[vc + 4] = 'M';
   if (ptr->status & FRAGMENTS) fmtstr[vc + 4] = 'F';

   edstAddr = &ptr->ws_ip_phys.etherdst;
   esrcAddr = &ptr->ws_ip_phys.ethersrc;
   srcAddr = &ptr->ws_ip.src; dstAddr = &ptr->ws_ip.dst;
   srcPort = ((unsigned short *) &port)[0];
   dstPort = ((unsigned short *) &port)[1];
   src_count = ptr->ws_ip_tcp.src_count;
   dst_count = ptr->ws_ip_tcp.dst_count;

   if ((ptr->status & SAW_SYN) &&
            !(ptr->status & (SAW_SYN_SENT|CON_ESTABLISHED|RESET))) {
      srcSeq = ptr->ws_ip_inittcp.seq;
      srcDst = ptr->ws_ip_inittcp.addr;
      src_bytes = 0; dst_bytes = 0;
   } else {
      if ((ptr->status & (SAW_SYN | SAW_SYN_SENT)) &&
                         !(ptr->status & (CON_ESTABLISHED))) {
         dstSeq = ptr->ws_ip_inittcp.seq;
         dstDst = ptr->ws_ip_inittcp.addr;
         src_bytes = 0; dst_bytes = 0;
      } else {
         src_bytes = ptr->ws_ip_tcp.src_bytes;
         dst_bytes = ptr->ws_ip_tcp.dst_bytes;
      }
   }

   if (src_bytes < 0) src_bytes = 0;
   if (dst_bytes < 0) dst_bytes = 0;
  
   srcString = ipaddr_string (srcAddr);
   dstString = ipaddr_string (dstAddr);

   esrcString = etheraddr_string ((u_char *) esrcAddr);
   edstString = etheraddr_string ((u_char *) edstAddr);

   if ((srcPort == 20) || ((srcPort >= 6000) && (srcPort < 6010))) {
      int swap27 = 0, swap29 = 0;
      if (fmtstr[27 + vc] == '<') swap27 = 1;
      if (fmtstr[29 + vc] == '>') swap29 = 1;
      if (!(swap27 && swap29)) {
         if (swap27) fmtstr[29 + vc] = '>', fmtstr[27 + vc] = ' ';
         if (swap29) fmtstr[27 + vc] = '<', fmtstr[29 + vc] = ' ';
      }
 
      if (mflag)
         sprintf (argus_strbuf, fmtstr, date,
            edstString, esrcString, protoStr,
            dstString, tcpport_string(dstPort),
            srcString, tcpport_string(srcPort),
            dst_count, src_count, dst_bytes, src_bytes);
      else
         sprintf (argus_strbuf, fmtstr, date, protoStr,
            dstString, tcpport_string(dstPort),
            srcString, tcpport_string(srcPort),
            dst_count, src_count, dst_bytes, src_bytes);
   } else
      if (mflag)
         sprintf (argus_strbuf, fmtstr, date,
            esrcString, edstString, protoStr,
            srcString, tcpport_string(srcPort),
            dstString, tcpport_string(dstPort),
            src_count, dst_count, src_bytes, dst_bytes);
      else
         sprintf (argus_strbuf, fmtstr, date, protoStr,
            srcString, tcpport_string(srcPort),
            dstString, tcpport_string(dstPort),
            src_count, dst_count, src_bytes, dst_bytes);
 
   return (argus_strbuf);
}


char *
get_icmp_string (ptr)
struct WriteStruct *ptr;
{
   int i, vc = 0, rev = 0, hlen, srccnt = 0, dstcnt = 0;
   struct ip *oip;
   struct udphdr *ouh;
   struct icmpWriteStruct *icmp;
   char fmtstr[256], *blankstring = "     ", icmptype[32];
   char extendedstring[32];
   char *dstString, *srcString, *protoStr;
   char *edstString, *esrcString;
   char date[128];
   extern char *timestatmp_fmt;
   extern long timestamp_scale, thiszone;
   extern u_long getnetnumber (), ipaddrtonetmask ();
      
   if (ptr) {
      unsigned char  ra_icmp_type, ra_icmp_code;
      unsigned short ra_icmp_data;
      unsigned long  ra_src_addr = 0, ra_dst_addr = 0, ra_gw_addr = 0;

      icmp = &ptr->ws_ip_icmp;
      bzero (icmptype, sizeof (icmptype));
      bzero (argus_strbuf, sizeof (argus_strbuf));
      bzero (extendedstring, sizeof (extendedstring));
      bzero (icmptype, sizeof (icmptype));
      bzero (date, 128);

      print_date (ptr, date);

      if (!(ptr->status & (CON_ESTABLISHED | TIMED_OUT))) {
         ra_icmp_type = icmp->type;
         ra_icmp_code = icmp->code;
         ra_icmp_data = icmp->data;
         ra_src_addr  = icmp->srcaddr.s_addr;
         ra_dst_addr  = icmp->dstaddr.s_addr;
         ra_gw_addr   = icmp->gwaddr.s_addr;

      } else {
         ra_icmp_type = ((unsigned char *) &ptr->ws_ip_udp.src_bytes) [0];
         ra_icmp_code = ((unsigned char *) &ptr->ws_ip_udp.src_bytes) [1];
         ra_icmp_data = ((unsigned short *)&ptr->ws_ip_udp.src_bytes) [1];
         ra_src_addr  = icmp->gwaddr.s_addr;
         ra_dst_addr  = icmp->gwaddr.s_addr;
         ra_gw_addr   = icmp->gwaddr.s_addr;
      }

      if (ra_icmp_type < (unsigned char) (ICMP_MAXTYPE + 1))
         strcpy (icmptype, icmptypestr[ra_icmp_type]);
      else
         strcpy (icmptype, "UNK");

      switch (ra_icmp_type) {
         case ICMP_UNREACH:
            switch (ra_icmp_code) {
               case ICMP_UNREACH_NET:
                  strcat (icmptype, "N");
                  if (icmp->dstaddr.s_addr) {
                     u_long addr = ra_dst_addr;
                     addr &= ipaddrtonetmask (addr);
                     sprintf (extendedstring, "%s", 
                              ipaddr_string (&addr));
                  }
                  break;
               case ICMP_UNREACH_HOST:
                  strcat (icmptype, "H");
                  if (ra_dst_addr)
                     sprintf (extendedstring, "%s", 
                           ipaddr_string (&ra_dst_addr));
                  break;

               case ICMP_UNREACH_PROTOCOL:
                  strcat (icmptype, "O");
                  if (ra_icmp_data && (ra_icmp_data < IPPROTOSTR))
                     sprintf (extendedstring,"%s",
                        ip_proto_string[ra_icmp_data]);
                  break;

               case ICMP_UNREACH_PORT: {
                  char index = icmp->gwaddr.s_addr;
                  strcat (icmptype, "P"); 

                  if ((ra_icmp_data && ((index < IPPROTOSTR)) && (index > 0))
                          && (minor_version > 5)) {
                     sprintf (extendedstring, "%s port %d",
                        ip_proto_string[index],
                           ra_icmp_data);

                  } else if (ra_icmp_data)
                     sprintf (extendedstring, "%d", ra_icmp_data);
                  break;
               }
               case ICMP_UNREACH_NEEDFRAG:
                  strcat (icmptype, "F"); break;
               case ICMP_UNREACH_SRCFAIL:
                  strcat (icmptype, "S"); break;
            }
            break;

         case ICMP_MASKREPLY:
               if (ra_src_addr)
                  sprintf (extendedstring, "0x%08x", ra_src_addr);
            break;

         case ICMP_REDIRECT:
            switch (ra_icmp_code) {
            case ICMP_REDIRECT_NET:
               (void) sprintf (extendedstring, "net %s",
                         ipaddr_string (&ra_gw_addr));
               break;

            case ICMP_REDIRECT_HOST:
               (void) sprintf (extendedstring, "host %s",
                         ipaddr_string (&ra_gw_addr));
               break;

            case ICMP_REDIRECT_TOSNET:
               (void) sprintf (extendedstring, "tosN %s",
                         ipaddr_string (&ra_gw_addr));
               break;

            case ICMP_REDIRECT_TOSHOST:
               (void) sprintf (extendedstring, "tosH %s",
                         ipaddr_string (&ra_gw_addr));
               break;
            }
            break;

         case ICMP_ECHOREPLY:
            rev = 1;
            break;

         case ICMP_TIMXCEED:
               (void) sprintf (extendedstring, "%s",
                         icmp->code ? "reassembly" : "in-transit");
               break;

         case ICMP_PARAMPROB:
         case ICMP_SOURCEQUENCH:
         case ICMP_ECHO:
         case ICMP_TSTAMP:
         case ICMP_TSTAMPREPLY:
         case ICMP_IREQ:
         case ICMP_IREQREPLY:
         case ICMP_MASKREQ:
         default:
            break;
      }
   
      protoStr = (nflag > 1) ? "1   " : "icmp";

      if (rev) {
         edstString = etheraddr_string ((u_char *) &ptr->ws_ip_phys.ethersrc);
         esrcString = etheraddr_string ((u_char *) &ptr->ws_ip_phys.etherdst);
         dstString = ipaddr_string (&ptr->ws_ip.src);
         srcString = ipaddr_string (&ptr->ws_ip.dst);
      } else {
         esrcString = etheraddr_string ((u_char *) &ptr->ws_ip_phys.ethersrc);
         edstString = etheraddr_string ((u_char *) &ptr->ws_ip_phys.etherdst);
         srcString = ipaddr_string (&ptr->ws_ip.src);
         dstString = ipaddr_string (&ptr->ws_ip.dst);
      }
   
      if (mflag) {
         vc = 17;
         strcpy (fmtstr, 
            "%s %17.17s %17.17s      %-4s %15.15s %-5.5s  -  %15.15s %-5.5s ");
      } else
         strcpy (fmtstr, "%s     %-4s %15.15s %-5.5s  -  %15.15s %-5.5s ");
   
      if (cflag) strcat (fmtstr, "%-6d %-4d %-21.21s ");

      if (rev) {fmtstr[27 + vc] = '<'; fmtstr[29 + vc] = ' ';}
      else     {fmtstr[27 + vc] = ' '; fmtstr[29 + vc] = '>';}
   
      if (ptr->status & CON_ESTABLISHED) {
         srccnt = ptr->ws_ip_udp.src_count;
         dstcnt = ptr->ws_ip_udp.dst_count;
         fmtstr[27 + vc] = ' '; fmtstr[29 + vc] = ' ';
         if (srccnt)
            fmtstr[29 + vc] = '>';
         if (dstcnt)
            fmtstr[27 + vc] = '<';
      } else {
         if (rev) dstcnt = 1;
         else     srccnt = 1;
      }

      strcat (fmtstr, icmptype);
   
      if (ptr->status & IPOPTIONMASK) {
         switch (ptr->status & IPOPTIONMASK) {
            case SSRCROUTE:    fmtstr[vc + 2] = 'S'; break;
            case LSRCROUTE:    fmtstr[vc + 2] = 'L'; break;
            case TIMESTAMP:    fmtstr[vc + 2] = 'T'; break;
            case SECURITY:     fmtstr[vc + 2] = '+'; break;
            case RECORDROUTE:  fmtstr[vc + 2] = 'R'; break;
            case SATNETID:     fmtstr[vc + 2] = 'N'; break;
            case IPOPTIONMASK: fmtstr[vc + 2] = 'E'; break;
            default:           fmtstr[vc + 2] = 'O'; break;
         }
      }
      if (ptr->status & MULTIADDR) fmtstr[vc + 4] = 'M';
      if (ptr->status & FRAGMENTS) fmtstr[vc + 4] = 'F';

/*
   if (mflag)
      sprintf (argus_strbuf, fmtstr, date,
         esrcString, edstString,
         protoStr,
         srcString, udpport_string (srcport), 
         dstString, udpport_string (dstport), 
         ptr->ws_ip_udp.src_count, ptr->ws_ip_udp.dst_count,
         ptr->ws_ip_udp.src_bytes, ptr->ws_ip_udp.dst_bytes);
   else
      sprintf (argus_strbuf, fmtstr, date, protoStr,
         srcString, udpport_string (srcport),
         dstString, udpport_string (dstport), 
         ptr->ws_ip_udp.src_count, ptr->ws_ip_udp.dst_count,
         ptr->ws_ip_udp.src_bytes, ptr->ws_ip_udp.dst_bytes);

*/
      if (mflag) {
         if (cflag) {
            sprintf (argus_strbuf, fmtstr, date, esrcString, edstString,
               protoStr, 
               srcString, blankstring, dstString, blankstring, 
               srccnt, dstcnt, extendedstring);
         } else
            sprintf (argus_strbuf, fmtstr, date, esrcString, edstString,
               protoStr, 
               srcString, blankstring, dstString, blankstring);
      } else {
         if (cflag) {
            sprintf (argus_strbuf, fmtstr, date, protoStr,
               srcString, blankstring, dstString, blankstring,
               srccnt, dstcnt, extendedstring);
         } else
            sprintf (argus_strbuf, fmtstr, date, protoStr,
               srcString, blankstring, dstString, blankstring);
      }
   }

   return (argus_strbuf);
}


char *
get_udp_string (ptr)
struct WriteStruct *ptr;
{
   int i, vc = 0;
   char *blankstring = "*    ";
   char *dstString, *srcString, *udpString;
   char *edstString, *esrcString, *protoStr;
   char date[128], fmtstr[256];
   u_short srcport, dstport;
   extern char *timestatmp_fmt;
   extern long timestamp_scale, thiszone;

   bzero (argus_strbuf, sizeof (argus_strbuf));
   bzero (date, 128);
   esrcString = etheraddr_string ((u_char *) &ptr->ws_ip_phys.ethersrc);
   edstString = etheraddr_string ((u_char *) &ptr->ws_ip_phys.etherdst);
   srcString = ipaddr_string (&ptr->ws_ip.src.s_addr);
   dstString = ipaddr_string (&ptr->ws_ip.dst.s_addr);
   srcport = ((u_short *)&ptr->ws_ip.port)[0];
   dstport = ((u_short *)&ptr->ws_ip.port)[1];

   print_date (ptr, date);

   protoStr = (nflag > 1) ? "17 " : "udp";

   if (mflag) {
      vc = 17;
      strcpy (fmtstr, 
         "%s %17.17s %17.17s       %3s %15.15s.%-5.5s  -  %15.15s.%-5.5s ");
   } else
      strcpy (fmtstr, "%s      %3s %15.15s.%-5.5s  -  %15.15s.%-5.5s ");

   if (cflag)
      strcat (fmtstr, "%-6d %-6d  %-9d %-9d");

   if (ptr->status & IPOPTIONMASK) {
      switch (ptr->status & IPOPTIONMASK) {
         case SSRCROUTE:    fmtstr[vc + 2] = 'S'; break;
         case LSRCROUTE:    fmtstr[vc + 2] = 'L'; break;
         case TIMESTAMP:    fmtstr[vc + 2] = 'T'; break;
         case SECURITY:     fmtstr[vc + 2] = '+'; break;
         case RECORDROUTE:  fmtstr[vc + 2] = 'R'; break;
         case SATNETID:     fmtstr[vc + 2] = 'N'; break;
         case IPOPTIONMASK: fmtstr[vc + 2] = 'E'; break;
         default:           fmtstr[vc + 2] = 'O'; break;
      }
   }
   if (ptr->status & MULTIADDR) fmtstr[vc + 4] = 'M';
   if (ptr->status & FRAGMENTS) fmtstr[vc + 4] = 'F';

   fmtstr[27 + vc] = (ptr->ws_ip_udp.dst_count) ? '<' : ' '; 
   fmtstr[29 + vc] = (ptr->ws_ip_udp.src_count) ? '>' : ' '; 
   if ((ptr->status & TIMED_OUT)) strcat (fmtstr, "TIM");
   else
      if (ptr->ws_ip_udp.src_count && ptr->ws_ip_udp.dst_count)
         if ((ptr->ws_ip_udp.src_count == 1) && (ptr->ws_ip_udp.dst_count == 1))
            strcat (fmtstr, "ACC");
         else strcat (fmtstr, "CON");
      else strcat (fmtstr, "INT");

   if (mflag)
      sprintf (argus_strbuf, fmtstr, date,
         esrcString, edstString,
         protoStr,
         srcString, udpport_string (srcport), 
         dstString, udpport_string (dstport), 
         ptr->ws_ip_udp.src_count, ptr->ws_ip_udp.dst_count,
         ptr->ws_ip_udp.src_bytes, ptr->ws_ip_udp.dst_bytes);
   else
      sprintf (argus_strbuf, fmtstr, date, protoStr,
         srcString, udpport_string (srcport),
         dstString, udpport_string (dstport), 
         ptr->ws_ip_udp.src_count, ptr->ws_ip_udp.dst_count,
         ptr->ws_ip_udp.src_bytes, ptr->ws_ip_udp.dst_bytes);

   return (argus_strbuf);
}


char *
get_ip_string (ptr)
struct WriteStruct *ptr;
{
   int i, vc = 0;
   char *blankstring = "*    ";
   char *dstString, *srcString, *protoStr ;
   char *edstString, *esrcString;
   char date[128], fmtstr[256], protoStrargus_strbuf[16];
   extern char *timestatmp_fmt;
   extern long timestamp_scale, thiszone;
   int src_count, dst_count, src_bytes, dst_bytes;
   u_char proto;
   
   bzero (argus_strbuf, sizeof (argus_strbuf));
   bzero (date, 128);
   srcString = ipaddr_string (&ptr->ws_ip.src.s_addr);
   dstString = ipaddr_string (&ptr->ws_ip.dst.s_addr);
   esrcString = etheraddr_string ((u_char *) &ptr->ws_ip_phys.ethersrc);
   edstString = etheraddr_string ((u_char *) &ptr->ws_ip_phys.etherdst);
   src_count = ptr->ws_ip_udp.src_count; dst_count = ptr->ws_ip_udp.dst_count;
   src_bytes = ptr->ws_ip_udp.src_bytes; dst_bytes = ptr->ws_ip_udp.dst_bytes;

   print_date (ptr, date);

   if (mflag) {
      vc = 17;
      strcpy (fmtstr, 
            "%s %17.17s %17.17s     %-5.5s%20.20s  -  %20.20s  ");
   } else
      strcpy (fmtstr, "%s     %4s %15.15s        -  %15.15s       ");

   fmtstr[25 + vc] = (dst_count) ? '<' : ' '; 
   fmtstr[27 + vc] = (src_count) ? '>' : ' '; 

   if (cflag)
      strcat (fmtstr, "%-6d %-6d  %-9d %-9d");

   if ((ptr->status & TIMED_OUT)) strcat (fmtstr, "TIM");
   else
      if (ptr->ws_ip_udp.src_count && ptr->ws_ip_udp.dst_count)
         if ((ptr->ws_ip_udp.src_count == 1) && (ptr->ws_ip_udp.dst_count == 1))
            strcat (fmtstr, "ACC");
         else strcat (fmtstr, "CON");
      else if (ptr->status & UDP_INIT) strcat (fmtstr, "INT");

   if (ptr->status & IPOPTIONMASK) {
      switch (ptr->status & IPOPTIONMASK) {
         case SSRCROUTE:    fmtstr[vc + 2] = 'S'; break;
         case LSRCROUTE:    fmtstr[vc + 2] = 'L'; break;
         case TIMESTAMP:    fmtstr[vc + 2] = 'T'; break;
         case SECURITY:     fmtstr[vc + 2] = '+'; break;
         case RECORDROUTE:  fmtstr[vc + 2] = 'R'; break;
         case SATNETID:     fmtstr[vc + 2] = 'N'; break;
         case IPOPTIONMASK: fmtstr[vc + 2] = 'E'; break;
         default:           fmtstr[vc + 2] = 'O'; break;
      }
   }

   if (ptr->status & MULTIADDR) fmtstr[vc + 4] = 'M';
   if (ptr->status & FRAGMENTS) fmtstr[vc + 4] = 'F';

   proto = ptr->ws_ip.port;
   sprintf (protoStrargus_strbuf, "%u", proto);

   protoStr = (nflag > 1) ? protoStrargus_strbuf :
             proto >= IPPROTOSTR ? "unas" : ip_proto_string[proto];

   if (mflag && cflag)
      sprintf (argus_strbuf, fmtstr, date, 
            esrcString, edstString, protoStr,
            srcString, dstString, 
            src_count, dst_count,
            src_bytes, dst_bytes);
   else
   if (cflag)
      sprintf (argus_strbuf, fmtstr, date, protoStr,
            srcString, dstString, 
            src_count, dst_count,
            src_bytes, dst_bytes);
   else
   if (mflag)
      sprintf (argus_strbuf, fmtstr, date, 
            esrcString, edstString,  protoStr,
            srcString, dstString);
   else
      sprintf (argus_strbuf, fmtstr, date, protoStr,
            srcString, dstString);

   return (argus_strbuf);
}


/* Hex digit to integer. */
static inline int
xdtoi(c)
{
   if (isdigit(c))
      return c - '0';
   else if (islower(c))
      return c - 'a' + 10;
   else
      return c - 'A' + 10;
}

/*
 * Convert string to integer.  Just like atoi(), but checks for 
 * preceding 0x or 0 and uses hex or octal instead of decimal.
 */
int
stoi(s)
   char *s;
{
   int base = 10;
   int n = 0;

   if (*s == '0') {
      if (s[1] == 'x' || s[1] == 'X') {
         s += 2;
         base = 16;
      }
      else {
         base = 8;
         s += 1;
      }
   }
   while (*s)
      n = n * base + xdtoi(*s++);

   return n;
}

/*
 * Print out a filename (or other ascii string).
 * Return true if truncated.
 */
int
printfn(s, ep)
   u_char *s, *ep;
{
   u_char c;

   putchar('"');
   while (c = *s++) {
      if (s > ep) {
         putchar('"');
         return(1);
      }
      if (!isascii(c)) {
         c = toascii(c);
         putchar('M');
         putchar('-');
      }
      if (!isprint(c)) {
         c ^= 0x40;   /* DEL to ?, others to alpha */
         putchar('^');
      }
      putchar(c);
   }
   putchar('"');
   return(0);
}


#ifdef NOVFPRINTF
/*
 * Stock 4.3 doesn't have vfprintf. 
 * This routine is due to Chris Torek.
 */
vfprintf(f, fmt, args)
   FILE *f;
   char *fmt;
   va_list args;
{
   int ret;

   if ((f->_flag & _IOWRT) == 0) {
      if (f->_flag & _IORW)
         f->_flag |= _IOWRT;
      else
         return EOF;
   }
   ret = _doprnt(fmt, args, f);
   return ferror(f) ? EOF : ret;
}
#endif

/* VARARGS */
void
error(va_alist)
va_dcl
{
   char *cp;
   va_list ap;

   (void)fprintf(stderr, "connect: ");

   va_start(ap);
   cp = va_arg(ap, char *);
   (void)vfprintf(stderr, cp, ap);
   va_end(ap);
   if (*cp) {
      cp += strlen(cp);
      if (cp[-1] != '\n')
         (void)fputc('\n', stderr);
   }
   exit(1);
   /* NOTREACHED */
}

/* VARARGS */
void
warning(va_alist)
   va_dcl
{
   char *cp;
   va_list ap;

   (void)fprintf(stderr, "connect: warning: ");

   va_start(ap);
   cp = va_arg(ap, char *);
   (void)vfprintf(stderr, cp, ap);
   va_end(ap);
   if (*cp) {
      cp += strlen(cp);
      if (cp[-1] != '\n')
         (void)fputc('\n', stderr);
   }
}

/* A replacement for strdup() that cuts down on malloc() overhead */
char *
savestr(const char *str)
{
        u_int size;
        char *p;
        static char *strptr = NULL;
        static u_int strsize = 0;

        size = strlen(str) + 1;
        if (size > strsize) {
                strsize = 1024;
                if (strsize < size)
                        strsize = size;
                strptr = (char *) malloc(strsize);
                if (strptr == NULL)
                        error("savestr: malloc");
        }
        (void)strcpy(strptr, str);
        p = strptr;
        strptr += size;
        strsize -= size;
        return (p);
}



/*
 * Copy arg vector into a new argus_strbuffer, concatenating arguments with spaces.
 */
char *
copy_argv(argv)
char **argv;
{
   char **p;
   int len = 0;
   char *argus_strbuf;
   char *src, *dst;

   p = argv;
   if (*p == 0)
      return 0;

   while (*p)
      len += strlen(*p++) + 1;

   argus_strbuf = (char *) malloc (len);

   p = argv;
   dst = argus_strbuf;
   while (src = *p++) {
      while (*dst++ = *src++)
         ;
      dst[-1] = ' ';
   }
   dst[-1] = '\0';

   return argus_strbuf;
}

char *
read_infile(fname)
   char *fname;
{
   struct stat argus_strbuf;
   int fd;
   char *p;

   fd = open(fname, O_RDONLY);
   if (fd < 0)
      error("can't open '%s'", fname);

   if (fstat(fd, &argus_strbuf) < 0)
      error("can't state '%s'", fname);

   p = (char *) malloc((unsigned)argus_strbuf.st_size);
   if (read(fd, p, (int)argus_strbuf.st_size) != argus_strbuf.st_size)
      error("problem reading '%s'", fname);
   
   return p;
}

/*
 * Left justify 'addr' and return its resulting network mask.
 */
arg_uint32
net_mask(addr)
arg_uint32 *addr;
{
   arg_uint32 m = 0xffffffff;

   if (*addr)
      while ((*addr & 0xff000000) == 0)
         *addr <<= 8, m <<= 8;

   return m;
}

arg_uint32
ipaddrtonetmask(addr)
arg_uint32 addr;
{
   if (IN_CLASSA (addr)) return IN_CLASSA_NET;
   if (IN_CLASSB (addr)) return IN_CLASSB_NET;
   if (IN_CLASSC (addr)) return IN_CLASSC_NET;
   else return 0;
}


arg_uint32
getnetnumber(addr)
arg_uint32 addr;
{
   if (IN_CLASSA (addr)) return (addr >> 24 );
   if (IN_CLASSB (addr)) return (addr >> 16 );
   if (IN_CLASSC (addr)) return (addr >>  8 );
   else return 0;
}


/*
 * Copyright (c) 1990, 1993, 1994
 *   The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <argus-namedb.h>

#ifndef __GNUC__
#define inline
#endif

static inline int skip_space(FILE *);
static inline int skip_line(FILE *);

static inline int
skip_space(f)
FILE *f;
{
   int c;

   do {
      c = getc(f);
   } while (isspace(c) && c != '\n');

   return c;
}

static inline int
skip_line(f)
   FILE *f;
{
   int c;

   do
      c = getc(f);
   while (c != '\n' && c != EOF);

   return c;
}

struct pcap_etherent *
argus_next_etherent(FILE *fp)
{
   int c, d, i;
   char *bp;
   static struct pcap_etherent e;
   static int nline = 1;
 top:
   while (nline) {
      /* Find addr */
      c = skip_space(fp);
      if (c == '\n')
         continue;
      /* If this is a comment, or first thing on line
         cannot be ethernet address, skip the line. */
      else if (!isxdigit(c))
         c = skip_line(fp);
      else {
         /* must be the start of an address */
         for (i = 0; i < 6; i += 1) {
            d = xdtoi(c);
            c = getc(fp);
            if (c != ':') {
               d <<= 4;
               d |= xdtoi(c);
               c = getc(fp);
            }
            e.addr[i] = d;
            if (c != ':')
               break;
            c = getc(fp);
         }
         nline = 0;
      }
      if (c == EOF)
         return 0;
   }

   /* If we started a new line, 'c' holds the char past the ether addr,
      which we assume is white space.  If we are continuing a line,
      'c' is garbage.  In either case, we can throw it away. */

   c = skip_space(fp);
   if (c == '\n') {
      nline = 1;
      goto top;
   }
   else if (c == '#') {
      (void)skip_line(fp);
      nline = 1;
      goto top;
   }
   else if (c == EOF)
      return 0;

   /* Must be a name. */
   bp = e.name;
   /* Use 'd' to prevent argus_strbuffer overflow. */
   d = sizeof(e.name) - 1;
   do {
      *bp++ = c;
      c = getc(fp);
   } while (!isspace(c) && c != EOF && --d > 0);
   *bp = '\0';
   if (c == '\n')
      nline = 1;

   return &e;
}


/*
 * Copyright (c) 1994
 *   The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *   This product includes software developed by the Computer Systems
 *   Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/param.h>
#include <sys/file.h>
#include <sys/ioctl.h>

#ifdef HAVE_SOLARIS
#include <sys/sockio.h>
#endif

#include <net/if.h>
#include <netinet/in.h>

/* Not all systems have IFF_LOOPBACK */
#ifdef IFF_LOOPBACK
#define ISLOOPBACK(p) ((p)->ifr_flags & IFF_LOOPBACK)
#else
#define ISLOOPBACK(p) (strcmp((p)->ifr_name, "lo0") == 0)
#endif

/*
 * Return the name of a network interface attached to the system, or NULL
 * if none can be found.  The interface must be configured up; the
 * lowest unit number is preferred; loopback is ignored.
 */
char *
argus_lookupdev(ebuf)
char *ebuf;
{
   int fd, minunit, n;
   char *cp;
   struct ifreq *ifrp, *ifend, *ifnext, *mp;
   struct ifconf ifc;
   struct ifreq ibuf[16], ifr;
   static char device[sizeof(ifrp->ifr_name) + 1];

   fd = socket(AF_INET, SOCK_DGRAM, 0);
   if (fd < 0) {
      (void)sprintf(ebuf, "socket: %s", argus_strerror(errno));
      return (NULL);
   }
   ifc.ifc_len = sizeof ibuf;
   ifc.ifc_buf = (caddr_t)ibuf;

   if (ioctl(fd, SIOCGIFCONF, (char *)&ifc) < 0 ||
       ifc.ifc_len < sizeof(struct ifreq)) {
      (void)sprintf(ebuf, "SIOCGIFCONF: %s", argus_strerror(errno));
      (void)close(fd);
      return (NULL);
   }
   ifrp = ibuf;
   ifend = (struct ifreq *)((char *)ibuf + ifc.ifc_len);

   mp = NULL;
   minunit = 666;
   for (; ifrp < ifend; ifrp = ifnext) {
#if BSD - 0 >= 199006
      n = ifrp->ifr_addr.sa_len + sizeof(ifrp->ifr_name);
      if (n < sizeof(*ifrp))
         ifnext = ifrp + 1;
      else
         ifnext = (struct ifreq *)((char *)ifrp + n);
      if (ifrp->ifr_addr.sa_family != AF_INET)
         continue;
#else
      ifnext = ifrp + 1;
#endif
      /*
       * Need a template to preserve address info that is
       * used below to locate the next entry.  (Otherwise,
       * SIOCGIFFLAGS stomps over it because the requests
       * are returned in a union.)
       */
      strncpy(ifr.ifr_name, ifrp->ifr_name, sizeof(ifr.ifr_name));
      if (ioctl(fd, SIOCGIFFLAGS, (char *)&ifr) < 0) {
         (void)sprintf(ebuf, "SIOCGIFFLAGS: %s",
             argus_strerror(errno));
         (void)close(fd);
         return (NULL);
      }

      /* Must be up and not the loopback */
      if ((ifr.ifr_flags & IFF_UP) == 0 || ISLOOPBACK(&ifr))
         continue;

      for (cp = ifrp->ifr_name; !isdigit(*cp); ++cp)
         continue;
      n = atoi(cp);
      if (n < minunit) {
         minunit = n;
         mp = ifrp;
      }
   }
   (void)close(fd);
   if (mp == NULL) {
      (void)strcpy(ebuf, "no suitable device found");
      return (NULL);
   }

   (void)strncpy(device, mp->ifr_name, sizeof(device) - 1);
   device[sizeof(device) - 1] = '\0';
   return (device);
}

int
argus_lookupnet(device, netp, maskp, ebuf)
char *device;
arg_uint32 *netp, *maskp;
char *ebuf;
{
   int fd;
   struct sockaddr_in *sin;
   struct ifreq ifr;

   fd = socket(AF_INET, SOCK_DGRAM, 0);
   if (fd < 0) {
      (void)sprintf(ebuf, "socket: %s", argus_strerror(errno));
      return (-1);
   }
   (void)strncpy(ifr.ifr_name, device, sizeof(ifr.ifr_name));
   if (ioctl(fd, SIOCGIFADDR, (char *)&ifr) < 0) {
      (void)sprintf(ebuf, "SIOCGIFADDR: %s: %s",
          device, argus_strerror(errno));
      (void)close(fd);
      return (-1);
   }
   sin = (struct sockaddr_in *)&ifr.ifr_addr;
   *netp = sin->sin_addr.s_addr;
   if (ioctl(fd, SIOCGIFNETMASK, (char *)&ifr) < 0) {
      (void)sprintf(ebuf, "SIOCGIFNETMASK: %s: %s",
          device, argus_strerror(errno));
      (void)close(fd);
      return (-1);
   }
   (void)close(fd);
   *maskp = sin->sin_addr.s_addr;
   if (*maskp == 0) {
      if (IN_CLASSA(*netp))
         *maskp = IN_CLASSA_NET;
      else if (IN_CLASSB(*netp))
         *maskp = IN_CLASSB_NET;
      else if (IN_CLASSC(*netp))
         *maskp = IN_CLASSC_NET;
      else {
         (void)sprintf(ebuf, "inet class for 0x%x unknown",
             *netp);
         return (-1);
      }
   }
   *netp &= *maskp;
   return (0);
}

static char argus_error[20];

char *
argus_strerror(int errnum)
{
#ifndef HAVE_SYS_ERRLIST
   extern int sys_nerr;
   extern char *sys_errlist[];

   if ((unsigned int)errnum < sys_nerr)
      return ((char *) sys_errlist[errnum]);

   (void)sprintf(argus_error, "Unknown error: %d", errnum);
   return (argus_error);
#else
   return (strerror(errnum));
#endif
}


/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1993, 1994
 *   The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  Optimization module for tcpdump intermediate representation.
 */

#include <sys/time.h>
#include <net/bpf.h>

#ifdef __osf__
#include <malloc.h>
#endif
#include <memory.h>

#include "gencode.h"

#ifdef linux
#include <values.h>
#endif

#define BITS_PER_WORD (8*sizeof(arg_uint32))

#define A_ATOM BPF_MEMWORDS
#define X_ATOM (BPF_MEMWORDS+1)

#define NOP -1

/*
 * This define is used to represent *both* the accumulator and
 * x register in use-def computations.
 * Currently, the use-def code assumes only one definition per instruction.
 */
#define AX_ATOM N_ATOMS

/*
 * A flag to indicate that further optimization is needed.
 * Iterative passes are continued until a given pass yields no
 * branch movement.
 */
static int done;

/*
 * A block is marked if only if its mark equals the current mark.
 * Rather than traverse the code array, marking each item, 'cur_mark' is
 * incremented.  This automatically makes each element unmarked.
 */
static int cur_mark;
#define isMarked(p) ((p)->mark == cur_mark)
#define unMarkAll() cur_mark += 1
#define Mark(p) ((p)->mark = cur_mark)

static void opt_init(struct block *);
static void opt_cleanup(void);

static void make_marks(struct block *);
static void mark_code(struct block *);

static void intern_blocks(struct block *);

static int eq_slist(struct slist *, struct slist *);

static void find_levels_r(struct block *);

static void find_levels(struct block *);
static void find_dom(struct block *);
static void propedom(struct edge *);
static void find_edom(struct block *);
static void find_closure(struct block *);
static int atomuse(struct stmt *);
static int atomdef(struct stmt *);
static void compute_local_ud(struct block *);
static void find_ud(struct block *);
static void init_val(void);
static arg_int32 F(int, arg_int32, arg_int32);
static inline void vstore(struct stmt *, arg_int32 *, arg_int32, int);
static void opt_blk(struct block *, int);
static int use_conflict(struct block *, struct block *);
static void opt_j(struct edge *);
static void or_pullup(struct block *);
static void and_pullup(struct block *);
static void opt_blks(struct block *, int);
static inline void link_inedge(struct edge *, struct block *);
static void find_inedges(struct block *);
static void opt_root(struct block **);
static void opt_loop(struct block *, int);
static void fold_op(struct stmt *, arg_int32, arg_int32);
static inline struct slist *this_op(struct slist *);
static void opt_not(struct block *);
static void opt_peep(struct block *);
static void opt_stmt(struct stmt *, arg_int32[], int);
static void deadstmt(struct stmt *, struct stmt *[]);
static void opt_deadstores(struct block *);
static void opt_blk(struct block *, int);
static int use_conflict(struct block *, struct block *);
static void opt_j(struct edge *);
static struct block *fold_edge(struct block *, struct edge *);
static inline int eq_blk(struct block *, struct block *);
static int slength(struct slist *);
static int count_blocks(struct block *);
static void number_blks_r(struct block *);
static int count_stmts(struct block *);
static void convert_code_r(struct block *);

static int n_blocks;
struct block **blocks;
static int n_edges;
struct edge **edges;

/*
 * A bit vector set representation of the dominators.
 * We round up the set size to the next power of two.
 */
static int nodewords;
static int edgewords;
struct block **levels;
arg_uint32 *space;

/*
 * True if a is in uset {p}
 */
#define SET_MEMBER(p, a) \
((p)[(a) / BITS_PER_WORD] & (1 << ((a) % BITS_PER_WORD)))

/*
 * Add 'a' to uset p.
 */
#define SET_INSERT(p, a) \
(p)[(a) / BITS_PER_WORD] |= (1 << ((a) % BITS_PER_WORD))

/*
 * Delete 'a' from uset p.
 */
#define SET_DELETE(p, a) \
(p)[(a) / BITS_PER_WORD] &= ~(1 << ((a) % BITS_PER_WORD))

/*
 * a := a intersect b
 */
#define SET_INTERSECT(a, b, n)\
{\
   register arg_uint32 *_x = a, *_y = b;\
   register int _n = n;\
   while (--_n >= 0) *_x++ &= *_y++;\
}

/*
 * a := a - b
 */
#define SET_SUBTRACT(a, b, n)\
{\
   register arg_uint32 *_x = a, *_y = b;\
   register int _n = n;\
   while (--_n >= 0) *_x++ &=~ *_y++;\
}

/*
 * a := a union b
 */
#define SET_UNION(a, b, n)\
{\
   register arg_uint32 *_x = a, *_y = b;\
   register int _n = n;\
   while (--_n >= 0) *_x++ |= *_y++;\
}

static uset all_dom_sets;
static uset all_closure_sets;
static uset all_edge_sets;

#ifndef MAX
#define MAX(a,b) ((a)>(b)?(a):(b))
#endif

static void
find_levels_r(b)
   struct block *b;
{
   int level;

   if (isMarked(b))
      return;

   Mark(b);
   b->link = 0;

   if (JT(b)) {
      find_levels_r(JT(b));
      find_levels_r(JF(b));
      level = MAX(JT(b)->level, JF(b)->level) + 1;
   } else
      level = 0;
   b->level = level;
   b->link = levels[level];
   levels[level] = b;
}

/*
 * Level graph.  The levels go from 0 at the leaves to
 * N_LEVELS at the root.  The levels[] array points to the
 * first node of the level list, whose elements are linked
 * with the 'link' field of the struct block.
 */
static void
find_levels(root)
   struct block *root;
{
   memset((char *)levels, 0, n_blocks * sizeof(*levels));
   unMarkAll();
   find_levels_r(root);
}

/*
 * Find dominator relationships.
 * Assumes graph has been leveled.
 */
static void
find_dom(root)
struct block *root;
{
   int i;
   struct block *b;
   arg_uint32 *x;

   /*
    * Initialize sets to contain all nodes.
    */
   x = all_dom_sets;
   i = n_blocks * nodewords;
   while (--i >= 0)
      *x++ = ~0;
   /* Root starts off empty. */
   for (i = nodewords; --i >= 0;)
      root->dom[i] = 0;

   /* root->level is the highest level no found. */
   for (i = root->level; i >= 0; --i) {
      for (b = levels[i]; b; b = b->link) {
         SET_INSERT(b->dom, b->id);
         if (JT(b) == 0)
            continue;
         SET_INTERSECT(JT(b)->dom, b->dom, nodewords);
         SET_INTERSECT(JF(b)->dom, b->dom, nodewords);
      }
   }
}

static void
propedom(ep)
   struct edge *ep;
{
   SET_INSERT(ep->edom, ep->id);
   if (ep->succ) {
      SET_INTERSECT(ep->succ->et.edom, ep->edom, edgewords);
      SET_INTERSECT(ep->succ->ef.edom, ep->edom, edgewords);
   }
}

/*
 * Compute edge dominators.
 * Assumes graph has been leveled and predecessors established.
 */
static void
find_edom(root)
   struct block *root;
{
   int i;
   uset x;
   struct block *b;

   x = all_edge_sets;
   for (i = n_edges * edgewords; --i >= 0; )
      x[i] = ~0;

   /* root->level is the highest level no found. */
   memset(root->et.edom, 0, edgewords * sizeof(*(uset)0));
   memset(root->ef.edom, 0, edgewords * sizeof(*(uset)0));
   for (i = root->level; i >= 0; --i) {
      for (b = levels[i]; b != 0; b = b->link) {
         propedom(&b->et);
         propedom(&b->ef);
      }
   }
}

/*
 * Find the backwards transitive closure of the flow graph.  These sets
 * are backwards in the sense that we find the set of nodes that reach
 * a given node, not the set of nodes that can be reached by a node.
 *
 * Assumes graph has been leveled.
 */
static void
find_closure(root)
   struct block *root;
{
   int i;
   struct block *b;

   /*
    * Initialize sets to contain no nodes.
    */
   memset((char *)all_closure_sets, 0,
         n_blocks * nodewords * sizeof(*all_closure_sets));

   /* root->level is the highest level no found. */
   for (i = root->level; i >= 0; --i) {
      for (b = levels[i]; b; b = b->link) {
         SET_INSERT(b->closure, b->id);
         if (JT(b) == 0)
            continue;
         SET_UNION(JT(b)->closure, b->closure, nodewords);
         SET_UNION(JF(b)->closure, b->closure, nodewords);
      }
   }
}

/*
 * Return the register number that is used by s.  If A and X are both
 * used, return AX_ATOM.  If no register is used, return -1.
 *
 * The implementation should probably change to an array access.
 */
static int
atomuse(s)
   struct stmt *s;
{
   register int c = s->code;

   if (c == NOP)
      return -1;

   switch (BPF_CLASS(c)) {

   case BPF_RET:
      return (BPF_RVAL(c) == BPF_A) ? A_ATOM :
         (BPF_RVAL(c) == BPF_X) ? X_ATOM : -1;

   case BPF_LD:
   case BPF_LDX:
      return (BPF_MODE(c) == BPF_IND) ? X_ATOM :
         (BPF_MODE(c) == BPF_MEM) ? s->k : -1;

   case BPF_ST:
      return A_ATOM;

   case BPF_STX:
      return X_ATOM;

   case BPF_JMP:
   case BPF_ALU:
      if (BPF_SRC(c) == BPF_X)
         return AX_ATOM;
      return A_ATOM;

   case BPF_MISC:
      return BPF_MISCOP(c) == BPF_TXA ? X_ATOM : A_ATOM;
   }
   abort();
   /* NOTREACHED */
}

/*
 * Return the register number that is defined by 's'.  We assume that
 * a single stmt cannot define more than one register.  If no register
 * is defined, return -1.
 *
 * The implementation should probably change to an array access.
 */
static int
atomdef(s)
   struct stmt *s;
{
   if (s->code == NOP)
      return -1;

   switch (BPF_CLASS(s->code)) {

   case BPF_LD:
   case BPF_ALU:
      return A_ATOM;

   case BPF_LDX:
      return X_ATOM;

   case BPF_ST:
   case BPF_STX:
      return s->k;

   case BPF_MISC:
      return BPF_MISCOP(s->code) == BPF_TAX ? X_ATOM : A_ATOM;
   }
   return -1;
}

static void
compute_local_ud(b)
   struct block *b;
{
   struct slist *s;
   atomset def = 0, use = 0, kill = 0;
   int atom;

   for (s = b->stmts; s; s = s->next) {
      if (s->s.code == NOP)
         continue;
      atom = atomuse(&s->s);
      if (atom >= 0) {
         if (atom == AX_ATOM) {
            if (!ATOMELEM(def, X_ATOM))
               use |= ATOMMASK(X_ATOM);
            if (!ATOMELEM(def, A_ATOM))
               use |= ATOMMASK(A_ATOM);
         }
         else if (atom < N_ATOMS) {
            if (!ATOMELEM(def, atom))
               use |= ATOMMASK(atom);
         }
         else
            abort();
      }
      atom = atomdef(&s->s);
      if (atom >= 0) {
         if (!ATOMELEM(use, atom))
            kill |= ATOMMASK(atom);
         def |= ATOMMASK(atom);
      }
   }
   if (!ATOMELEM(def, A_ATOM) && BPF_CLASS(b->s.code) == BPF_JMP)
      use |= ATOMMASK(A_ATOM);

   b->def = def;
   b->kill = kill;
   b->in_use = use;
}

/*
 * Assume graph is already leveled.
 */
static void
find_ud(root)
   struct block *root;
{
   int i, maxlevel;
   struct block *p;

   /*
    * root->level is the highest level no found;
    * count down from there.
    */
   maxlevel = root->level;
   for (i = maxlevel; i >= 0; --i)
      for (p = levels[i]; p; p = p->link) {
         compute_local_ud(p);
         p->out_use = 0;
      }

   for (i = 1; i <= maxlevel; ++i) {
      for (p = levels[i]; p; p = p->link) {
         p->out_use |= JT(p)->in_use | JF(p)->in_use;
         p->in_use |= p->out_use &~ p->kill;
      }
   }
}

/*
 * These data structures are used in a Cocke and Shwarz style
 * value numbering scheme.  Since the flowgraph is acyclic,
 * exit values can be propagated from a node's predecessors
 * provided it is uniquely defined.
 */
struct valnode {
   int code;
   arg_int32 v0, v1;
   arg_int32 val;
   struct valnode *next;
};

#define MODULUS 213
static struct valnode *hashtbl[MODULUS];
static int curval;
static int maxval;

/* Integer constants mapped with the load immediate opcode. */
#define K(i) F(BPF_LD|BPF_IMM|BPF_W, i, 0L)

struct vmapinfo {
   int is_const;
   arg_int32 const_val;
};

struct vmapinfo *vmap;
struct valnode *vnode_base;
struct valnode *next_vnode;

static void
init_val()
{
   curval = 0;
   next_vnode = vnode_base;
   memset((char *)vmap, 0, maxval * sizeof(*vmap));
   memset((char *)hashtbl, 0, sizeof hashtbl);
}

/* Because we really don't have an IR, this stuff is a little messy. */
static arg_int32
F(code, v0, v1)
int code;
arg_int32 v0, v1;
{
   u_int hash;
   int val;
   struct valnode *p;

   hash = (u_int)code ^ (v0 << 4) ^ (v1 << 8);
   hash %= MODULUS;

   for (p = hashtbl[hash]; p; p = p->next)
      if (p->code == code && p->v0 == v0 && p->v1 == v1)
         return p->val;

   val = ++curval;
   if (BPF_MODE(code) == BPF_IMM &&
       (BPF_CLASS(code) == BPF_LD || BPF_CLASS(code) == BPF_LDX)) {
      vmap[val].const_val = v0;
      vmap[val].is_const = 1;
   }
   p = next_vnode++;
   p->val = val;
   p->code = code;
   p->v0 = v0;
   p->v1 = v1;
   p->next = hashtbl[hash];
   hashtbl[hash] = p;

   return val;
}

static inline void
vstore(s, valp, newval, alter)
struct stmt *s;
arg_int32 *valp;
arg_int32 newval;
int alter;
{
   if (alter && *valp == newval)
      s->code = NOP;
   else
      *valp = newval;
}

static void
fold_op(s, v0, v1)
struct stmt *s;
arg_int32 v0, v1;
{
   arg_int32 a, b;

   a = vmap[v0].const_val;
   b = vmap[v1].const_val;

   switch (BPF_OP(s->code)) {
   case BPF_ADD:
      a += b;
      break;

   case BPF_SUB:
      a -= b;
      break;

   case BPF_MUL:
      a *= b;
      break;

   case BPF_DIV:
      if (b == 0)
         bpf_error("division by zero");
      a /= b;
      break;

   case BPF_AND:
      a &= b;
      break;

   case BPF_OR:
      a |= b;
      break;

   case BPF_LSH:
      a <<= b;
      break;

   case BPF_RSH:
      a >>= b;
      break;

   case BPF_NEG:
      a = -a;
      break;

   default:
      abort();
   }
   s->k = a;
   s->code = BPF_LD|BPF_IMM;
   done = 0;
}

static inline struct slist *
this_op(s)
   struct slist *s;
{
   while (s != 0 && s->s.code == NOP)
      s = s->next;
   return s;
}

static void
opt_not(b)
   struct block *b;
{
   struct block *tmp = JT(b);

   JT(b) = JF(b);
   JF(b) = tmp;
}

static void
opt_peep(b)
struct block *b;
{
   struct slist *s;
   struct slist *next, *last;
   int val;
   arg_int32 v;

   s = b->stmts;
   if (s == 0)
      return;

   last = s;
   while (1) {
      s = this_op(s);
      if (s == 0)
         break;
      next = this_op(s->next);
      if (next == 0)
         break;
      last = next;

      /*
       * st  M[k]   -->   st  M[k]
       * ldx M[k]      tax
       */
      if (s->s.code == BPF_ST &&
          next->s.code == (BPF_LDX|BPF_MEM) &&
          s->s.k == next->s.k) {
         done = 0;
         next->s.code = BPF_MISC|BPF_TAX;
      }
      /*
       * ld  #k   -->   ldx  #k
       * tax         txa
       */
      if (s->s.code == (BPF_LD|BPF_IMM) &&
          next->s.code == (BPF_MISC|BPF_TAX)) {
         s->s.code = BPF_LDX|BPF_IMM;
         next->s.code = BPF_MISC|BPF_TXA;
         done = 0;
      }
      /*
       * This is an ugly special case, but it happens
       * when you say tcp[k] or udp[k] where k is a constant.
       */
      if (s->s.code == (BPF_LD|BPF_IMM)) {
         struct slist *add, *tax, *ild;

         /*
          * Check that X isn't used on exit from this
          * block (which the optimizer might cause).
          * We know the code generator won't generate
          * any local dependencies.
          */
         if (ATOMELEM(b->out_use, X_ATOM))
            break;

         if (next->s.code != (BPF_LDX|BPF_MSH|BPF_B))
            add = next;
         else
            add = this_op(next->next);
         if (add == 0 || add->s.code != (BPF_ALU|BPF_ADD|BPF_X))
            break;

         tax = this_op(add->next);
         if (tax == 0 || tax->s.code != (BPF_MISC|BPF_TAX))
            break;

         ild = this_op(tax->next);
         if (ild == 0 || BPF_CLASS(ild->s.code) != BPF_LD ||
             BPF_MODE(ild->s.code) != BPF_IND)
            break;
         /*
          * XXX We need to check that X is not
          * subsequently used.  We know we can eliminate the
          * accumulator modifications since it is defined
          * by the last stmt of this sequence.
          *
          * We want to turn this sequence:
          *
          * (004) ldi     #0x2      {s}
          * (005) ldxms   [14]      {next}  -- optional
          * (006) addx         {add}
          * (007) tax         {tax}
          * (008) ild     [x+0]      {ild}
          *
          * into this sequence:
          *
          * (004) nop
          * (005) ldxms   [14]
          * (006) nop
          * (007) nop
          * (008) ild     [x+2]
          *
          */
         ild->s.k += s->s.k;
         s->s.code = NOP;
         add->s.code = NOP;
         tax->s.code = NOP;
         done = 0;
      }
      s = next;
   }
   /*
    * If we have a subtract to do a comparison, and the X register
    * is a known constant, we can merge this value into the
    * comparison.
    */
   if (last->s.code == (BPF_ALU|BPF_SUB|BPF_X) &&
       !ATOMELEM(b->out_use, A_ATOM)) {
      val = b->val[X_ATOM];
      if (vmap[val].is_const) {
         b->s.k += vmap[val].const_val;
         last->s.code = NOP;
         done = 0;
      } else if (b->s.k == 0) {
         /*
          * sub x  ->   nop
          * j  #0   j  x
          */
         last->s.code = NOP;
         b->s.code = BPF_CLASS(b->s.code) | BPF_OP(b->s.code) |
            BPF_X;
         done = 0;
      }
   }
   /*
    * Likewise, a constant subtract can be simplified.
    */
   else if (last->s.code == (BPF_ALU|BPF_SUB|BPF_K) &&
       !ATOMELEM(b->out_use, A_ATOM)) {
      b->s.k += last->s.k;
      last->s.code = NOP;
      done = 0;
   }
   /*
    * and #k   nop
    * jeq #0  ->   jset #k
    */
   if (last->s.code == (BPF_ALU|BPF_AND|BPF_K) &&
       !ATOMELEM(b->out_use, A_ATOM) && b->s.k == 0) {
      b->s.k = last->s.k;
      b->s.code = BPF_JMP|BPF_K|BPF_JSET;
      last->s.code = NOP;
      done = 0;
      opt_not(b);
   }
   /*
    * If the accumulator is a known constant, we can compute the
    * comparison result.
    */
   val = b->val[A_ATOM];
   if (vmap[val].is_const && BPF_SRC(b->s.code) == BPF_K) {
      v = vmap[val].const_val;
      switch (BPF_OP(b->s.code)) {

      case BPF_JEQ:
         v = v == b->s.k;
         break;

      case BPF_JGT:
         v = v > b->s.k;
         break;

      case BPF_JGE:
         v = v >= b->s.k;
         break;

      case BPF_JSET:
         v &= b->s.k;
         break;

      default:
         abort();
      }
      if (JF(b) != JT(b))
         done = 0;
      if (v)
         JF(b) = JT(b);
      else
         JT(b) = JF(b);
   }
}

/*
 * Compute the symbolic value of expression of 's', and update
 * anything it defines in the value table 'val'.  If 'alter' is true,
 * do various optimizations.  This code would be cleaner if symbolic
 * evaluation and code transformations weren't folded together.
 */
static void
opt_stmt(s, val, alter)
struct stmt *s;
arg_int32 val[];
int alter;
{
   int op;
   arg_int32 v;

   switch (s->code) {

   case BPF_LD|BPF_ABS|BPF_W:
   case BPF_LD|BPF_ABS|BPF_H:
   case BPF_LD|BPF_ABS|BPF_B:
      v = F(s->code, s->k, 0L);
      vstore(s, &val[A_ATOM], v, alter);
      break;

   case BPF_LD|BPF_IND|BPF_W:
   case BPF_LD|BPF_IND|BPF_H:
   case BPF_LD|BPF_IND|BPF_B:
      v = val[X_ATOM];
      if (alter && vmap[v].is_const) {
         s->code = BPF_LD|BPF_ABS|BPF_SIZE(s->code);
         s->k += vmap[v].const_val;
         v = F(s->code, s->k, 0L);
         done = 0;
      }
      else
         v = F(s->code, s->k, v);
      vstore(s, &val[A_ATOM], v, alter);
      break;

   case BPF_LD|BPF_LEN:
      v = F(s->code, 0L, 0L);
      vstore(s, &val[A_ATOM], v, alter);
      break;

   case BPF_LD|BPF_IMM:
      v = K(s->k);
      vstore(s, &val[A_ATOM], v, alter);
      break;

   case BPF_LDX|BPF_IMM:
      v = K(s->k);
      vstore(s, &val[X_ATOM], v, alter);
      break;

   case BPF_LDX|BPF_MSH|BPF_B:
      v = F(s->code, s->k, 0L);
      vstore(s, &val[X_ATOM], v, alter);
      break;

   case BPF_ALU|BPF_NEG:
      if (alter && vmap[val[A_ATOM]].is_const) {
         s->code = BPF_LD|BPF_IMM;
         s->k = -vmap[val[A_ATOM]].const_val;
         val[A_ATOM] = K(s->k);
      }
      else
         val[A_ATOM] = F(s->code, val[A_ATOM], 0L);
      break;

   case BPF_ALU|BPF_ADD|BPF_K:
   case BPF_ALU|BPF_SUB|BPF_K:
   case BPF_ALU|BPF_MUL|BPF_K:
   case BPF_ALU|BPF_DIV|BPF_K:
   case BPF_ALU|BPF_AND|BPF_K:
   case BPF_ALU|BPF_OR|BPF_K:
   case BPF_ALU|BPF_LSH|BPF_K:
   case BPF_ALU|BPF_RSH|BPF_K:
      op = BPF_OP(s->code);
      if (alter) {
         if (s->k == 0) {
            if (op == BPF_ADD || op == BPF_SUB ||
                op == BPF_LSH || op == BPF_RSH ||
                op == BPF_OR) {
               s->code = NOP;
               break;
            }
            if (op == BPF_MUL || op == BPF_AND) {
               s->code = BPF_LD|BPF_IMM;
               val[A_ATOM] = K(s->k);
               break;
            }
         }
         if (vmap[val[A_ATOM]].is_const) {
            fold_op(s, val[A_ATOM], K(s->k));
            val[A_ATOM] = K(s->k);
            break;
         }
      }
      val[A_ATOM] = F(s->code, val[A_ATOM], K(s->k));
      break;

   case BPF_ALU|BPF_ADD|BPF_X:
   case BPF_ALU|BPF_SUB|BPF_X:
   case BPF_ALU|BPF_MUL|BPF_X:
   case BPF_ALU|BPF_DIV|BPF_X:
   case BPF_ALU|BPF_AND|BPF_X:
   case BPF_ALU|BPF_OR|BPF_X:
   case BPF_ALU|BPF_LSH|BPF_X:
   case BPF_ALU|BPF_RSH|BPF_X:
      op = BPF_OP(s->code);
      if (alter && vmap[val[X_ATOM]].is_const) {
         if (vmap[val[A_ATOM]].is_const) {
            fold_op(s, val[A_ATOM], val[X_ATOM]);
            val[A_ATOM] = K(s->k);
         }
         else {
            s->code = BPF_ALU|BPF_K|op;
            s->k = vmap[val[X_ATOM]].const_val;
            done = 0;
            val[A_ATOM] =
               F(s->code, val[A_ATOM], K(s->k));
         }
         break;
      }
      /*
       * Check if we're doing something to an accumulator
       * that is 0, and simplify.  This may not seem like
       * much of a simplification but it could open up further
       * optimizations.
       * XXX We could also check for mul by 1, and -1, etc.
       */
      if (alter && vmap[val[A_ATOM]].is_const
          && vmap[val[A_ATOM]].const_val == 0) {
         if (op == BPF_ADD || op == BPF_OR ||
             op == BPF_LSH || op == BPF_RSH || op == BPF_SUB) {
            s->code = BPF_MISC|BPF_TXA;
            vstore(s, &val[A_ATOM], val[X_ATOM], alter);
            break;
         }
         else if (op == BPF_MUL || op == BPF_DIV ||
             op == BPF_AND) {
            s->code = BPF_LD|BPF_IMM;
            s->k = 0;
            vstore(s, &val[A_ATOM], K(s->k), alter);
            break;
         }
         else if (op == BPF_NEG) {
            s->code = NOP;
            break;
         }
      }
      val[A_ATOM] = F(s->code, val[A_ATOM], val[X_ATOM]);
      break;

   case BPF_MISC|BPF_TXA:
      vstore(s, &val[A_ATOM], val[X_ATOM], alter);
      break;

   case BPF_LD|BPF_MEM:
      v = val[s->k];
      if (alter && vmap[v].is_const) {
         s->code = BPF_LD|BPF_IMM;
         s->k = vmap[v].const_val;
         done = 0;
      }
      vstore(s, &val[A_ATOM], v, alter);
      break;

   case BPF_MISC|BPF_TAX:
      vstore(s, &val[X_ATOM], val[A_ATOM], alter);
      break;

   case BPF_LDX|BPF_MEM:
      v = val[s->k];
      if (alter && vmap[v].is_const) {
         s->code = BPF_LDX|BPF_IMM;
         s->k = vmap[v].const_val;
         done = 0;
      }
      vstore(s, &val[X_ATOM], v, alter);
      break;

   case BPF_ST:
      vstore(s, &val[s->k], val[A_ATOM], alter);
      break;

   case BPF_STX:
      vstore(s, &val[s->k], val[X_ATOM], alter);
      break;
   }
}

static void
deadstmt(s, last)
   register struct stmt *s;
   register struct stmt *last[];
{
   register int atom;

   atom = atomuse(s);
   if (atom >= 0) {
      if (atom == AX_ATOM) {
         last[X_ATOM] = 0;
         last[A_ATOM] = 0;
      }
      else
         last[atom] = 0;
   }
   atom = atomdef(s);
   if (atom >= 0) {
      if (last[atom]) {
         done = 0;
         last[atom]->code = NOP;
      }
      last[atom] = s;
   }
}

static void
opt_deadstores(b)
   register struct block *b;
{
   register struct slist *s;
   register int atom;
   struct stmt *last[N_ATOMS];

   memset((char *)last, 0, sizeof last);

   for (s = b->stmts; s != 0; s = s->next)
      deadstmt(&s->s, last);
   deadstmt(&b->s, last);

   for (atom = 0; atom < N_ATOMS; ++atom)
      if (last[atom] && !ATOMELEM(b->out_use, atom)) {
         last[atom]->code = NOP;
         done = 0;
      }
}

static void
opt_blk(b, do_stmts)
struct block *b;
int do_stmts;
{
   struct slist *s;
   struct edge *p;
   int i;
   arg_int32 aval;

   /*
    * Initialize the atom values.
    * If we have no predecessors, everything is undefined.
    * Otherwise, we inherent our values from our predecessors.
    * If any register has an ambiguous value (i.e. control paths are
    * merging) give it the undefined value of 0.
    */
   p = b->in_edges;
   if (p == 0)
      memset((char *)b->val, 0, sizeof(b->val));
   else {
      memcpy((char *)b->val, (char *)p->pred->val, sizeof(b->val));
      while ((p = p->next) != NULL) {
         for (i = 0; i < N_ATOMS; ++i)
            if (b->val[i] != p->pred->val[i])
               b->val[i] = 0;
      }
   }
   aval = b->val[A_ATOM];
   for (s = b->stmts; s; s = s->next)
      opt_stmt(&s->s, b->val, do_stmts);

   /*
    * This is a special case: if we don't use anything from this
    * block, and we load the accumulator with value that is
    * already there, eliminate all the statements.
    */
   if (do_stmts && b->out_use == 0 && aval != 0 &&
       b->val[A_ATOM] == aval)
      b->stmts = 0;
   else {
      opt_peep(b);
      opt_deadstores(b);
   }
   /*
    * Set up values for branch optimizer.
    */
   if (BPF_SRC(b->s.code) == BPF_K)
      b->oval = K(b->s.k);
   else
      b->oval = b->val[X_ATOM];
   b->et.code = b->s.code;
   b->ef.code = -b->s.code;
}

/*
 * Return true if any register that is used on exit from 'succ', has
 * an exit value that is different from the corresponding exit value
 * from 'b'.
 */
static int
use_conflict(b, succ)
   struct block *b, *succ;
{
   int atom;
   atomset use = succ->out_use;

   if (use == 0)
      return 0;

   for (atom = 0; atom < N_ATOMS; ++atom)
      if (ATOMELEM(use, atom))
         if (b->val[atom] != succ->val[atom])
            return 1;
   return 0;
}

static struct block *
fold_edge(child, ep)
   struct block *child;
   struct edge *ep;
{
   int sense;
   int aval0, aval1, oval0, oval1;
   int code = ep->code;

   if (code < 0) {
      code = -code;
      sense = 0;
   } else
      sense = 1;

   if (child->s.code != code)
      return 0;

   aval0 = child->val[A_ATOM];
   oval0 = child->oval;
   aval1 = ep->pred->val[A_ATOM];
   oval1 = ep->pred->oval;

   if (aval0 != aval1)
      return 0;

   if (oval0 == oval1)
      /*
       * The operands are identical, so the
       * result is true if a true branch was
       * taken to get here, otherwise false.
       */
      return sense ? JT(child) : JF(child);

   if (sense && code == (BPF_JMP|BPF_JEQ|BPF_K))
      /*
       * At this point, we only know the comparison if we
       * came down the true branch, and it was an equality
       * comparison with a constant.  We rely on the fact that
       * distinct constants have distinct value numbers.
       */
      return JF(child);

   return 0;
}

static void
opt_j(ep)
   struct edge *ep;
{
   register int i, k;
   register struct block *target;

   if (JT(ep->succ) == 0)
      return;

   if (JT(ep->succ) == JF(ep->succ)) {
      /*
       * Common branch targets can be eliminated, provided
       * there is no data dependency.
       */
      if (!use_conflict(ep->pred, ep->succ->et.succ)) {
         done = 0;
         ep->succ = JT(ep->succ);
      }
   }
   /*
    * For each edge dominator that matches the successor of this
    * edge, promote the edge successor to the its grandchild.
    *
    * XXX We violate the set abstraction here in favor a reasonably
    * efficient loop.
    */
 top:
   for (i = 0; i < edgewords; ++i) {
      register arg_uint32 x = ep->edom[i];

      while (x != 0) {
         k = ffs(x) - 1;
         x &=~ (1 << k);
         k += i * BITS_PER_WORD;

         target = fold_edge(ep->succ, edges[k]);
         /*
          * Check that there is no data dependency between
          * nodes that will be violated if we move the edge.
          */
         if (target != 0 && !use_conflict(ep->pred, target)) {
            done = 0;
            ep->succ = target;
            if (JT(target) != 0)
               /*
                * Start over unless we hit a leaf.
                */
               goto top;
            return;
         }
      }
   }
}


static void
or_pullup(b)
   struct block *b;
{
   int val, at_top;
   struct block *pull;
   struct block **diffp, **samep;
   struct edge *ep;

   ep = b->in_edges;
   if (ep == 0)
      return;

   /*
    * Make sure each predecessor loads the same value.
    * XXX why?
    */
   val = ep->pred->val[A_ATOM];
   for (ep = ep->next; ep != 0; ep = ep->next)
      if (val != ep->pred->val[A_ATOM])
         return;

   if (JT(b->in_edges->pred) == b)
      diffp = &JT(b->in_edges->pred);
   else
      diffp = &JF(b->in_edges->pred);

   at_top = 1;
   while (1) {
      if (*diffp == 0)
         return;

      if (JT(*diffp) != JT(b))
         return;

      if (!SET_MEMBER((*diffp)->dom, b->id))
         return;

      if ((*diffp)->val[A_ATOM] != val)
         break;

      diffp = &JF(*diffp);
      at_top = 0;
   }
   samep = &JF(*diffp);
   while (1) {
      if (*samep == 0)
         return;

      if (JT(*samep) != JT(b))
         return;

      if (!SET_MEMBER((*samep)->dom, b->id))
         return;

      if ((*samep)->val[A_ATOM] == val)
         break;

      /* XXX Need to check that there are no data dependencies
         between dp0 and dp1.  Currently, the code generator
         will not produce such dependencies. */
      samep = &JF(*samep);
   }
#ifdef notdef
   /* XXX This doesn't cover everything. */
   for (i = 0; i < N_ATOMS; ++i)
      if ((*samep)->val[i] != pred->val[i])
         return;
#endif
   /* Pull up the node. */
   pull = *samep;
   *samep = JF(pull);
   JF(pull) = *diffp;

   /*
    * At the top of the chain, each predecessor needs to point at the
    * pulled up node.  Inside the chain, there is only one predecessor
    * to worry about.
    */
   if (at_top) {
      for (ep = b->in_edges; ep != 0; ep = ep->next) {
         if (JT(ep->pred) == b)
            JT(ep->pred) = pull;
         else
            JF(ep->pred) = pull;
      }
   }
   else
      *diffp = pull;

   done = 0;
}

static void
and_pullup(b)
   struct block *b;
{
   int val, at_top;
   struct block *pull;
   struct block **diffp, **samep;
   struct edge *ep;

   ep = b->in_edges;
   if (ep == 0)
      return;

   /*
    * Make sure each predecessor loads the same value.
    */
   val = ep->pred->val[A_ATOM];
   for (ep = ep->next; ep != 0; ep = ep->next)
      if (val != ep->pred->val[A_ATOM])
         return;

   if (JT(b->in_edges->pred) == b)
      diffp = &JT(b->in_edges->pred);
   else
      diffp = &JF(b->in_edges->pred);

   at_top = 1;
   while (1) {
      if (*diffp == 0)
         return;

      if (JF(*diffp) != JF(b))
         return;

      if (!SET_MEMBER((*diffp)->dom, b->id))
         return;

      if ((*diffp)->val[A_ATOM] != val)
         break;

      diffp = &JT(*diffp);
      at_top = 0;
   }
   samep = &JT(*diffp);
   while (1) {
      if (*samep == 0)
         return;

      if (JF(*samep) != JF(b))
         return;

      if (!SET_MEMBER((*samep)->dom, b->id))
         return;

      if ((*samep)->val[A_ATOM] == val)
         break;

      /* XXX Need to check that there are no data dependencies
         between diffp and samep.  Currently, the code generator
         will not produce such dependencies. */
      samep = &JT(*samep);
   }
#ifdef notdef
   /* XXX This doesn't cover everything. */
   for (i = 0; i < N_ATOMS; ++i)
      if ((*samep)->val[i] != pred->val[i])
         return;
#endif
   /* Pull up the node. */
   pull = *samep;
   *samep = JT(pull);
   JT(pull) = *diffp;

   /*
    * At the top of the chain, each predecessor needs to point at the
    * pulled up node.  Inside the chain, there is only one predecessor
    * to worry about.
    */
   if (at_top) {
      for (ep = b->in_edges; ep != 0; ep = ep->next) {
         if (JT(ep->pred) == b)
            JT(ep->pred) = pull;
         else
            JF(ep->pred) = pull;
      }
   }
   else
      *diffp = pull;

   done = 0;
}

static void
opt_blks(root, do_stmts)
   struct block *root;
   int do_stmts;
{
   int i, maxlevel;
   struct block *p;

   init_val();
   maxlevel = root->level;
   for (i = maxlevel; i >= 0; --i)
      for (p = levels[i]; p; p = p->link)
         opt_blk(p, do_stmts);

   if (do_stmts)
      /*
       * No point trying to move branches; it can't possibly
       * make a difference at this point.
       */
      return;

   for (i = 1; i <= maxlevel; ++i) {
      for (p = levels[i]; p; p = p->link) {
         opt_j(&p->et);
         opt_j(&p->ef);
      }
   }
   for (i = 1; i <= maxlevel; ++i) {
      for (p = levels[i]; p; p = p->link) {
         or_pullup(p);
         and_pullup(p);
      }
   }
}

static inline void
link_inedge(parent, child)
   struct edge *parent;
   struct block *child;
{
   parent->next = child->in_edges;
   child->in_edges = parent;
}

static void
find_inedges(root)
   struct block *root;
{
   int i;
   struct block *b;

   for (i = 0; i < n_blocks; ++i)
      blocks[i]->in_edges = 0;

   /*
    * Traverse the graph, adding each edge to the predecessor
    * list of its successors.  Skip the leaves (i.e. level 0).
    */
   for (i = root->level; i > 0; --i) {
      for (b = levels[i]; b != 0; b = b->link) {
         link_inedge(&b->et, JT(b));
         link_inedge(&b->ef, JF(b));
      }
   }
}

static void
opt_root(b)
   struct block **b;
{
   struct slist *tmp, *s;

   s = (*b)->stmts;
   (*b)->stmts = 0;
   while (BPF_CLASS((*b)->s.code) == BPF_JMP && JT(*b) == JF(*b))
      *b = JT(*b);

   tmp = (*b)->stmts;
   if (tmp != 0)
      sappend(s, tmp);
   (*b)->stmts = s;
}

static void
opt_loop(root, do_stmts)
   struct block *root;
   int do_stmts;
{

#ifdef BDEBUG
   if (dflag > 1)
      opt_dump(root);
#endif
   do {
      done = 1;
      find_levels(root);
      find_dom(root);
      find_closure(root);
      find_inedges(root);
      find_ud(root);
      find_edom(root);
      opt_blks(root, do_stmts);
#ifdef BDEBUG
      if (dflag > 1)
         opt_dump(root);
#endif
   } while (!done);
}

/*
 * Optimize the filter code in its dag representation.
 */
void
bpf_optimize(rootp)
   struct block **rootp;
{
   struct block *root;

   root = *rootp;

   opt_init(root);
   opt_loop(root, 0);
   opt_loop(root, 1);
   intern_blocks(root);
   opt_root(rootp);
   opt_cleanup();
}

static void
make_marks(p)
   struct block *p;
{
   if (!isMarked(p)) {
      Mark(p);
      if (BPF_CLASS(p->s.code) != BPF_RET) {
         make_marks(JT(p));
         make_marks(JF(p));
      }
   }
}

/*
 * Mark code array such that isMarked(i) is true
 * only for nodes that are alive.
 */
static void
mark_code(p)
   struct block *p;
{
   cur_mark += 1;
   make_marks(p);
}

/*
 * True iff the two stmt lists load the same value from the packet into
 * the accumulator.
 */
static int
eq_slist(x, y)
   struct slist *x, *y;
{
   while (1) {
      while (x && x->s.code == NOP)
         x = x->next;
      while (y && y->s.code == NOP)
         y = y->next;
      if (x == 0)
         return y == 0;
      if (y == 0)
         return x == 0;
      if (x->s.code != y->s.code || x->s.k != y->s.k)
         return 0;
      x = x->next;
      y = y->next;
   }
}

static inline int
eq_blk(b0, b1)
   struct block *b0, *b1;
{
   if (b0->s.code == b1->s.code &&
       b0->s.k == b1->s.k &&
       b0->et.succ == b1->et.succ &&
       b0->ef.succ == b1->ef.succ)
      return eq_slist(b0->stmts, b1->stmts);
   return 0;
}

static void
intern_blocks(root)
   struct block *root;
{
   struct block *p;
   int i, j;
   int done;
 top:
   done = 1;
   for (i = 0; i < n_blocks; ++i)
      blocks[i]->link = 0;

   mark_code(root);

   for (i = n_blocks - 1; --i >= 0; ) {
      if (!isMarked(blocks[i]))
         continue;
      for (j = i + 1; j < n_blocks; ++j) {
         if (!isMarked(blocks[j]))
            continue;
         if (eq_blk(blocks[i], blocks[j])) {
            blocks[i]->link = blocks[j]->link ?
               blocks[j]->link : blocks[j];
            break;
         }
      }
   }
   for (i = 0; i < n_blocks; ++i) {
      p = blocks[i];
      if (JT(p) == 0)
         continue;
      if (JT(p)->link) {
         done = 0;
         JT(p) = JT(p)->link;
      }
      if (JF(p)->link) {
         done = 0;
         JF(p) = JF(p)->link;
      }
   }
   if (!done)
      goto top;
}

static void
opt_cleanup()
{
   free((void *)vnode_base);
   free((void *)vmap);
   free((void *)edges);
   free((void *)space);
   free((void *)levels);
   free((void *)blocks);
}

/*
 * Return the number of stmts in 's'.
 */
static int
slength(s)
   struct slist *s;
{
   int n = 0;

   for (; s; s = s->next)
      if (s->s.code != NOP)
         ++n;
   return n;
}

/*
 * Return the number of nodes reachable by 'p'.
 * All nodes should be initially unmarked.
 */
static int
count_blocks(p)
   struct block *p;
{
   if (p == 0 || isMarked(p))
      return 0;
   Mark(p);
   return count_blocks(JT(p)) + count_blocks(JF(p)) + 1;
}

/*
 * Do a depth first search on the flow graph, numbering the
 * the basic blocks, and entering them into the 'blocks' array.`
 */
static void
number_blks_r(p)
   struct block *p;
{
   int n;

   if (p == 0 || isMarked(p))
      return;

   Mark(p);
   n = n_blocks++;
   p->id = n;
   blocks[n] = p;

   number_blks_r(JT(p));
   number_blks_r(JF(p));
}

/*
 * Return the number of stmts in the flowgraph reachable by 'p'.
 * The nodes should be unmarked before calling.
 */
static int
count_stmts(p)
   struct block *p;
{
   int n;

   if (p == 0 || isMarked(p))
      return 0;
   Mark(p);
   n = count_stmts(JT(p)) + count_stmts(JF(p));
   return slength(p->stmts) + n + 1;
}

/*
 * Allocate memory.  All allocation is done before optimization
 * is begun.  A linear bound on the size of all data structures is computed
 * from the total number of blocks and/or statements.
 */
static void
opt_init(root)
   struct block *root;
{
   arg_uint32 *p;
   int i, n, max_stmts;

   /*
    * First, count the blocks, so we can malloc an array to map
    * block number to block.  Then, put the blocks into the array.
    */
   unMarkAll();
   n = count_blocks(root);
   blocks = (struct block **)malloc(n * sizeof(*blocks));
   unMarkAll();
   n_blocks = 0;
   number_blks_r(root);

   n_edges = 2 * n_blocks;
   edges = (struct edge **)malloc(n_edges * sizeof(*edges));

   /*
    * The number of levels is bounded by the number of nodes.
    */
   levels = (struct block **)malloc(n_blocks * sizeof(*levels));

   edgewords = n_edges / (8 * sizeof(arg_uint32)) + 1;
   nodewords = n_blocks / (8 * sizeof(arg_uint32)) + 1;

   /* XXX */
   space = (arg_uint32 *)malloc(2 * n_blocks * nodewords * sizeof(*space)
             + n_edges * edgewords * sizeof(*space));
   p = space;
   all_dom_sets = p;
   for (i = 0; i < n; ++i) {
      blocks[i]->dom = p;
      p += nodewords;
   }
   all_closure_sets = p;
   for (i = 0; i < n; ++i) {
      blocks[i]->closure = p;
      p += nodewords;
   }
   all_edge_sets = p;
   for (i = 0; i < n; ++i) {
      register struct block *b = blocks[i];

      b->et.edom = p;
      p += edgewords;
      b->ef.edom = p;
      p += edgewords;
      b->et.id = i;
      edges[i] = &b->et;
      b->ef.id = n_blocks + i;
      edges[n_blocks + i] = &b->ef;
      b->et.pred = b;
      b->ef.pred = b;
   }
   max_stmts = 0;
   for (i = 0; i < n; ++i)
      max_stmts += slength(blocks[i]->stmts) + 1;
   /*
    * We allocate at most 3 value numbers per statement,
    * so this is an upper bound on the number of valnodes
    * we'll need.
    */
   maxval = 3 * max_stmts;
   vmap = (struct vmapinfo *)malloc(maxval * sizeof(*vmap));
   vnode_base = (struct valnode *)malloc(maxval * sizeof(*vmap));
}

/*
 * Some pointers used to convert the basic block form of the code,
 * into the array form that BPF requires.  'fstart' will point to
 * the malloc'd array while 'ftail' is used during the recursive traversal.
 */
static struct bpf_insn *fstart;
static struct bpf_insn *ftail;

#ifdef BDEBUG
int bids[1000];
#endif

static void
convert_code_r(p)
   struct block *p;
{
   struct bpf_insn *dst;
   struct slist *src;
   int slen;
   u_int off;

   if (p == 0 || isMarked(p))
      return;
   Mark(p);

   convert_code_r(JF(p));
   convert_code_r(JT(p));

   slen = slength(p->stmts);
   dst = ftail -= slen + 1;

   p->offset = dst - fstart;

   for (src = p->stmts; src; src = src->next) {
      if (src->s.code == NOP)
         continue;
      dst->code = (u_short)src->s.code;
      dst->k = src->s.k;
      ++dst;
   }
#ifdef BDEBUG
   bids[dst - fstart] = p->id + 1;
#endif
   dst->code = (u_short)p->s.code;
   dst->k = p->s.k;
   if (JT(p)) {
      off = JT(p)->offset - (p->offset + slen) - 1;
      if (off >= 256)
         bpf_error("long jumps not supported");
      dst->jt = off;
      off = JF(p)->offset - (p->offset + slen) - 1;
      if (off >= 256)
         bpf_error("long jumps not supported");
      dst->jf = off;
   }
}


/*
 * Convert flowgraph intermediate representation to the
 * BPF array representation.  Set *lenp to the number of instructions.
 */
struct bpf_insn *
icode_to_fcode(root, lenp)
   struct block *root;
   int *lenp;
{
   int n;
   struct bpf_insn *fp;

   unMarkAll();
   n = *lenp = count_stmts(root);

   fp = (struct bpf_insn *)malloc(sizeof(*fp) * n);
   memset((char *)fp, 0, sizeof(*fp) * n);
   fstart = fp;
   ftail = fp + n;

   unMarkAll();
   convert_code_r(root);

   return fp;
}

#ifdef BDEBUG
opt_dump(root)
   struct block *root;
{
   struct bpf_program f;

   memset(bids, 0, sizeof bids);
   f.bf_insns = icode_to_fcode(root, &f.bf_len);
   bpf_dump(&f, 1);
   putchar('\n');
   free((char *)f.bf_insns);
}
#endif


/*
 * Copyright (c) 1990, 1991, 1992, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

char *
bpf_image(p, n)
struct bpf_insn *p;
int n;
{
   int v;
   char *fmt, *op;
   static char image[256];
   char operand[64];

   v = p->k;
   switch (p->code) {

   default:
      op = "unimp";
      fmt = "0x%x";
      v = p->code;
      break;

   case BPF_RET|BPF_K:
      op = "ret";
      fmt = "#%d";
      break;

   case BPF_RET|BPF_A:
      op = "ret";
      fmt = "";
      break;

   case BPF_LD|BPF_W|BPF_ABS:
      op = "ld";
      fmt = "[%d]";
      break;

   case BPF_LD|BPF_H|BPF_ABS:
      op = "ldh";
      fmt = "[%d]";
      break;

   case BPF_LD|BPF_B|BPF_ABS:
      op = "ldb";
      fmt = "[%d]";
      break;

   case BPF_LD|BPF_W|BPF_LEN:
      op = "ld";
      fmt = "#pktlen";
      break;

   case BPF_LD|BPF_W|BPF_IND:
      op = "ld";
      fmt = "[x + %d]";
      break;

   case BPF_LD|BPF_H|BPF_IND:
      op = "ldh";
      fmt = "[x + %d]";
      break;

   case BPF_LD|BPF_B|BPF_IND:
      op = "ldb";
      fmt = "[x + %d]";
      break;

   case BPF_LD|BPF_IMM:
      op = "ld";
      fmt = "#0x%x";
      break;

   case BPF_LDX|BPF_IMM:
      op = "ldx";
      fmt = "#0x%x";
      break;

   case BPF_LDX|BPF_MSH|BPF_B:
      op = "ldxb";
      fmt = "4*([%d]&0xf)";
      break;

   case BPF_LD|BPF_MEM:
      op = "ld";
      fmt = "M[%d]";
      break;

   case BPF_LDX|BPF_MEM:
      op = "ldx";
      fmt = "M[%d]";
      break;

   case BPF_ST:
      op = "st";
      fmt = "M[%d]";
      break;

   case BPF_STX:
      op = "stx";
      fmt = "M[%d]";
      break;

   case BPF_JMP|BPF_JA:
      op = "ja";
      fmt = "%d";
      v = n + p->k;
      break;

   case BPF_JMP|BPF_JGT|BPF_K:
      op = "jgt";
      fmt = "#0x%x";
      break;

   case BPF_JMP|BPF_JGE|BPF_K:
      op = "jge";
      fmt = "#0x%x";
      break;

   case BPF_JMP|BPF_JEQ|BPF_K:
      op = "jeq";
      fmt = "#0x%x";
      break;

   case BPF_JMP|BPF_JSET|BPF_K:
      op = "jset";
      fmt = "#0x%x";
      break;

   case BPF_JMP|BPF_JGT|BPF_X:
      op = "jgt";
      fmt = "x";
      break;

   case BPF_JMP|BPF_JGE|BPF_X:
      op = "jge";
      fmt = "x";
      break;

   case BPF_JMP|BPF_JEQ|BPF_X:
      op = "jeq";
      fmt = "x";
      break;

   case BPF_JMP|BPF_JSET|BPF_X:
      op = "jset";
      fmt = "x";
      break;

   case BPF_ALU|BPF_ADD|BPF_X:
      op = "add";
      fmt = "x";
      break;

   case BPF_ALU|BPF_SUB|BPF_X:
      op = "sub";
      fmt = "x";
      break;

   case BPF_ALU|BPF_MUL|BPF_X:
      op = "mul";
      fmt = "x";
      break;

   case BPF_ALU|BPF_DIV|BPF_X:
      op = "div";
      fmt = "x";
      break;

   case BPF_ALU|BPF_AND|BPF_X:
      op = "and";
      fmt = "x";
      break;

   case BPF_ALU|BPF_OR|BPF_X:
      op = "or";
      fmt = "x";
      break;

   case BPF_ALU|BPF_LSH|BPF_X:
      op = "lsh";
      fmt = "x";
      break;

   case BPF_ALU|BPF_RSH|BPF_X:
      op = "rsh";
      fmt = "x";
      break;

   case BPF_ALU|BPF_ADD|BPF_K:
      op = "add";
      fmt = "#%d";
      break;

   case BPF_ALU|BPF_SUB|BPF_K:
      op = "sub";
      fmt = "#%d";
      break;

   case BPF_ALU|BPF_MUL|BPF_K:
      op = "mul";
      fmt = "#%d";
      break;

   case BPF_ALU|BPF_DIV|BPF_K:
      op = "div";
      fmt = "#%d";
      break;

   case BPF_ALU|BPF_AND|BPF_K:
      op = "and";
      fmt = "#%d";
      break;

   case BPF_ALU|BPF_OR|BPF_K:
      op = "or";
      fmt = "#%d";
      break;

   case BPF_ALU|BPF_LSH|BPF_K:
      op = "lsh";
      fmt = "#%d";
      break;

   case BPF_ALU|BPF_RSH|BPF_K:
      op = "rsh";
      fmt = "#%d";
      break;

   case BPF_ALU|BPF_NEG:
      op = "neg";
      fmt = "";
      break;

   case BPF_MISC|BPF_TAX:
      op = "tax";
      fmt = "";
      break;

   case BPF_MISC|BPF_TXA:
      op = "txa";
      fmt = "";
      break;
   }
   (void)sprintf(operand, fmt, v);
   (void)sprintf(image,
            (BPF_CLASS(p->code) == BPF_JMP &&
             BPF_OP(p->code) != BPF_JA) ?
            "(%03d) %-8s %-16s jt %d\tjf %d"
            : "(%03d) %-8s %s",
            n, op, operand, n + 1 + p->jt, n + 1 + p->jf);
   return image;
}
