
/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */



struct TIME_ENTRY {
   struct TIME_ENTRY *nxt;
   arg_uint32 startime;
   arg_uint32 lasttime;
};

struct PORT_ENTRY {
   struct PORT_ENTRY *nxt;
   arg_uint32 port_num;
};

struct ETHER_ENTRY {
   struct ETHER_ENTRY *nxt;
   struct ether_addr eaddr;
   arg_int32 test;
};

struct STAT {
   arg_int32 pkts, bytes;
   double pkts_sqrd, bytes_sqrd;
   double bytes_per_pkt, bytes_per_pkt_sqrd;
};

struct STATISTICS {
   arg_int32 cons;
   double secs, secs_sqrd;
   struct STAT src;
   struct STAT dst;
};

struct PORT {
   struct PORT *prv, *nxt;
   arg_uint16 port, proto;
   struct STATISTICS stats;
};

struct NET_OBJECT_PTR {
   struct NET_OBJECT_PTR *prv, *nxt;
   struct NET_OBJECT *net_obj;
};

struct NET_OBJECT {
   struct QUEUE_HEADER  queue;
   struct NET_OBJECT   *nxt;
   struct IP_ENTRY     *ip_addr;
   struct STATISTICS    src_stats;
   struct STATISTICS    dst_stats;
   struct NET_OBJECT   *group;
   struct NETWORK      *net;
   struct PORT         *ports;
   struct WriteStructHeader  *wsh;
   arg_int32 type;
   arg_int32 index;
};

struct SRV_OBJECT {
   struct QUEUE_HEADER  queue;
   struct SRV_OBJECT   *nxt;
   struct IP_ENTRY     *ip_addr;
   struct STATISTICS    src_stats;
   struct STATISTICS    dst_stats;
   struct NET_OBJECT   *group;
   struct NETWORK      *net;
   struct WriteStructHeader  *wsh;
   arg_int32 type;
   arg_int32 index;
   struct NET_OBJECT   *obj_hash_seq [TSEQ_HASHSIZE];
};

struct NETWORK {
   struct QUEUE_HEADER queue;
   struct QUEUE list;
   struct NETWORK *nxt;
   struct NET_OBJECT net;
   struct NET_OBJECT_PTR *ent;
   arg_uint32  ip_net;
   arg_uint32  ip_mask;
   arg_int32 hosts;
};
