
/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * argus - audit tcp, udp and icmp connection traffic on an network.
 *         relies on libpcap for packet filter function.
 *
 * written by Carter Bullard
 * Software Engineering Institute
 * Carnegie Mellon Univeristy
 *
 */

#define ARGUS


#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

#if !defined(HAVE_SOLARIS)
#include <stdlib.h>
#include <strings.h>
#endif

#include <string.h>
#include <time.h>
#include <errno.h>

#include <signal.h>

#include <netinet/in.h>
#include <netinet/tcp.h>

#include <compat.h>
#include <pcap.h>
#include <interface.h>

#include <argus.h>


static int bpflag = 0;    /* print filter code */
static int Oflag = 1;     /* run filter code optimizer */
static int pflag = 0;     /* don't go promiscuous */

static pcap_t *init ();
arg_uint32 localnet, netmask;

char *rfile = NULL;
char *servicesfile = NULL;

#ifndef MAXPATHNAMELEN
#define MAXPATHNAMELEN   BUFSIZ
#endif

int debug_interval = 300;

int
main (argc, argv)
int argc;
char *argv[];
{
   int i, len, op, type, portnum = ARGUS_PORT, divisor;
   static char *device = NULL, *infile = NULL, *ptr;
   static char path[MAXPATHNAMELEN];
   pcap_handler callback;
   extern char *optarg;
   extern int optind, opterr;
   double update_interval = 0.20;

   if (strchr (argv[0], '/')) {
      strcpy(path, argv[0]);
      argv[0] = strrchr(argv[0], '/') + 1;
   }
   program_name = argv[0];

   opterr = 0;
   while ((op = getopt (argc, argv, "bChpOd:r:w:D:F:i:l:P:U:S:T:I:")) != EOF) {
      switch (op) {
         case 'b': bpflag++; break;
         case 'C': Cflag++; break;
         case 'p': pflag++; break;
         case 'O': Oflag = 0; break;
         case 'd': dflag = atoi (optarg); break;
         case 'P': portnum = atoi (optarg); break;
         case 'U': udptimeout = atoi (optarg); break;
         case 'T': tcptimeout = atoi (optarg); break;
         case 'I':  iptimeout = atoi (optarg); break;
         case 'i': device = optarg; break;
         case 'F': infile = optarg; break;
         case 'r': rfile = optarg; break;
         case 'S': servicesfile = optarg; break;
         case 'D': debugflag++; debug_interval = atoi (optarg);
            break;
         case 'w': ++wflag;
            if ((wfile = optarg) == NULL)
               if (!strcmp (argv[optind], "-")) {
                  wfile = "-";
               } 
            break;
   
         case 'h':
         default:
            usage (program_name);
      }
   }

   if (rfile != NULL) portnum = 0;
   if (portnum) lfd = establish_listen (portnum);
   if (pd = init (device, infile, rfile, argv, optind))
      if (!(callback = lookup_pcap_callback (type = pcap_datalink (pd))))
         aerror ("unknown data link type 0x%x", type);

   argus_loop(pd, callback);
   cleanup ();

   exit (0);
}

struct WriteStruct initWs;
struct WriteStruct *ws;

struct WriteStruct mssBuf;
struct WriteStruct *mss;

#include <fcntl.h>

int outfd = -1;
extern int reporttime;
 
static pcap_t *
init (device, infile, rfile, argv, optind)
char *device, *infile, *rfile, **argv;
int optind;
{
   int size;
   FILE *logfile = NULL;
   pcap_t *pd = NULL;
   char *cmdbuf = NULL, *bufptr;
   char buf[PCAP_ERRBUF_SIZE], buffer[64];
   struct bpf_program bpfcode; 
   struct timeval tvpbuf, *tvp = &tvpbuf;
   struct stat statbuf;

   if (rfile != NULL) {
      setuid(getuid());
      if ((pd = pcap_open_offline(rfile, buf)) == NULL)
         aerror (buf, 0L);
      localnet = 0; netmask = 0;

   } else {
      if (!(device))
         if (!(device = pcap_lookupdev (buf)))
            aerror (buf, 0L);
   
      if (pd = pcap_open_live(device, snaplen, !pflag, 1000, buf)) {
         if ((pcap_lookupnet (device, (u_int *)&localnet, (u_int *)&netmask, buf)) < 0)
            aerror (buf, 0L);
      } else
         aerror (buf, 0L);

      setuid (getuid ());
   }

   ws = &initWs;
   gettimeofday (tvp, 0L);
   bzero ((char *) ws, sizeof (initWs));
   sprintf (buffer, "Argus Version %d.%d\n", VERSION_MAJOR, VERSION_MINOR);

   ws->status = ARGUSCONTROL | INIT;
   if (dflag) ws->status |= DETAIL;
   bcopy ((char *) buffer, (char *) ws->ws_init.initString, strlen(buffer));

   ws->ws_init.now.tv_sec  = tvp->tv_sec;
   ws->ws_init.now.tv_usec = tvp->tv_usec;
   ws->ws_init.startime.tv_sec  = tvp->tv_sec;
   ws->ws_init.startime.tv_usec = tvp->tv_usec;

   ws->ws_init.localnet = localnet;
   ws->ws_init.netmask = netmask;
   ws->ws_init.reportInterval = debug_interval;
   ws->ws_init.dflagInterval = dflag;
   ws->ws_init.interfaceType =  pcap_datalink (pd);
   ws->ws_init.interfaceStatus = interfaceStatus (device);

   mss = &mssBuf;
   bzero ((char *) mss, sizeof (mssBuf));
   mss->status = ARGUSCONTROL | STATUS;
   if (dflag) mss->status |= DETAIL;

   mss->ws_init.now.tv_sec  = tvp->tv_sec;
   mss->ws_init.now.tv_usec = tvp->tv_usec;
   mss->ws_init.startime.tv_sec  = tvp->tv_sec;
   mss->ws_init.startime.tv_usec = tvp->tv_usec;
   mss->ws_stat.reportInterval = debug_interval;
   mss->ws_stat.dflagInterval = dflag;
   mss->ws_stat.interfaceType =  pcap_datalink (pd);
   mss->ws_stat.interfaceStatus = interfaceStatus (device);

   if (wfile && wflag) {
      if (strcmp (wfile, "-")) {
         if ((outfd = open (wfile, O_RDWR | O_APPEND | O_CREAT, 0x1a4)) >= 0) {
            if (fstat (outfd, &statbuf) == 0) {
               if (statbuf.st_size == 0) {
                  wshton (ws);
                  if ((write (outfd, ws, sizeof(*ws))) < 0)
                     perror ("write");
                  wsntoh (ws);
               }
            } else {
               perror ("fstat");
               close (outfd); unlink (wfile);
               outfd = -1;
               return (NULL);
            }
         } else
            perror ("open");
      }
   }

   if (infile)
      cmdbuf = read_infile (infile);
   else
      cmdbuf = copy_argv (&argv[optind]);

   if (servicesfile) read_udp_services (servicesfile);
 
   bzero ((char *) &bpfcode, sizeof (bpfcode));

   if (pcap_compile (pd, &bpfcode, cmdbuf, Oflag, netmask) < 0)
      aerror (pcap_geterr (pd), 0L);

   if (bpflag) {
      bpf_dump (&bpfcode, bpflag);
      exit(0);
   }

   if (pcap_setfilter (pd, &bpfcode) < 0)
      aerror (pcap_geterr(pd), 0L);

   (void) signal (SIGPIPE, SIG_IGN);
   (void) signal (SIGHUP,  (void (*)()) cleanup);
   (void) signal (SIGINT,  (void (*)()) cleanup);
   (void) signal (SIGTERM, (void (*)()) cleanup);
   (void) signal (SIGUSR1, (void (*)()) usr1sig);
   (void) signal (SIGUSR2, (void (*)()) usr2sig);

   FD_ZERO((char *) &readmask);
   FD_ZERO((char *) &writemask);
   FD_ZERO((char *) &exceptmask);

   reporttime = tvp->tv_sec + debug_interval;

   cons_init ();
   return (pd);
}

