
/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

 /*
 * cons.c - supports connection tracking 
 *
 * Used to parse received tcp, udp and icmp packets to 
 * track current connections.
 *
 * written by Carter Bullard
 * Software Engineering Institute
 * Carnegie Mellon Univeristy
 */


#if !defined(HAVE_SOLARIS)
#include <stdlib.h>
#include <unistd.h>
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

#include <compat.h>
#include <pcap.h>

#include <netinet/in.h>
#include <interface.h>
#include <argus.h>
#include <addrtoname.h>
#include <pcap.h>

#include <cons_tcp.h>

void
cons_init ()
{
   cons_socket_init ();
   cons_ether_init ();
   cons_frag_init ();
   cons_ip_init ();
   cons_icmp_init ();
   cons_udp_init ();
   cons_tcp_init ();
}


updatetime (tvp)
struct timeval *tvp;
{
   int retn = 0;
   double timenow;
   extern double update_interval, update_time;

   timenow  = (double) tvp->tv_sec + (double) tvp->tv_usec/1000000.0;

   if (update_time == 0.0)
      update_time = timenow + update_interval;
   else {
      if (timenow >= update_time) {
         retn = 1;
         update_time = timenow + update_interval;
      }
   }

   return (retn);
}
      
void
check_timeouts (queue, tvp, timeout)
struct QUEUE *queue;
struct timeval *tvp;
int timeout;
{
   struct QUEUE_HEADER *ptr, *prv, *last = NULL;
   proc timeoutRoutine = NULL, logRoutine = NULL;

   if (queue->start) {
      if (timeoutRoutine = queue->timerRoutine) {
         ptr = queue->start->prv;
         do {
            if (tvp->tv_sec >= (ptr->last_time.tv_sec + timeout)) {
               prv = ptr->prv;
               timeoutRoutine (ptr, tvp);
               ptr = ((ptr == prv) ? NULL : prv);
            } else
               break;
         } while (ptr);
      }

      if (dflag && (queue != &tcp_timeout_list)) {
         if (logRoutine = queue->logRoutine) {
            if (queue->start) {
               ptr = queue->start;
               do {
                  if (tvp->tv_sec >= (ptr->logtime.tv_sec + dflag))
                     logRoutine (ptr, tvp, DETAIL);
                  ptr = ptr->nxt;
               } while  (ptr != queue->start);
            }
         }
      }
   }
}
