
/*
 * Copyright (c) 1997 Carter Bullard
 * All applicable rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is restricted to personal use only.  Use, sale
 * or retransmission of this software for commercial purposes, 
 * including but not limited to use as a commerical product or
 * in support of a commercial endeavor requires licensing from Carter
 * Bullard.
 *
 * CARTER BULLARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL CARTER BULLARD BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * cons_sockets.c - supports connection tracking 
 *
 * Used to handle remote client sockets.
 *
 * written by Carter Bullard
 * Software Engineering Institute
 * Carnegie Mellon Univeristy
 */

#if !defined(HAVE_SOLARIS)
#include <stdlib.h>
#endif
#include <unistd.h>

#include <string.h>

#include <memory.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/errno.h>
 
extern int sys_nerr;
extern int errno;

#include <compat.h>
#include <pcap.h>
#include <interface.h>

#include <netinet/in.h>
#include <argus.h>

#define STDOUT           1
#define MONITORPORTNUM   561

static void close_socket ();
extern fd_set readmask, writemask, exceptmask;

int clienttags = 0;
static int clientsfd [MAX_LISTEN];
static struct sockaddr *clientsock[MAX_LISTEN];

void wshton ();
void wsntoh ();

void
cons_socket_init ()
{
   int i;
   for (i = 0; i < MAX_LISTEN; i++) {
      clientsfd[i] = -1;
      clientsock[i] = NULL;
   }
}

void
wsntoh (ws)
struct WriteStruct *ws;
{
   arg_uint32 status;

   ws->status = ntohl(ws->status);
   if ((status = ws->status) & ARGUSCONTROL) {
      switch (status & (INIT | STATUS)) {
         case INIT:
            ws->ws_init.now.tv_sec  = ntohl(ws->ws_init.now.tv_sec);
            ws->ws_init.now.tv_usec = ntohl(ws->ws_init.now.tv_usec);
            ws->ws_init.startime.tv_sec  = ntohl(ws->ws_init.startime.tv_sec);
            ws->ws_init.startime.tv_usec = ntohl(ws->ws_init.startime.tv_usec);
            ws->ws_init.localnet = ntohl(ws->ws_init.localnet);
            ws->ws_init.netmask = ntohl(ws->ws_init.netmask);
            break;

         case STATUS:
            ws->ws_stat.startime.tv_sec  = ntohl(ws->ws_stat.startime.tv_sec);
            ws->ws_stat.startime.tv_usec = ntohl(ws->ws_stat.startime.tv_usec);
            ws->ws_stat.now.tv_sec  = ntohl(ws->ws_stat.now.tv_sec);
            ws->ws_stat.now.tv_usec = ntohl(ws->ws_stat.now.tv_usec);
            ws->ws_stat.pktsRcvd = ntohl(ws->ws_stat.pktsRcvd);
            ws->ws_stat.bytesRcvd = ntohl(ws->ws_stat.bytesRcvd);
            ws->ws_stat.pktsDrop = ntohl(ws->ws_stat.pktsDrop);
            ws->ws_stat.actTCPcons = ntohs(ws->ws_stat.actTCPcons);
            ws->ws_stat.cloTCPcons = ntohs(ws->ws_stat.cloTCPcons);
            ws->ws_stat.actUDPcons = ntohs(ws->ws_stat.actUDPcons);
            ws->ws_stat.cloUDPcons = ntohs(ws->ws_stat.cloUDPcons);
            ws->ws_stat.cloIPcons = ntohs(ws->ws_stat.cloIPcons);
            ws->ws_stat.actIPcons = ntohs(ws->ws_stat.actIPcons);
            ws->ws_stat.cloICMPcons = ntohs(ws->ws_stat.cloICMPcons);
            ws->ws_stat.actICMPcons = ntohs(ws->ws_stat.actICMPcons);
            ws->ws_stat.cloFRAGcons = ntohs(ws->ws_stat.cloFRAGcons);
            ws->ws_stat.actFRAGcons = ntohs(ws->ws_stat.actFRAGcons);
            break;
      }
   } else {
      arg_uint32 newvalue;
      arg_uint16 *ptr = (unsigned short *)&newvalue;

      ws->ws_ip.startime.tv_sec  = ntohl(ws->ws_ip.startime.tv_sec);
      ws->ws_ip.startime.tv_usec = ntohl(ws->ws_ip.startime.tv_usec);

      ptr[0] = ntohs(((unsigned short *)&ws->ws_ip.lasttime.tv_sec)[0]);
      ptr[1] = ntohs(((unsigned short *)&ws->ws_ip.lasttime.tv_sec)[1]);
      ws->ws_ip.lasttime.tv_sec = newvalue;

      ws->ws_ip.lasttime.tv_usec = ntohl(ws->ws_ip.lasttime.tv_usec);

      ws->ws_ip.src.s_addr = ntohl(ws->ws_ip.src.s_addr);
      ws->ws_ip.dst.s_addr = ntohl(ws->ws_ip.dst.s_addr);

      ptr[0] = ntohs(((unsigned short *)&ws->ws_ip.port)[0]);
      ptr[1] = ntohs(((unsigned short *)&ws->ws_ip.port)[1]);

      switch (status & (ICMPPROTO | TCPPROTO | UDPPROTO)) {
         case TCPPROTO:
            ws->ws_ip.port = newvalue;
            ws->ws_ip_tcp.src_count = ntohl(ws->ws_ip_tcp.src_count);
            ws->ws_ip_tcp.dst_count = ntohl(ws->ws_ip_tcp.dst_count);
            ws->ws_ip_tcp.src_bytes = ntohl(ws->ws_ip_tcp.src_bytes);
            ws->ws_ip_tcp.dst_bytes = ntohl(ws->ws_ip_tcp.dst_bytes);
            break;

         case ICMPPROTO:
            if (!(status & (CON_ESTABLISHED | TIMED_OUT))) {
               ws->ws_ip_icmp.data = ntohs(ws->ws_ip_icmp.data);
               ws->ws_ip_icmp.srcaddr.s_addr=ntohl(ws->ws_ip_icmp.srcaddr.s_addr);
               ws->ws_ip_icmp.dstaddr.s_addr=ntohl(ws->ws_ip_icmp.dstaddr.s_addr);
               ws->ws_ip_icmp.gwaddr.s_addr =ntohl(ws->ws_ip_icmp.gwaddr.s_addr);
            } else {
               ws->ws_ip_udp.src_count = ntohl(ws->ws_ip_udp.src_count);
               ws->ws_ip_udp.dst_count = ntohl(ws->ws_ip_udp.dst_count);
               ((unsigned short *)&ws->ws_ip_udp.src_bytes)[1] = 
                                        ntohs(((unsigned short *)&ws->ws_ip_udp.src_bytes)[1]);
               ws->ws_ip_udp.dst_bytes = ntohl(ws->ws_ip_udp.dst_bytes);
            }
            break;

         case UDPPROTO:
            ws->ws_ip.port = newvalue;
         default:
            ws->ws_ip_udp.src_count = ntohl(ws->ws_ip_udp.src_count);
            ws->ws_ip_udp.dst_count = ntohl(ws->ws_ip_udp.dst_count);
            ws->ws_ip_udp.src_bytes = ntohl(ws->ws_ip_udp.src_bytes);
            ws->ws_ip_udp.dst_bytes = ntohl(ws->ws_ip_udp.dst_bytes);
            break;
      }
   }
}

void
wshton (ws)
struct WriteStruct *ws;
{
   arg_uint32 status = ws->status;

   ws->status = htonl(ws->status);
   if (status & ARGUSCONTROL) {
      switch (status & (INIT | STATUS)) {
         case INIT:
            ws->ws_init.now.tv_sec  = htonl(ws->ws_init.now.tv_sec);
            ws->ws_init.now.tv_usec = htonl(ws->ws_init.now.tv_usec);
            ws->ws_init.startime.tv_sec  = htonl(ws->ws_init.startime.tv_sec);
            ws->ws_init.startime.tv_usec = htonl(ws->ws_init.startime.tv_usec);
            ws->ws_init.localnet = htonl(ws->ws_init.localnet);
            ws->ws_init.netmask = htonl(ws->ws_init.netmask);
            break;

         case STATUS:
            ws->ws_stat.startime.tv_sec  = htonl(ws->ws_stat.startime.tv_sec);
            ws->ws_stat.startime.tv_usec = htonl(ws->ws_stat.startime.tv_usec);
            ws->ws_stat.now.tv_sec  = htonl(ws->ws_stat.now.tv_sec);
            ws->ws_stat.now.tv_usec = htonl(ws->ws_stat.now.tv_usec);
            ws->ws_stat.pktsRcvd = htonl(ws->ws_stat.pktsRcvd);
            ws->ws_stat.bytesRcvd = htonl(ws->ws_stat.bytesRcvd);
            ws->ws_stat.pktsDrop = htonl(ws->ws_stat.pktsDrop);
            ws->ws_stat.actTCPcons = htons(ws->ws_stat.actTCPcons);
            ws->ws_stat.cloTCPcons = htons(ws->ws_stat.cloTCPcons);
            ws->ws_stat.actUDPcons = htons(ws->ws_stat.actUDPcons);
            ws->ws_stat.cloUDPcons = htons(ws->ws_stat.cloUDPcons);
            ws->ws_stat.cloIPcons = htons(ws->ws_stat.cloIPcons);
            ws->ws_stat.actIPcons = htons(ws->ws_stat.actIPcons);
            ws->ws_stat.cloICMPcons = htons(ws->ws_stat.cloICMPcons);
            ws->ws_stat.actICMPcons = htons(ws->ws_stat.actICMPcons);
            ws->ws_stat.cloFRAGcons = htons(ws->ws_stat.cloFRAGcons);
            ws->ws_stat.actFRAGcons = htons(ws->ws_stat.actFRAGcons);
            break;
      }
   } else {
      arg_uint32 newvalue;
      arg_uint16 *ptr = (arg_uint16 *)&newvalue;

      ws->ws_ip.startime.tv_sec  = htonl(ws->ws_ip.startime.tv_sec);
      ws->ws_ip.startime.tv_usec = htonl(ws->ws_ip.startime.tv_usec);

      ptr[0] = htons(((unsigned short *)&ws->ws_ip.lasttime.tv_sec)[0]);
      ptr[1] = htons(((unsigned short *)&ws->ws_ip.lasttime.tv_sec)[1]);
      ws->ws_ip.lasttime.tv_sec = newvalue;

      ws->ws_ip.lasttime.tv_usec = htonl(ws->ws_ip.lasttime.tv_usec);

      ws->ws_ip.src.s_addr = htonl(ws->ws_ip.src.s_addr);
      ws->ws_ip.dst.s_addr = htonl(ws->ws_ip.dst.s_addr);

      ptr[0] = htons(((arg_uint16 *)&ws->ws_ip.port)[0]);
      ptr[1] = htons(((arg_uint16 *)&ws->ws_ip.port)[1]);
 
      switch (status & (ICMPPROTO | TCPPROTO | UDPPROTO)) {
         case TCPPROTO:
            ws->ws_ip.port = newvalue;
            ws->ws_ip_tcp.src_count = htonl(ws->ws_ip_tcp.src_count);
            ws->ws_ip_tcp.dst_count = htonl(ws->ws_ip_tcp.dst_count);
            ws->ws_ip_tcp.src_bytes = htonl(ws->ws_ip_tcp.src_bytes);
            ws->ws_ip_tcp.dst_bytes = htonl(ws->ws_ip_tcp.dst_bytes);
            break;

         case ICMPPROTO:
            if (!(status & (CON_ESTABLISHED | TIMED_OUT))) {
               ws->ws_ip_icmp.data = htons(ws->ws_ip_icmp.data);
               ws->ws_ip_icmp.srcaddr.s_addr=htonl(ws->ws_ip_icmp.srcaddr.s_addr);
               ws->ws_ip_icmp.dstaddr.s_addr=htonl(ws->ws_ip_icmp.dstaddr.s_addr);
               ws->ws_ip_icmp.gwaddr.s_addr =htonl(ws->ws_ip_icmp.gwaddr.s_addr);
            } else {
               ws->ws_ip_udp.src_count = htonl(ws->ws_ip_udp.src_count);
               ws->ws_ip_udp.dst_count = htonl(ws->ws_ip_udp.dst_count);
               ((unsigned short *)&ws->ws_ip_udp.src_bytes)[1] =
                                        htons(((unsigned short *)&ws->ws_ip_udp.src_bytes)[1]);
               ws->ws_ip_udp.dst_bytes = htonl(ws->ws_ip_udp.dst_bytes);
            }
            break;

         case UDPPROTO:
            ws->ws_ip.port = newvalue;
         default:
            ws->ws_ip_udp.src_count = htonl(ws->ws_ip_udp.src_count);
            ws->ws_ip_udp.dst_count = htonl(ws->ws_ip_udp.dst_count);
            ws->ws_ip_udp.src_bytes = htonl(ws->ws_ip_udp.src_bytes);
            ws->ws_ip_udp.dst_bytes = htonl(ws->ws_ip_udp.dst_bytes);
            break;
      }
   }
}


int firstWrite = 1;

void
writeOutData (output, tvp)
struct WriteStruct *output;
struct argtimeval *tvp;
{
   int i, fd, size;
   struct stat statbuf;
   extern struct WriteStruct *ws;
   extern int outfd;

   wshton (output);
   if (wfile && wflag) {
      if (strcmp (wfile, "-")) {
         if ((outfd != -1) && (stat (wfile, &statbuf) == 0)) {
            if ((write (outfd, output, sizeof (*output))) < 0) {
               perror ("write");
               close (outfd); outfd = -1;
            }
         } else {
            if (outfd != -1) close (outfd);
            if ((outfd = open (wfile, O_RDWR|O_APPEND|O_CREAT, 0x1a4)) >= 0) {
               if (fstat (outfd, &statbuf) == 0) {
                  if (statbuf.st_size == 0) {
                     updateInitWs(ws, tvp);
                     wshton (ws);
                     if ((write (outfd, ws, sizeof(*ws))) < 0)
                        perror ("write");
                     wsntoh (ws);
                  }
               } else {
                  perror ("fstat");
                  close (outfd); unlink (wfile);
                  return;
               }
               if ((write (outfd, output, sizeof (*output))) < 0)
                  perror ("write");
            } else
               perror ("open");
         }

      } else {
         if (firstWrite) {
            updateInitWs(ws, tvp);
            wshton (ws);
            if (!(fwrite (ws, sizeof(*ws), 1, stdout)))
               perror ("write");
            wsntoh (ws);
            firstWrite = 0;
         }
         if (!(fwrite (output, sizeof (struct writeStruct), 1, stdout)))
            perror ("fwrite");
         fflush (stdout);
      }
   }

   if (clienttags)
      for (i = 0; i < MAX_LISTEN; i++)
         if (clientsfd[i] != -1)
            if ((write (clientsfd[i], (char *) output,
                                sizeof(struct writeStruct))) <= 0)
               if ((errno == ENXIO) || (errno == EPIPE))
                  close_socket (i);
}


establish_listen (port)
int port;
{
   int s = -1;
   struct sockaddr_in sin;
   struct servent *sp;

   if (port) {
      sin.sin_port = htons((u_short) port);
      sin.sin_addr.s_addr = INADDR_ANY;

/* added for Solaris 2.4 */
      sin.sin_family = AF_INET;

      if (s = socket (AF_INET, SOCK_STREAM, 0)) {
         if ((fcntl (s, F_SETFL, O_NDELAY)) >= 0) {
            if (!(bind (s, (struct sockaddr *)&sin, sizeof(sin)))) {
               listen (s, MAX_LISTEN);
               FD_SET(s, &readmask);
               FD_SET(s, &writemask);
               FD_SET(s, &exceptmask);
            } else
               perror ("bind");
         }
      } else
         perror ("bind");
   }
   return (s);
}


void
check_client_status (lfd, tvp)
int lfd;
struct argtimeval *tvp;
{
   struct sockaddr from;
   int fd, len = sizeof (from), i;
   char buf [1024];
   extern struct WriteStruct *ws;

   if ((fd = accept (lfd, (struct sockaddr *)&from, &len)) > 0) {
      if (argus_tcp_wrapper (fd, &from) >= 0) {
         updateInitWs(ws, tvp);
         wshton (ws);
         if (write (fd, ws, sizeof(*ws)) <= 0) {
            wsntoh (ws);
            close (fd);
            return;
         } else {
            wsntoh (ws);
            for (i = 0; i < MAX_LISTEN; i++) {
               if (clientsfd[i] == -1) {
                  clientsfd[i] = fd;
                  if (clientsock[i] = (struct sockaddr *) calloc (1, 
                         sizeof (struct sockaddr)))
                     bcopy ((char *)&from, (char *) clientsock[i],
                                           sizeof (struct sockaddr));
                  clienttags |= (1 << i);
                  break;
               }
            }
            if (i == MAX_LISTEN)
               close (fd);
         }

      } else
         close (fd);
   }
}

argus_tcp_wrapper (fd, from)
int fd;
struct sockaddr *from;
{
#if defined(TCPWRAPPER)
 return  tcp_wrapper (fd, from);
#endif
}


static void
close_socket (i)
int i;
{
   close (clientsfd[i]);
   clientsfd[i] = -1;
   free (clientsock[i]);
   clientsock[i] = NULL;
   clienttags &= ~(1 << i);
}


void
close_clients ()
{
   extern int lfd;
   int i;

   for (i = 0; i < MAX_LISTEN; i++)
      if (clientsfd[i] != -1)
         close_socket (i);

   clienttags = 0;
   close (lfd);
}
