
/*  A Bison parser, made from dfilter-grammar.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define yyparse dfilter_parse
#define yylex dfilter_lex
#define yyerror dfilter_error
#define yylval dfilter_lval
#define yychar dfilter_char
#define yydebug dfilter_debug
#define yynerrs dfilter_nerrs
#define	T_FT_UINT8	257
#define	T_FT_UINT16	258
#define	T_FT_UINT24	259
#define	T_FT_UINT32	260
#define	T_FT_INT8	261
#define	T_FT_INT16	262
#define	T_FT_INT24	263
#define	T_FT_INT32	264
#define	T_FT_ETHER	265
#define	T_FT_IPv4	266
#define	T_FT_IPv6	267
#define	T_FT_NONE	268
#define	T_FT_BYTES	269
#define	T_FT_BOOLEAN	270
#define	T_FT_STRING	271
#define	T_FT_IPXNET	272
#define	T_FT_DOUBLE	273
#define	T_VAL_UNQUOTED_STRING	274
#define	T_VAL_QUOTED_STRING	275
#define	T_VAL_BYTE_STRING	276
#define	T_VAL_BYTE_RANGE	277
#define	TOK_AND	278
#define	TOK_OR	279
#define	TOK_NOT	280
#define	TOK_XOR	281
#define	TOK_EQ	282
#define	TOK_NE	283
#define	TOK_GT	284
#define	TOK_GE	285
#define	TOK_LT	286
#define	TOK_LE	287

#line 1 "dfilter-grammar.y"

/* dfilter-grammar.y
 * Parser for display filters
 *
 * $Id: dfilter-grammar.y,v 1.2 2000/12/22 12:05:36 gram Exp $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@zing.org>
 * Copyright 1998 Gerald Combs
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#ifdef NEED_SNPRINTF_H
# ifdef HAVE_STDARG_H
#  include <stdarg.h>
# else
#  include <varargs.h>
# endif
# include "snprintf.h"
#endif

#ifndef __GLIB_H__
#include <glib.h>
#endif

#include <string.h>
#include <errno.h>
#include <math.h>

#ifndef _STDLIB_H
#include <stdlib.h>
#endif

#ifndef __PROTO_H__
#include "proto.h"
#endif

#ifndef __PACKET_H__
#include "packet.h"
#endif

#ifndef __DFILTER_H__
#include "dfilter.h"
#endif

#include "dfilter-int.h"

#ifndef __RESOLV_H__
#include "resolv.h"
#endif

static GNode* dfilter_mknode_join(GNode *n1, enum node_type ntype, int operand, GNode *n2);
static GNode* dfilter_mknode_unary(int operand, GNode *n2);
static GNode* dfilter_mknode_numeric_variable(gint id);
static GNode* dfilter_mknode_numeric_value(guint32 val);
static GNode* dfilter_mknode_floating_variable(gint id);
static GNode* dfilter_mknode_floating_value(double val);
static GNode* dfilter_mknode_ether_value(gchar*);
static GNode* dfilter_mknode_ether_variable(gint id);
static GNode* dfilter_mknode_ipxnet_value(guint32);
static GNode* dfilter_mknode_ipxnet_variable(gint id);
static GNode* dfilter_mknode_ipv4_value(char *host, int nmask_bits);
static GNode* dfilter_mknode_ipv4_variable(gint id);
static GNode* dfilter_mknode_ipv6_value(char *host);
static GNode* dfilter_mknode_ipv6_variable(gint id);
static GNode* dfilter_mknode_existence(gint id);
static GNode* dfilter_mknode_bytes_value(GByteArray *barray);
static GNode* dfilter_mknode_bytes_variable(gint id, gint offset, guint length, gboolean to_the_end);
static GNode* dfilter_mknode_string_value(char *s);
static GNode* dfilter_mknode_string_variable(gint id);

static guint32 string_to_guint32(char *s, gboolean *success);
static double string_to_double(char *s, gboolean *success);
static int ether_str_to_guint8_array(const char *s, guint8 *mac);
static guint dfilter_get_bytes_variable_offset(GNode *gnode);
static guint dfilter_get_bytes_value_length(GNode* gnode);
static void dfilter_set_bytes_variable_length(GNode *gnode, guint length);
static guint dfilter_get_bytes_variable_length(GNode *gnode);
static gint dfilter_get_bytes_variable_field_registered_length(GNode *gnode);
static char* dfilter_get_variable_abbrev(GNode *gnode);
static int check_bytes_variable_sanity(GNode *gnode);

/* This is the dfilter we're currently processing. It's how
 * dfilter_compile communicates with us.
 */
dfilter *global_df = NULL;


#line 116 "dfilter-grammar.y"
typedef union {
	gint		operand;	/* logical, relation, alternation */
	struct {
		gint	id;
		gint	type;		/* using macros defined below, in this yacc grammar */
	} variable;
	GNode*		node;
	gchar*		string;
	struct {
		gint	offset;
		guint	length;
	} byte_range;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		113
#define	YYFLAG		-32768
#define	YYNTBASE	37

#define YYTRANSLATE(x) ((unsigned)(x) <= 287 ? yytranslate[x] : 61)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    34,
    35,     2,     2,     2,     2,     2,    36,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     3,     7,    11,    15,    19,    22,    24,    26,
    29,    33,    37,    41,    45,    49,    53,    57,    61,    65,
    69,    73,    77,    81,    85,    89,    93,    95,    97,    99,
   101,   103,   105,   107,   109,   111,   115,   119,   121,   123,
   125,   127,   129,   131,   133,   135,   137,   139,   141,   143,
   145,   147,   149,   151,   153,   155,   158,   160,   162,   164,
   166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
   186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
   206,   208,   210,   212,   214,   216,   218
};

static const short yyrhs[] = {    38,
     0,     0,    34,    38,    35,     0,    38,    24,    38,     0,
    38,    25,    38,     0,    38,    27,    38,     0,    26,    38,
     0,    39,     0,    56,     0,    38,     1,     0,    48,    58,
    40,     0,    48,    58,    48,     0,    50,    58,    44,     0,
    50,    58,    50,     0,    49,    59,    41,     0,    49,    59,
    49,     0,    51,    59,    43,     0,    51,    59,    51,     0,
    54,    59,    42,     0,    54,    59,    54,     0,    52,    58,
    45,     0,    52,    58,    52,     0,    53,    59,    46,     0,
    53,    59,    53,     0,    55,    60,    47,     0,    55,    60,
    55,     0,    20,     0,    22,     0,    20,     0,    21,     0,
    20,     0,    20,     0,    22,     0,    20,     0,    22,     0,
    20,    36,    20,     0,    22,    36,    20,     0,    20,     0,
    22,     0,    22,     0,    20,     0,     3,     0,     4,     0,
     5,     0,     6,     0,     7,     0,     8,     0,     9,     0,
    10,     0,    11,     0,    19,     0,    18,     0,    12,     0,
    13,     0,    17,     0,    15,    23,     0,    15,     0,    57,
     0,     3,     0,     4,     0,     5,     0,     6,     0,     7,
     0,     8,     0,     9,     0,    10,     0,    19,     0,    11,
     0,    12,     0,    13,     0,    18,     0,    14,     0,    15,
     0,    16,     0,    17,     0,    28,     0,    29,     0,    30,
     0,    31,     0,    32,     0,    33,     0,    28,     0,    29,
     0,    28,     0,    29,     0,    30,     0,    32,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   180,   184,   187,   188,   189,   190,   191,   192,   193,   194,
   197,   201,   206,   210,   215,   219,   224,   228,   233,   237,
   243,   247,   252,   256,   261,   289,   320,   331,   341,   349,
   359,   370,   380,   392,   401,   410,   438,   466,   475,   485,
   495,   523,   524,   525,   526,   527,   528,   529,   530,   533,
   536,   539,   542,   545,   548,   551,   556,   563,   579,   580,
   581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
   591,   592,   593,   594,   595,   598,   599,   600,   601,   602,
   603,   606,   607,   610,   611,   612,   613
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","T_FT_UINT8",
"T_FT_UINT16","T_FT_UINT24","T_FT_UINT32","T_FT_INT8","T_FT_INT16","T_FT_INT24",
"T_FT_INT32","T_FT_ETHER","T_FT_IPv4","T_FT_IPv6","T_FT_NONE","T_FT_BYTES","T_FT_BOOLEAN",
"T_FT_STRING","T_FT_IPXNET","T_FT_DOUBLE","T_VAL_UNQUOTED_STRING","T_VAL_QUOTED_STRING",
"T_VAL_BYTE_STRING","T_VAL_BYTE_RANGE","TOK_AND","TOK_OR","TOK_NOT","TOK_XOR",
"TOK_EQ","TOK_NE","TOK_GT","TOK_GE","TOK_LT","TOK_LE","'('","')'","'/'","statement",
"expression","relation","numeric_value","ether_value","string_value","ipxnet_value",
"floating_value","ipv4_value","ipv6_value","bytes_value","numeric_variable",
"ether_variable","floating_variable","ipxnet_variable","ipv4_variable","ipv6_variable",
"string_variable","bytes_variable","variable_name","any_variable_type","numeric_relation",
"equality_relation","bytes_relation", NULL
};
#endif

static const short yyr1[] = {     0,
    37,    37,    38,    38,    38,    38,    38,    38,    38,    38,
    39,    39,    39,    39,    39,    39,    39,    39,    39,    39,
    39,    39,    39,    39,    39,    39,    40,    41,    42,    42,
    43,    44,    44,    45,    45,    45,    45,    46,    46,    47,
    47,    48,    48,    48,    48,    48,    48,    48,    48,    49,
    50,    51,    52,    53,    54,    55,    55,    56,    57,    57,
    57,    57,    57,    57,    57,    57,    57,    57,    57,    57,
    57,    57,    57,    57,    57,    58,    58,    58,    58,    58,
    58,    59,    59,    60,    60,    60,    60
};

static const short yyr2[] = {     0,
     1,     0,     3,     3,     3,     3,     2,     1,     1,     2,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     3,     3,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1
};

static const short yydefact[] = {     2,
    42,    43,    44,    45,    46,    47,    48,    49,    68,    53,
    70,    72,    73,    74,    75,    71,    51,     0,     0,     0,
     8,     0,     0,     0,     0,     0,     0,     0,     0,     9,
    58,    56,     0,     0,    10,     0,     0,     0,    76,    77,
    78,    79,    80,    81,     0,    82,    83,     0,     0,     0,
     0,     0,     0,    84,    85,    86,    87,     0,     3,     0,
     0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
    27,    11,    12,    50,    28,    15,    16,    51,    32,    33,
    13,    14,    52,    31,    17,    18,    53,    34,    35,    21,
    22,    54,    38,    39,    23,    24,    55,    29,    30,    19,
    20,    57,    41,    40,    25,    26,     0,     0,    36,    37,
     0,     0,     0
};

static const short yydefgoto[] = {   111,
    20,    21,    72,    76,   100,    85,    81,    90,    95,   105,
    22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
    45,    48,    58
};

static const short yypact[] = {   142,
     0,     4,     9,    13,    18,    22,    50,    54,   -26,    59,
   -13,-32768,   155,-32768,    -8,    33,    63,   142,   142,   113,
-32768,   160,    42,   160,    42,   160,    42,    42,   166,-32768,
-32768,-32768,    68,   109,-32768,   142,   142,   142,-32768,-32768,
-32768,-32768,-32768,-32768,   112,-32768,-32768,    -5,    89,    12,
   152,    45,    -9,-32768,-32768,-32768,-32768,   151,-32768,    72,
   100,   104,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   -29,   -10,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,    29,-32768,-32768,-32768,-32768,    21,    36,-32768,-32768,
    66,    76,-32768
};

static const short yypgoto[] = {-32768,
   144,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    46,    58,    53,    62,    75,    71,    77,    83,-32768,-32768,
    56,   172,-32768
};


#define	YYLAST		200


static const short yytable[] = {   -59,
   -59,   -50,   -50,   -60,   -60,    74,   107,    97,   -61,   -61,
    98,    99,   -62,   -62,   -54,   -54,    75,   -63,   -63,   -55,
   -55,   -64,   -64,   -59,   -59,   108,   -59,   -60,   -60,    83,
   -60,    84,   -61,   -61,   -59,   -61,   -62,   -62,   -60,   -62,
   109,   -63,   -63,   -61,   -63,   -64,   -64,   -62,   -64,   -65,
   -65,    32,   -63,   -66,   -66,   110,   -64,    92,   -69,   -69,
   -52,   -52,   -67,   -67,    93,   112,    94,    -7,    35,    46,
    47,    -4,    35,   -65,   -65,   113,   -65,   -66,   -66,    49,
   -66,    51,   -69,   -69,   -65,   -69,   -67,   -67,   -66,   -67,
    73,    -7,    -7,   -69,    -7,    -4,    37,   -67,    38,    -5,
    35,    82,    -7,    -6,    35,    77,    -4,    78,    79,    35,
    80,    86,    -1,    35,    63,    64,    65,    66,    67,    68,
    69,    70,    96,    -5,    -5,    91,    -5,    -6,    -6,   101,
    -6,    71,    36,    37,    -5,    38,    36,    37,    -6,    38,
   106,     0,     0,    59,     1,     2,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    33,    34,    87,     0,   102,     0,    18,     0,     0,
   103,    88,   104,    89,     0,    19,     0,    32,     0,    60,
    61,    62,   -57,   -57,   -57,     0,   -57,    39,    40,    41,
    42,    43,    44,    54,    55,    56,    50,    57,    52,    53
};

static const short yycheck[] = {     0,
     1,    28,    29,     0,     1,    11,    36,    17,     0,     1,
    20,    21,     0,     1,    28,    29,    22,     0,     1,    28,
    29,     0,     1,    24,    25,    36,    27,    24,    25,    18,
    27,    20,    24,    25,    35,    27,    24,    25,    35,    27,
    20,    24,    25,    35,    27,    24,    25,    35,    27,     0,
     1,    23,    35,     0,     1,    20,    35,    13,     0,     1,
    28,    29,     0,     1,    20,     0,    22,     0,     1,    28,
    29,     0,     1,    24,    25,     0,    27,    24,    25,    24,
    27,    26,    24,    25,    35,    27,    24,    25,    35,    27,
    45,    24,    25,    35,    27,    24,    25,    35,    27,     0,
     1,    49,    35,     0,     1,    48,    35,    19,    20,     1,
    22,    50,     0,     1,     3,     4,     5,     6,     7,     8,
     9,    10,    52,    24,    25,    51,    27,    24,    25,    53,
    27,    20,    24,    25,    35,    27,    24,    25,    35,    27,
    58,    -1,    -1,    35,     3,     4,     5,     6,     7,     8,
     9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
    19,    18,    19,    12,    -1,    15,    -1,    26,    -1,    -1,
    20,    20,    22,    22,    -1,    34,    -1,    23,    -1,    36,
    37,    38,    28,    29,    30,    -1,    32,    28,    29,    30,
    31,    32,    33,    28,    29,    30,    25,    32,    27,    28
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 181 "dfilter-grammar.y"
{
			global_df->dftree = yyvsp[0].node;
		;
    break;}
case 2:
#line 184 "dfilter-grammar.y"
{ if (global_df != NULL) global_df->dftree = NULL; ;
    break;}
case 3:
#line 187 "dfilter-grammar.y"
{ yyval.node = yyvsp[-1].node; ;
    break;}
case 4:
#line 188 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 5:
#line 189 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 6:
#line 190 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 7:
#line 191 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_unary(TOK_NOT, yyvsp[0].node); ;
    break;}
case 8:
#line 192 "dfilter-grammar.y"
{ yyval.node = yyvsp[0].node; ;
    break;}
case 9:
#line 193 "dfilter-grammar.y"
{ yyval.node = yyvsp[0].node; ;
    break;}
case 10:
#line 194 "dfilter-grammar.y"
{ YYABORT; ;
    break;}
case 11:
#line 198 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 12:
#line 202 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 13:
#line 207 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 14:
#line 211 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 15:
#line 216 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 16:
#line 220 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 17:
#line 225 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 18:
#line 229 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 19:
#line 234 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 20:
#line 238 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 21:
#line 244 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 22:
#line 248 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 23:
#line 253 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 24:
#line 257 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 25:
#line 262 "dfilter-grammar.y"
{
			int a_len, b_len;

			a_len = dfilter_get_bytes_variable_length(yyvsp[-2].node);
			b_len = dfilter_get_bytes_value_length(yyvsp[0].node);

			if (a_len == 0) {
				dfilter_set_bytes_variable_length(yyvsp[-2].node, b_len);
				a_len = b_len;
			}

			if (!check_bytes_variable_sanity(yyvsp[-2].node)) {
				YYERROR;
			}

			if (a_len != b_len) {
				dfilter_fail("Field \"%s\" has %u byte%s being compared, but %u byte%s "
					"%s supplied.",
					dfilter_get_variable_abbrev(yyvsp[-2].node),
					a_len, plurality(a_len, "", "s"),
					b_len, plurality(b_len, "", "s"),
					       plurality(b_len, "was", "were"));
				YYERROR;
			}

			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 26:
#line 290 "dfilter-grammar.y"
{
			int a_len, b_len;

			a_len = dfilter_get_bytes_variable_length(yyvsp[-2].node);
			b_len = dfilter_get_bytes_variable_length(yyvsp[0].node);

			if (!check_bytes_variable_sanity(yyvsp[-2].node)) {
				YYERROR;
			}

			if (!check_bytes_variable_sanity(yyvsp[0].node)) {
				YYERROR;
			}

			if (a_len != b_len) {
				dfilter_fail("Fields \"%s\" and \"%s\" are being compared with "
					"disparate lengths of %u byte%s and %u byte%s.",
					dfilter_get_variable_abbrev(yyvsp[-2].node),
					dfilter_get_variable_abbrev(yyvsp[0].node),
					a_len, plurality(a_len, "", "s"),
					b_len, plurality(b_len, "", "s"));
				YYERROR;
			}

			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 27:
#line 321 "dfilter-grammar.y"
{
		gboolean success;
		yyval.node = dfilter_mknode_numeric_value(string_to_guint32(yyvsp[0].string, &success));
		g_free(yyvsp[0].string);
		if (!success) {
			YYERROR;
		}
	 ;
    break;}
case 28:
#line 332 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_ether_value(yyvsp[0].string);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 29:
#line 342 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_string_value(yyvsp[0].string);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 30:
#line 350 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_string_value(yyvsp[0].string);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 31:
#line 360 "dfilter-grammar.y"
{
		gboolean success;
		yyval.node = dfilter_mknode_ipxnet_value(string_to_guint32(yyvsp[0].string, &success));
		g_free(yyvsp[0].string);
		if (!success) {
			YYERROR;
		}
	;
    break;}
case 32:
#line 371 "dfilter-grammar.y"
{
		gboolean success;
		yyval.node = dfilter_mknode_floating_value(string_to_double(yyvsp[0].string, &success));
		g_free(yyvsp[0].string);
		if (!success) {
			YYERROR;
		}
	;
    break;}
case 33:
#line 381 "dfilter-grammar.y"
{
		/* e.g., 0.0, 0.1, 0.01 ... */
		gboolean success;
		yyval.node = dfilter_mknode_floating_value(string_to_double(yyvsp[0].string, &success));
		g_free(yyvsp[0].string);
		if (!success) {
			YYERROR;
		}
	;
    break;}
case 34:
#line 393 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_ipv4_value(yyvsp[0].string, 32);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 35:
#line 402 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_ipv4_value(yyvsp[0].string, 32);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 36:
#line 411 "dfilter-grammar.y"
{
		gboolean	success;
		guint32		nmask_bits;

		nmask_bits = string_to_guint32(yyvsp[0].string, &success);
		if (!success) {
			g_free(yyvsp[-2].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}

		if (nmask_bits > 32) {
			dfilter_fail("The number of netmask bits in \"%s/%s\" should "
				"be between 0 and 32.", yyvsp[-2].string, yyvsp[0].string);
			g_free(yyvsp[-2].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}

		yyval.node = dfilter_mknode_ipv4_value(yyvsp[-2].string, nmask_bits);
		g_free(yyvsp[-2].string);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 37:
#line 439 "dfilter-grammar.y"
{
		gboolean	success;
		guint32		nmask_bits;

		nmask_bits = string_to_guint32(yyvsp[0].string, &success);
		if (!success) {
			g_free(yyvsp[-2].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}

		if (nmask_bits > 32) {
			dfilter_fail("The number of netmask bits in \"%s/%s\" should "
				"be between 0 and 32.", yyvsp[-2].string, yyvsp[0].string);
			g_free(yyvsp[-2].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}
		yyval.node = dfilter_mknode_ipv4_value(yyvsp[-2].string, nmask_bits);
		g_free(yyvsp[-2].string);
		g_free(yyvsp[0].string);
		if (yyval.node == NULL) {
			YYERROR;
		}
	;
    break;}
case 38:
#line 467 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_ipv6_value(yyvsp[0].string);
			g_free(yyvsp[0].string);
			if (yyval.node == NULL) {
				YYERROR;
			}
		;
    break;}
case 39:
#line 476 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_ipv6_value(yyvsp[0].string);
			g_free(yyvsp[0].string);
			if (yyval.node == NULL) {
				YYERROR;
			}
		;
    break;}
case 40:
#line 486 "dfilter-grammar.y"
{
		GByteArray	*barray;

		/* the next function appends to list_of_byte_arrays for me */
		barray = byte_str_to_guint8_array(yyvsp[0].string);
		yyval.node = dfilter_mknode_bytes_value(barray);
		g_free(yyvsp[0].string);
	;
    break;}
case 41:
#line 496 "dfilter-grammar.y"
{
		gboolean	success;
		guint32		val32;
		guint8		val8;
		GByteArray	*barray;

		val32 = string_to_guint32(yyvsp[0].string, &success);
		if (!success) {
			g_free(yyvsp[0].string);
			YYERROR;
		}
		if (val32 > 0xff) {
			dfilter_fail("The value \"%s\" cannot be stored in a single-byte byte-string. "
				"Use the multi-byte \"xx:yy\" representation.", yyvsp[0].string);
			g_free(yyvsp[0].string);
			YYERROR;
		}
		val8 = (guint8) val32;
		barray = g_byte_array_new();
		global_df->list_of_byte_arrays = g_slist_append(global_df->list_of_byte_arrays, barray);
		g_byte_array_append(barray, &val8, 1);

		yyval.node = dfilter_mknode_bytes_value(barray);
		g_free(yyvsp[0].string);
	;
    break;}
case 42:
#line 523 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 43:
#line 524 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 44:
#line 525 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 45:
#line 526 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 46:
#line 527 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 47:
#line 528 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 48:
#line 529 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 49:
#line 530 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable.id); ;
    break;}
case 50:
#line 533 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ether_variable(yyvsp[0].variable.id); ;
    break;}
case 51:
#line 536 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_floating_variable(yyvsp[0].variable.id); ;
    break;}
case 52:
#line 539 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ipxnet_variable(yyvsp[0].variable.id); ;
    break;}
case 53:
#line 542 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ipv4_variable(yyvsp[0].variable.id); ;
    break;}
case 54:
#line 545 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ipv6_variable(yyvsp[0].variable.id); ;
    break;}
case 55:
#line 548 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_string_variable(yyvsp[0].variable.id); ;
    break;}
case 56:
#line 552 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_bytes_variable(yyvsp[-1].variable.id, yyvsp[0].byte_range.offset, yyvsp[0].byte_range.length, FALSE);
		;
    break;}
case 57:
#line 557 "dfilter-grammar.y"
{
		        yyval.node = dfilter_mknode_bytes_variable(yyvsp[0].variable.id, 0, 0, TRUE);
		;
    break;}
case 58:
#line 564 "dfilter-grammar.y"
{
		GNode	*variable;
		GNode	*value;
		if (yyvsp[0].variable.type == T_FT_BOOLEAN) {
			/* Make "variable == TRUE" for BOOLEAN variable */
			variable = dfilter_mknode_numeric_variable(yyvsp[0].variable.id);
			value = dfilter_mknode_numeric_value(TRUE);
			yyval.node = dfilter_mknode_join(variable, relation, TOK_EQ, value);
		}
		else {
			yyval.node = dfilter_mknode_existence(yyvsp[0].variable.id);
		}
	;
    break;}
case 59:
#line 579 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 60:
#line 580 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 61:
#line 581 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 62:
#line 582 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 63:
#line 583 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 64:
#line 584 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 65:
#line 585 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 66:
#line 586 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 67:
#line 587 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 68:
#line 588 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 69:
#line 589 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 70:
#line 590 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 71:
#line 591 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 72:
#line 592 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 73:
#line 593 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 74:
#line 594 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 75:
#line 595 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 76:
#line 598 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 77:
#line 599 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 78:
#line 600 "dfilter-grammar.y"
{ yyval.operand = TOK_GT; ;
    break;}
case 79:
#line 601 "dfilter-grammar.y"
{ yyval.operand = TOK_GE; ;
    break;}
case 80:
#line 602 "dfilter-grammar.y"
{ yyval.operand = TOK_LT; ;
    break;}
case 81:
#line 603 "dfilter-grammar.y"
{ yyval.operand = TOK_LE; ;
    break;}
case 82:
#line 606 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 83:
#line 607 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 84:
#line 610 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 85:
#line 611 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 86:
#line 612 "dfilter-grammar.y"
{ yyval.operand = TOK_GT; ;
    break;}
case 87:
#line 613 "dfilter-grammar.y"
{ yyval.operand = TOK_LT; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 616 "dfilter-grammar.y"


static GNode*
dfilter_mknode_join(GNode *n1, enum node_type ntype, int operand, GNode *n2)
{
	dfilter_node	*node_root;
	GNode		*gnode_root;

	node_root = g_mem_chunk_alloc(global_df->node_memchunk);
	node_root->ntype = ntype;
	node_root->elem_size = 0;
	node_root->fill_array_variable_func = NULL;
	node_root->fill_array_value_func = NULL;
	node_root->check_relation_func = NULL;
	if (ntype == relation) {
		node_root->value.relation = operand;
	}
	else if (ntype == logical) {
		node_root->value.logical = operand;
	}
	else {
		g_assert_not_reached();
	}

	gnode_root = g_node_new(node_root);
	g_node_append(gnode_root, n1);
	g_node_append(gnode_root, n2);

	return gnode_root;
}

static GNode*
dfilter_mknode_unary(int operand, GNode *n2)
{
	dfilter_node	*node_root;
	GNode		*gnode_root;

	node_root = g_mem_chunk_alloc(global_df->node_memchunk);
	node_root->ntype = logical;
	node_root->value.logical = operand;
	node_root->elem_size = 0;
	node_root->fill_array_variable_func = NULL;
	node_root->fill_array_value_func = NULL;
	node_root->check_relation_func = NULL;

	gnode_root = g_node_new(node_root);
	g_node_append(gnode_root, n2);

	return gnode_root;
}


static GNode*
dfilter_mknode_numeric_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(guint32);
	node->fill_array_variable_func = fill_array_numeric_variable;
	node->fill_array_value_func = NULL;
	node->check_relation_func = check_relation_numeric;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ether_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(guint8) * 6;
	node->fill_array_variable_func = fill_array_ether_variable;
	node->fill_array_value_func = NULL;
	node->check_relation_func = check_relation_ether;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_floating_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(double);
	node->fill_array_variable_func = fill_array_floating_variable;
	node->fill_array_value_func = NULL;
	node->check_relation_func = check_relation_floating;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipxnet_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(guint8) * 4;
	node->fill_array_variable_func = fill_array_numeric_variable; /* cheating ! */
	node->fill_array_value_func = NULL;
	node->check_relation_func = check_relation_numeric; /* cheating ! */
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipv4_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(ipv4_addr);
	node->fill_array_variable_func = fill_array_ipv4_variable;
	node->fill_array_value_func = NULL;
	node->check_relation_func = check_relation_ipv4;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipv6_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = 16;
	node->fill_array_variable_func = fill_array_ipv6_variable;
	node->fill_array_value_func = NULL;
	node->check_relation_func = check_relation_ipv6; 
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_string_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(char*);
	node->fill_array_variable_func = fill_array_string_variable;
	node->fill_array_value_func = NULL;
	node->check_relation_func = check_relation_string; 
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_bytes_variable(gint id, gint offset, guint length, gboolean to_the_end)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = variable;
	node->elem_size = sizeof(GByteArray*);
	node->fill_array_variable_func = fill_array_bytes_variable;
	node->fill_array_value_func = NULL;
	node->check_relation_func = check_relation_bytes;
	node->value.variable = id;
	node->offset = offset;
	node->length = length;
	node->to_the_end = to_the_end;
	gnode = g_node_new(node);

	return gnode;
}

/* Gets length of variable represented by node from proto_register */
static gint
dfilter_get_bytes_variable_field_registered_length(GNode *gnode)
{
	dfilter_node	*node = gnode->data;

	/* Is this really a bytes_variable? */
	g_assert(node->fill_array_variable_func == fill_array_bytes_variable);

	return proto_registrar_get_length(node->value.variable);
}

/* Sets the length of a bytes_variable node */
static void
dfilter_set_bytes_variable_length(GNode *gnode, guint length)
{
	dfilter_node	*node = gnode->data;

	/* Is this really a bytes_variable? */
	g_assert(node->fill_array_variable_func == fill_array_bytes_variable);

	node->length = length;
}

/* Gets the length of a bytes_variable node */
static guint
dfilter_get_bytes_variable_length(GNode *gnode)
{
	dfilter_node	*node = gnode->data;

	/* Is this really a bytes_variable? */
	g_assert(node->fill_array_variable_func == fill_array_bytes_variable);

	return node->length;
}

/* Gets the offset of a bytes_variable node */
static guint
dfilter_get_bytes_variable_offset(GNode *gnode)
{
	dfilter_node	*node = gnode->data;

	/* Is this really a bytes_variable? */
	g_assert(node->fill_array_variable_func == fill_array_bytes_variable);

	return node->offset;
}

static char*
dfilter_get_variable_abbrev(GNode *gnode)
{
	dfilter_node	*node = gnode->data;

	return proto_registrar_get_abbrev(node->value.variable);
}

static GNode*
dfilter_mknode_numeric_value(guint32 val)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = numeric;
	node->elem_size = sizeof(guint32);
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = fill_array_numeric_value;
	node->check_relation_func = check_relation_numeric;
	node->value.numeric = val;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_floating_value(double val)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = floating;
	node->elem_size = sizeof(double);
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = fill_array_floating_value;
	node->check_relation_func = check_relation_floating;
	node->value.floating = val;
	gnode = g_node_new(node);

	return gnode;
}

/* Returns NULL on bad parse of ETHER value */
static GNode*
dfilter_mknode_ether_value(gchar *byte_string)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = ether;
	node->elem_size = sizeof(guint8) * 6;
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = fill_array_ether_value;
	node->check_relation_func = check_relation_ether;

	if (!ether_str_to_guint8_array(byte_string, &node->value.ether[0])) {
		/* Rather than free the mem_chunk allocation, let it
		 * stay. It will be cleaned up when "dfilter_compile()"
		 * calls "dfilter_destroy()". */
		dfilter_fail("\"%s\" is not a valid hardware address.",
		    byte_string);
		return NULL;
	}

	gnode = g_node_new(node);
	return gnode;
}

static GNode*
dfilter_mknode_ipxnet_value(guint32 ipx_net_val)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = ipxnet;
	node->elem_size = sizeof(guint8) * 4;
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = fill_array_numeric_value; /* cheating ! */
	node->check_relation_func = check_relation_numeric; /* cheating ! */
	node->value.numeric = ipx_net_val;
	gnode = g_node_new(node);

	return gnode;
}

/* Returns NULL on bad parse of IP value */
static GNode*
dfilter_mknode_ipv4_value(char *host, int nmask_bits)
{
	dfilter_node	*node;
	GNode		*gnode;
	guint32		addr;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = numeric;
	node->elem_size = sizeof(ipv4_addr);
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = fill_array_ipv4_value;
	node->check_relation_func = check_relation_ipv4;
	if (!get_host_ipaddr(host, &addr)) {
		/* Rather than free the mem_chunk allocation, let it
		 * stay. It will be cleaned up when "dfilter_compile()"
		 * calls "dfilter_destroy()". */
		dfilter_fail("\"%s\" isn't a valid host name or IP address.",
		    host);
		return NULL;
	}
	ipv4_addr_set_host_order_addr(&node->value.ipv4, addr);
	ipv4_addr_set_netmask_bits(&node->value.ipv4, nmask_bits);

	gnode = g_node_new(node);
	return gnode;
}

/* Returns NULL on bad parse of IPv6 value */
static GNode*
dfilter_mknode_ipv6_value(char *host)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = ipv6;
	node->elem_size = 16;
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = fill_array_ipv6_value;
	node->check_relation_func = check_relation_ipv6;

	if (!get_host_ipaddr6(host, (struct e_in6_addr*)&node->value.ipv6[0])) {
		/* Rather than free the mem_chunk allocation, let it
		 * stay. It will be cleaned up when "dfilter_compile()"
		 * calls "dfilter_destroy()". */
		dfilter_fail("\"%s\" isn't a valid IPv6 address.",
		    host);
		return NULL;
	}

	gnode = g_node_new(node);
	return gnode;
}


static GNode*
dfilter_mknode_string_value(char *s)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = string;
	node->elem_size = sizeof(char*);
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = fill_array_string_value;
	node->check_relation_func = check_relation_string;
	node->value.string = g_strdup(s);
	global_df->list_of_strings = g_slist_append(global_df->list_of_strings, 
		node->value.string);
	gnode = g_node_new(node);

	return gnode;
}


static GNode*
dfilter_mknode_bytes_value(GByteArray *barray)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = bytes;
	node->elem_size = sizeof(GByteArray*);
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = fill_array_bytes_value;
	node->check_relation_func = check_relation_bytes;
	node->value.bytes = barray;
	node->offset = G_MAXINT;
	node->length = barray->len;
	gnode = g_node_new(node);

	return gnode;
}

/* Given a node representing a bytes_value, returns
 * the length of the byte array */
static guint
dfilter_get_bytes_value_length(GNode* gnode)
{
	dfilter_node	*node = gnode->data;

	g_assert(node->ntype == bytes);
	return node->length;
}

static guint32
string_to_guint32(char *s, gboolean *success)
{
	char	*endptr;
	guint32	val;

	val = strtoul(s, &endptr, 0);
	*success = TRUE;
	if (endptr == s || *endptr != '\0') {
		/* This isn't a valid number. */
		dfilter_fail("\"%s\" is not a valid number.", s);
		*success = FALSE;
	}
	if (errno == ERANGE) {
		*success = FALSE;
		if (val == ULONG_MAX) {
			dfilter_fail("\"%s\" causes an integer overflow.", s);
		}
		else {
			dfilter_fail("\"%s\" is not an integer.", s);
		}
	}

	return (guint32)val;
}

static double
string_to_double(char *s, gboolean *success)
{
	char	*endptr = NULL;
	double	retval;

	retval = strtod(s, &endptr);
	*success = TRUE;

	if (endptr == s) {
		dfilter_fail("\"%s\" is not a valid floating-point number.", s);
		*success = FALSE;
	}

	if (errno == ERANGE) {
		*success = FALSE;
		if (retval == 0) {
			dfilter_fail("\"%s\" causes a floating-point underflow.", s);
		}
		else if (retval == HUGE_VAL) {
			dfilter_fail("\"%s\" causes a floating-point overflow.", s);
		}
		else {
			dfilter_fail("\"%s\" is not a valid floating-point.", s);
		}
	}
	return retval;
}
	
static GNode*
dfilter_mknode_existence(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(global_df->node_memchunk);
	node->ntype = existence;
	node->elem_size = sizeof(guint32);
	node->fill_array_variable_func = NULL;
	node->fill_array_value_func = NULL;
	node->check_relation_func = NULL;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}


/* converts a string representing an ether HW address
 * to a guint8 array.
 *
 * Returns 0 on failure, 1 on success.
 */
static int
ether_str_to_guint8_array(const char *s, guint8 *mac)
{
	char	ether_str[18]; /* 2+1+2+1+2+1+2+1+2+1+2 + 1 */
	char	*p, *str;
	int	i = 0;

	if (strlen(s) > 17) {
		return 0;
	}
	strcpy(ether_str, s); /* local copy of string */
	str = ether_str;
	while ((p = strtok(str, "-:."))) {
		/* catch short strings with too many hex bytes: 0.0.0.0.0.0.0 */
		if (i > 5) {
			return 0;
		}
		mac[i] = (guint8) strtoul(p, NULL, 16);
		i++;
		/* subsequent calls to strtok() require NULL as arg 1 */
		str = NULL;
	}
	if (i != 6)
		return 0;	/* failed to read 6 hex pairs */
	else
		return 1;	/* read exactly 6 hex pairs */
}


static int
check_bytes_variable_sanity(GNode *gnode)
{
	int a_off, a_len, reg_len, t_off;

	a_off = dfilter_get_bytes_variable_offset(gnode);
	a_len = dfilter_get_bytes_variable_length(gnode);
	reg_len = dfilter_get_bytes_variable_field_registered_length(gnode);

	if (reg_len > 0) {
		t_off = a_off >= 0 ? a_off : reg_len + a_off;
		if (t_off + a_len > reg_len) {
			dfilter_fail("The \"%s\" field is only %u byte%s wide, but "
				"%u byte%s %s supplied.",
				dfilter_get_variable_abbrev(gnode),
				reg_len, plurality(reg_len, "", "s"),
				a_len, plurality(a_len, "", "s"),
				       plurality(a_len, "was", "were"));
			return 0;
		}
	}
	return 1;
}
