/* crlcache.h - LDAP access
 *      Copyright (C) 2002 Klarlvdalens Datakonsult AB
 *
 * This file is part of DirMngr.
 *
 * DirMngr is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DirMngr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef CRLCACHE_H
#define CRLCACHE_H

#include <config.h>
#include "../jnlib/types.h"
#include <time.h>
#include <ksba.h>

#include <assuan.h>
#include "dirmngr.h"

typedef enum 
  {
    CRL_CACHE_VALID = 0, 
    CRL_CACHE_INVALID,
    CRL_CACHE_DONTKNOW
  }
crl_cache_result_t;

typedef enum foo
  { 
    CRL_SIG_OK = 0,
    CRL_SIG_NOT_OK,
    CRL_TOO_OLD,
    CRL_SIG_ERROR, 
    CRL_GENERAL_ERROR
  }
crl_sig_result_t;

struct crl_cache_entry_s;
typedef struct crl_cache_entry_s *crl_cache_entry_t;

struct crl_cache_s;
typedef struct crl_cache_s *crl_cache_t;


crl_cache_t crl_cache_init (void);
void crl_cache_deinit (crl_cache_t c);
int crl_cache_flush(void);

crl_cache_result_t crl_cache_isvalid (crl_cache_t cache,
                                      const char *issuer_hash,
                                      const char *cert_id);

gpg_error_t crl_cache_insert (ctrl_t ctrl, crl_cache_t cache,
                              const char *url, FILE *fp);

gpg_error_t crl_cache_list (crl_cache_t cache, FILE* fp);

gpg_error_t crl_cache_load (ctrl_t ctrl, crl_cache_t cache,
                            const char *filename);


#endif /* CRLCACHE_H */
