/* http.h  -  HTTP protocol handler
 *	Copyright (C) 1999, 2000, 2001, 2003 Free Software Foundation, Inc.
 *     
 * This file is part of GnuPG.
 *
 * GnuPG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GnuPG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#ifndef HTTP_H
#define HTTP_H 

struct uri_tuple_s {
  struct uri_tuple_s *next;
  const char *name;	/* A pointer into name. */
  char  *value;         /* A pointer to value (a Nul is always appended). */
  size_t valuelen;	/* The real length of the value; we need it
			   because the value may contain embedded Nuls */
};
typedef struct uri_tuple_s *uri_tuple_t;

struct parsed_uri_s {
    /* All these pointers point into buffer; most stuff is not escaped. */
    char *scheme;	/* Pointer to the scheme string (lowercase). */
    char *host; 	/* Host (converted to lowercase). */
    ushort port;	/* Port (always set if the host is set). */
    char *path; 	/* Path. */
    uri_tuple_t params;	/* ";xxxxx" */
    uri_tuple_t query;	/* "?xxx=yyy" */
    char buffer[1];	/* Buffer which holds a (modified) copy of the URI. */
};
typedef struct parsed_uri_s *parsed_uri_t;

typedef enum 
  {
    HTTP_REQ_GET  = 1,
    HTTP_REQ_HEAD = 2,
    HTTP_REQ_POST = 3
  } 
http_req_t;

enum
  { /* Put flag values into an enum, so that gdb can display them */
    HTTP_FLAG_TRY_PROXY = 1,
    HTTP_FLAG_NO_SHUTDOWN = 2,
  };

struct http_context_s {
  int initialized;
  unsigned int status_code;
  int sock;
  int in_data;
  FILE *fp_read;
  FILE *fp_write;
  int is_http_0_9;
  parsed_uri_t uri;
  http_req_t req_type;
  unsigned char *buffer;     /* Line buffer. */
  unsigned buffer_size;
  unsigned int flags;
};
typedef struct http_context_s *http_t;


gpg_error_t http_parse_uri (parsed_uri_t *ret_uri, const char *uri);
void http_release_parsed_uri (parsed_uri_t uri);

gpg_error_t http_open (http_t hd, http_req_t reqtype,
                       const char *url, unsigned int flags );
void http_start_data (http_t hd);
gpg_error_t http_wait_response (http_t hd, unsigned int *ret_status);
void http_close (http_t hd, int keep_read_stream);

gpg_error_t http_open_document (http_t hd,
                                const char *document, unsigned int flags);

#endif /*HTTP_H*/
