/* dlfcn.h - W32 functions for run-time dynamic loading
 *      Copyright (C) 2003 Free Software Foundation, Inc.
 *
 * This file is part of GnuPG.
 *
 * GnuPG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GnuPG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef GNUPG_DYNLOAD_H
#define GNUPG_DYNLOAD_H
#ifndef __MINGW32__
#include <dlfcn.h>
#else
#include <windows.h>

static __inline__ void *
dlopen (const char * name, int flag)
{
  void * hd = LoadLibrary (name);
  return hd;
}

static __inline__ void *
dlsym (void *hd, const char *sym)
{
  if (hd && sym)
    {
      void * fnc = GetProcAddress (hd, sym);
      if (!fnc)
        return NULL;
      return fnc;
    }
  return NULL;
}


static __inline__ const char *
dlerror (void)
{
  static char buf[32];
  sprintf (buf, "ec=%lu", GetLastError ());
  return buf;
}


static __inline__ int
dlclose (void * hd)
{
  if (hd)
    {
      CloseHandle (hd);
      return 0;
    }
  return -1;
}  
#endif /*__MINGW32__*/
#endif /*GNUPG_DYNLOAD_H*/
