#ifndef IIOP_TYPES_H
#define IIOP_TYPES_H 1

/* XXX todo sync this up with basic_types.h if needed */
#include <unistd.h>
#include <netinet/in.h>

#include <ORBitutil/basic_types.h>

typedef struct {
  GIOP_octet major, minor;
} GIOPVersion;

typedef enum {
  GIOP_CONNECTION_SERVER, /* Not a real connection to any place - just
			     listening */
  GIOP_CONNECTION_CLIENT
} GIOPConnectionClass;

typedef struct _GIOPConnection GIOPConnection;
struct _GIOPConnection {
  enum { GIOP_CONNECTION_NONE, GIOP_CONNECTION_IIOP } connection_type;
  void (*destroy_func)(GIOPConnection *connection);
  int (*get_fd_func)(GIOPConnection *connection);
  gint refcount;
  gboolean is_valid;
  GIOPConnectionClass connection_class;
  enum { EV_READ, EV_HUP } last_event;

  /* You can access these if you wish. */
  gpointer orb_data;
  gpointer user_data;
};

#define GIOP_CONNECTION(x) ((GIOPConnection *)(x))
#define GIOP_CONNECTION_GET_FD(x) GIOP_CONNECTION((x))->get_fd_func(GIOP_CONNECTION((x)))

typedef struct {
  GIOPConnection giop_connection;
  int fd;
  char *hostname;
  struct sockaddr_in location; /* Yes, we need hostname as well,
				  because hostname <-> IP mappings are not
				  always 1:1 */
  gboolean is_serversock;
} IIOPConnection;

#define IIOP_CONNECTION(x) ((IIOPConnection *)(x))

#define giop_connection_ref(x) (GIOP_CONNECTION(x)->refcount++)

#define giop_connection_unref(x) do { GIOP_CONNECTION(x)->refcount--; \
if(GIOP_CONNECTION(x)->refcount <= 0) giop_connection_free(x); } while(0)


#endif /* IIOP_TYPES_H */
