#include "util.h"

#define MAX_IOVS 16

int proxy_writev(int fd, const struct  iovec *  vector,  size_t count)
{
  int retval = 0;

  while(count > MAX_IOVS) {
    retval += writev(fd, vector, MAX_IOVS);
    vector += MAX_IOVS; count -= MAX_IOVS;
  }

  return writev(fd, vector, count) + retval;
}
