BEGIN {
  print "#ifndef machine_endian_h_";
  print "#define machine_endian_h_";
}

# For each `#define HAVE_FOO BAR', set def["HAVE_FOO"] = BAR
/^\#define[ \t]/ { def[$2] = $3; }

END {
  if (def["HAVE_MACHINE_ENDIAN_H"] || def["HAVE_ENDIAN_H"]) {
    if (def["HAVE_MACHINE_ENDIAN_H"])
      print "#include <machine/endian.h>";
    else
      print "#include <endian.h>";
    print "#if BYTE_ORDER == LITTLE_ENDIAN";
    print "# define MACHINE_IS_LITTLE_ENDIAN";
    print "#elif BYTE_ORDER == BIG_ENDIAN";
    print "# define MACHINE_IS_BIG_ENDIAN";
    print "#else /* BYTE_ORDER */";
    print "# error Cannot determine byte order -- unknown BYTE_ORDER";
    print "#endif";
  }
  else if (def["HAVE_SYS_ISA_DEFS_H"]) {
    print "#include <sys/isa_defs.h>";
    print "#ifdef _BIG_ENDIAN";
    print "# define MACHINE_IS_BIG_ENDIAN";
    print "#elif defined _LITTLE_ENDIAN";
    print "# define MACHINE_IS_LITTLE_ENDIAN";
    print "#else";
    print "# error Cannot determine byte order";
    print "#endif /*! _BIG_ENDIAN */";
  }
  else
    print "#error Cannot determine byte order -- unknown machine type";

  print "#endif /* machine_endian_h_ */";
}

