/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#ifndef _ORBIT_BOA_H_
#define _ORBIT_BOA_H_

#include "orbit_types.h"

extern void CORBA_BOA_set_exception(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_exception_type major,
	CORBA_char *exceptname,
	void *param);

extern CORBA_Object CORBA_BOA_create(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_ReferenceData *id,
	CORBA_InterfaceDef intf,
	CORBA_ImplementationDef impl);

extern void CORBA_BOA_dispose(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_Object obj);

extern CORBA_ReferenceData *CORBA_BOA_get_id(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_Object obj);

extern void CORBA_BOA_change_implementation(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_Object obj,
	CORBA_ImplementationDef impl);

extern CORBA_Principal *CORBA_BOA_get_principal(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_Object obj);

extern CORBA_BOA CORBA_ORB_BOA_init(
	CORBA_ORB orb,
	int *argc,
	char **argv,
	CORBA_ORB_OAid boa_identifier,
	CORBA_Environment *ev);

extern void CORBA_BOA_impl_is_ready(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_ImplementationDef impl);

extern void CORBA_BOA_deactivate_impl(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_ImplementationDef impl);

extern void CORBA_BOA_obj_is_ready(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_Object obj,
	CORBA_ImplementationDef impl);

extern void CORBA_BOA_deactivate_obj(
	CORBA_BOA boa,
	CORBA_Environment *ev,
	CORBA_Object obj);

#endif /* !_ORBIT_BOA_H_ */
