/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#ifndef _ORBIT_CORBA_PORTABLESERVER_TYPE_H_
#define _ORBIT_CORBA_PORTABLESERVER_TYPE_H_

/* 19.26 */

typedef void *PortableServer_ServantLocator_Cookie;
typedef void *PortableServer_Servant;

typedef struct PortableServer_ForwardRequest {
	CORBA_Object forward_reference;
} PortableServer_ForwardRequest;


struct PortableServer_ThreadPolicy_type {
	int fill_me_in;
};


struct PortableServer_LifespanPolicy_type {
	int fill_me_in;
};


struct PortableServer_IdUniquenessPolicy_type {
	int fill_me_in;
};


struct PortableServer_IdAssignmentPolicy_type {
	int fill_me_in;
};


struct PortableServer_ImplicitActivationPolicy_type {
	int fill_me_in;
};


struct PortableServer_ServantRetentionPolicy_type {
	int fill_me_in;
};


struct PortableServer_RequestProcessingPolicy_type {
	int fill_me_in;
};

typedef struct PortableServer_POAManager_AdapterInactive {
	int dummy;
} PortableServer_POAManager_AdapterInactive;

struct PortableServer_POAManager_type {
	struct ORBit_PseudoObject_struct parent;
	GSList* poa_collection;
	CORBA_ORB orb;
};

struct PortableServer_AdapterActivator_type {
	int fill_me_in;
};

struct PortableServer_ServantManager_type {
	int fill_me_in;
};

struct PortableServer_ServantActivator_type {
	int fill_me_in;
};

struct PortableServer_ServantLocator_type {
	int fill_me_in;
};


typedef struct PortableServer_POA_AdapterAlreadyExists {
	int dummy;
} PortableServer_POA_AdapterAlreadyExists;

typedef struct PortableServer_POA_AdapterInactive {
	int dummy;
} PortableServer_POA_AdapterInactive;

typedef struct PortableServer_POA_AdapterNonExistent {
	int dummy;
} PortableServer_POA_AdapterNonExistent;

typedef struct PortableServer_POA_InvalidPolicy {
	CORBA_unsigned_short index;
} PortableServer_POA_InvalidPolicy;

typedef struct PortableServer_POA_NoServant {
	int dummy;
} PortableServer_POA_NoServant;

typedef struct PortableServer_POA_ObjectAlreadyActive {
	int dummy;
} PortableServer_POA_ObjectAlreadyActive;

typedef struct PortableServer_POA_ObjectNotActive {
	int dummy;
} PortableServer_POA_ObjectNotActive;

typedef struct PortableServer_POA_ServantAlreadyActive {
	int dummy;
} PortableServer_POA_ServantAlreadyActive;

typedef struct PortableServer_POA_ServantNotActive {
	int dummy;
} PortableServer_POA_ServantNotActive;

typedef struct PortableServer_POA_WrongAdapter {
	int dummy;
} PortableServer_POA_WrongAdapter;

typedef struct PortableServer_POA_WrongPolicy {
	int dummy;
} PortableServer_POA_WrongPolicy;

typedef struct PortableServer_Current_NoContext {
	int dummy;
} PortableServer_Current_NoContext;

struct PortableServer_Current_type {
	int fill_me_in;
};

typedef struct PortableServer_ServantBase__epv {
	void *_private;
	void (*finalize)(PortableServer_Servant, CORBA_Environment *);
	PortableServer_POA (*default_POA)(PortableServer_Servant, CORBA_Environment *);
} PortableServer_ServantBase__epv;

typedef PortableServer_ServantBase__epv *PortableServer_ServantBase__vepv;

typedef struct PortableServer_ServantBase {
	void *_private;
	PortableServer_ServantBase__vepv *vepv;
} PortableServer_ServantBase;

/* 19.27 */

typedef void (*PortableServer_DynamicImplRoutine) (PortableServer_Servant servant, CORBA_ServerRequest request);

typedef struct PortableServer_DynamicImpl__epv {
	void *_private;
	PortableServer_DynamicImplRoutine invoke;
	CORBA_RepositoryId (*primary_interface) (PortableServer_Servant svt, PortableServer_ObjectId id, PortableServer_POA poa, CORBA_Environment *env);
} PortableServer_DynamicImpl__epv;

typedef struct PortableServer_DynamicImpl__vepv {
	PortableServer_ServantBase__epv *_base_epv;
	PortableServer_DynamicImpl__epv *PortableServer_DynamicImpl_epv;
} PortableServer_DynamicImpl__vepv;

typedef struct PortableServer_DynamicImpl {
	void *_private;
	PortableServer_DynamicImpl__vepv *vepv;
} PortableServer_DynamicImpl;

typedef void (*ORBitSkeleton)(PortableServer_ServantBase *_ORBIT_servant,
			      gpointer _ORBIT_recv_buffer,
			      CORBA_Environment *ev,
			      gpointer implementation);
typedef struct {
	ORBitSkeleton (*relay_call)(PortableServer_ServantBase *servant,
				    gpointer _ORBIT_recv_buffer,
				    gpointer *implementation);
	const gchar *class_name;
} PortableServer_ClassInfo;

typedef struct {
	PortableServer_ClassInfo *class_info;
	PortableServer_ObjectId *object_id;
} ORBit_ObjectKey;

#define ORBIT_OBJECT_KEY(x) ((ORBit_ObjectKey *)(x))

#endif /* !_ORBIT_CORBA_PORTABLESERVER_TYPE_H_ */
