/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter and Red Hat Software
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Phil Dawes <philipd@parallax.co.uk>
 *
 */

/*
 *   ORBit specific CORBA_Object functions.
 *
 */

#include <string.h>

#include "orbit_object_type.h"
#include "corba_object_type.h"
#include "allocators.h"

static void CORBA_Object_release_fn(CORBA_Object obj, CORBA_Environment *ev);

ORBit_RootObject_Interface CORBA_Object_epv =
{
	(gpointer)CORBA_Object_release_fn,
};

void ORBit_pseudo_object_init(ORBit_PseudoObject obj,
			      ORBit_PseudoObject_type obj_type)
{
	ORBIT_ROOT_OBJECT(obj)->is_pseudo_object = TRUE;
	ORBIT_ROOT_OBJECT(obj)->refs = 0;
	ORBIT_PSEUDO_OBJECT(obj)->pseudo_object_type = obj_type;
}

void ORBit_object_reference_init(CORBA_Object obj, CORBA_Environment *ev)
{
	ORBIT_ROOT_OBJECT(obj)->is_pseudo_object = FALSE;
	ORBIT_ROOT_OBJECT(obj)->refs = 0;
	/* set the interface up */
	ORBit_RootObject_set_interface(ORBIT_ROOT_OBJECT(obj),&CORBA_Object_epv,ev);
	/* initialise the reference count */
	ORBIT_ROOT_OBJECT(obj)->refs = 0; 
       
}

CORBA_Object 
ORBit_CORBA_Object_new(CORBA_Environment *ev)
{
	CORBA_Object obj;
	/* Create the object */
	obj = ORBIT_CHUNK_ALLOC(CORBA_Object);
	memset(obj, '\0', sizeof(struct CORBA_Object_struct));

	ORBit_object_reference_init(obj, ev);

	return obj;
  
	if(obj == NULL) {
		CORBA_exception_set_system(ev, ex_CORBA_NO_MEMORY, CORBA_COMPLETED_NO);
		goto error;
	}

	return obj;

error:
	if(obj != NULL){
		CORBA_free(obj);
	}
	return NULL;

}

void
ORBit_set_object_key(CORBA_Object obj,
		     gpointer key,
		     CORBA_unsigned_long key_len)
{
	obj->object_key._maximum = 0;
	obj->object_key._length = key_len;
	obj->object_key._buffer = key;

	obj->object_key_data = g_malloc(sizeof(CORBA_unsigned_long) + key_len);
	obj->object_key_data->_length = key_len;
	memcpy(obj->object_key_data->_buffer, key, key_len);

	obj->object_key_vec.iov_base = (gpointer)obj->object_key_data;
	obj->object_key_vec.iov_len = sizeof(CORBA_unsigned_long) + key_len;
}

/* this function is wired up to the RootObject interface */
void 
CORBA_Object_release_fn(CORBA_Object obj, CORBA_Environment *ev)
{

	g_assert(obj!=NULL);

	ORBIT_ROOT_OBJECT_UNREF(obj);

	if(ORBIT_ROOT_OBJECT(obj)->refs <= 0) {
	  giop_connection_unref(obj->connection);
	  g_free(obj->obj_id);
	  g_free(obj->object_key_data);
	  ORBIT_CHUNK_FREE(CORBA_Object, obj);
	}

	return;
}


/* Sets the interface member in the RootObject to the epv specified*/
void
ORBit_RootObject_set_interface(ORBit_RootObject obj,
			       ORBit_RootObject_Interface* epv,
			       CORBA_Environment *ev)
{
	g_assert(obj!=NULL);
	g_assert(epv!=NULL);

	obj->interface = epv;
}

