/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter and Red Hat Software
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#ifndef _ORBIT_TYPES_H_
#define _ORBIT_TYPES_H_

#include <stddef.h>	/* for wchar_t */
#include <sys/types.h>  /* for sysdep types */
#include <netinet/in.h>	/* for sockaddr_in */
#include <sys/uio.h> /* for struct iovec */

#include <ORBitutil/basic_types.h>

#define CORBA_TRUE 1
#define CORBA_FALSE 0

typedef CORBA_char *CORBA_ORBid;
typedef CORBA_char *CORBA_Identifier;
typedef CORBA_char *CORBA_ScopedName;
typedef CORBA_char *CORBA_RepositoryId;

typedef CORBA_unsigned_long CORBA_ServiceOption;
typedef CORBA_unsigned_long CORBA_ServiceDetailType;

#include "corba_orb.h"

typedef CORBA_Identifier CORBA_ContextIdentifier;

#include "corba_any.h"

#include "corba_ir.h"

typedef struct CORBA_StructMember_type CORBA_StructMember;
typedef struct CORBA_UnionMember_type CORBA_UnionMember;
typedef struct CORBA_ParameterDescription_type CORBA_ParameterDescription;
typedef struct CORBA_ExceptionDef_type CORBA_ExceptionDef;
typedef struct CORBA_ExceptionDescription_type CORBA_ExceptionDescription;
typedef struct CORBA_AttributeDescription_type CORBA_AttributeDescription;
typedef struct CORBA_ServiceDetail_type CORBA_ServiceDetail;
typedef struct CORBA_Request_type *CORBA_Request;
typedef struct CORBA_ServerRequest_type CORBA_ServerRequest;
typedef CORBA_char *CORBA_Context;
typedef struct CORBA_DynFixed_type CORBA_DynFixed;
typedef struct CORBA_DynAny_type CORBA_DynAny;
typedef struct CORBA_DynEnum_type CORBA_DynEnum;
typedef struct CORBA_DynStruct_type CORBA_DynStruct;
typedef struct CORBA_DynUnion_type CORBA_DynUnion;
typedef struct CORBA_DynSequence_type CORBA_DynSequence;
typedef struct CORBA_DynArray_type CORBA_DynArray;
typedef struct CORBA_IRObject_type CORBA_IRObject;
typedef struct CORBA_Container_type CORBA_Container;
typedef struct CORBA_Repository_type CORBA_Repository;
typedef struct CORBA_ModuleDef_type CORBA_ModuleDef;
typedef struct CORBA_ConstantDef_type CORBA_ConstantDef;
typedef struct CORBA_TypedefDef_type CORBA_TypedefDef;
typedef struct CORBA_StructDef_type CORBA_StructDef;
typedef struct CORBA_UnionDef_type CORBA_UnionDef;
typedef struct CORBA_EnumDef_type CORBA_EnumDef;
typedef struct CORBA_AliasDef_type CORBA_AliasDef;
typedef struct CORBA_PrimitiveDef_type CORBA_PrimitiveDef;
typedef struct CORBA_StringDef_type CORBA_StringDef;
typedef struct CORBA_WstringDef_type CORBA_WstringDef;
typedef struct CORBA_FixedDef_type CORBA_FixedDef;
typedef struct CORBA_SequenceDef_type CORBA_SequenceDef;
typedef struct CORBA_ArrayDef_type CORBA_ArrayDef;
typedef struct CORBA_AttributeDef_type CORBA_AttributeDef;
typedef struct CORBA_OperationDef_type CORBA_OperationDef;
typedef struct CORBA_IDLType_type CORBA_IDLType;
typedef struct CORBA_Current_type CORBA_Current;

#include "corba_portableserver.h"

#include "corba_env.h"

#include "corba_sequences_type.h"

#include "corba_basic_sequences_type.h"

#include "corba_object.h"

#include "orbit_object_type.h"

#include "corba_object_type.h"

#include "corba_orb_type.h"


typedef struct CORBA_BOA_type *CORBA_BOA;

struct CORBA_BOA_type {
	struct ORBit_PseudoObject_struct parent;
	int fill_me_in;
};

typedef CORBA_unsigned_long CORBA_Status;

struct CORBA_ImplementationDef_type {
	int fill_me_in;
};

typedef unsigned int CORBA_enum;


#include "corba_typecode.h"
#include "corba_typecode_type.h"
#include "corba_any_type.h"

/* 19.14 */

/* XXX */
typedef struct CORBA_fixed_d_s {
	CORBA_unsigned_short _digits;
	CORBA_short _scale;
	signed char _sign;
	signed char _value[0];
} CORBA_fixed_d_s;

#include "corba_env_type.h"


typedef struct CORBA_WrongTransaction {
	int dummy;
} CORBA_WrongTransaction;

typedef CORBA_unsigned_long CORBA_Flags;

#define CORBA_ARG_IN (1<<0)
#define CORBA_ARG_OUT (1<<1)
#define CORBA_ARG_INOUT (1<<2)
#define CORBA_CTX_RESTRICT_SCOPE (1<<3)
#define CORBA_CTX_DELETE_DESCENDENTS (1<<4)
#define CORBA_OUT_LIST_MEMORY (1<<5)
#define CORBA_IN_COPY_VALUE (1<<6)
#define CORBA_DEPENDENT_LIST (1<<7)
#define CORBA_INV_NO_RESPONSE (1<<8)
#define CORBA_INV_TERM_ON_ERROR (1<<9)
#define CORBA_RESP_NO_WAIT (1<<10)

typedef struct CORBA_NamedValue {
	CORBA_Identifier name;		/* argument name */
	CORBA_any argument;		/* argument */
	CORBA_long len;			/* length/count of argument value */
	CORBA_Flags arg_modes;		/* argument mode flags */
} CORBA_NamedValue;

typedef struct CORBA_NVList_type {
	CORBA_unsigned_long count;
	CORBA_unsigned_long last_add;
	CORBA_Flags flags;
	CORBA_NamedValue *list;
} CORBA_NVList;

struct CORBA_Request_type {
	CORBA_Object obj;
	CORBA_Context ctx;
	CORBA_Identifier operation;
	CORBA_NamedValue *result;
	CORBA_Flags req_flags;
	CORBA_NVList *arg_list;
	CORBA_unsigned_long request_id;
	gpointer request_buffer, reply_buffer; /* It'd be nice to have these
						  actually GIOP*Buffer
						  pointers, but we get
						  circular refs & such then */
};

struct CORBA_ServerRequest_type {
	int fill_me_in;
};

typedef struct CORBA_DynAny_Invalid {
	int dummy;
} CORBA_DynAny_Invalid;

typedef struct CORBA_DynAny_InvalidValue {
	int dummy;
} CORBA_DynAny_InvalidValue;

typedef struct CORBA_DynAny_TypeMismatch {
	int dummy;
} CORBA_DynAny_TypeMismatch;

typedef struct CORBA_DynAny_InvalidSeq {
	int dummy;
} CORBA_DynAny_InvalidSeq;

typedef struct CORBA_DynFixed_Invalid {
	int dummy;
} CORBA_DynFixed_Invalid;

typedef struct CORBA_DynFixed_InvalidValue {
	int dummy;
} CORBA_DynFixed_InvalidValue;

typedef struct CORBA_DynFixed_TypeMismatch {
	int dummy;
} CORBA_DynFixed_TypeMismatch;

typedef struct CORBA_DynFixed_InvalidSeq {
	int dummy;
} CORBA_DynFixed_InvalidSeq;

struct CORBA_DynFixed_type {
	int fill_me_in;
};

struct CORBA_DynAny_type {
	int fill_me_in;
};

typedef struct CORBA_DynEnum_Invalid {
	int dummy;
} CORBA_DynEnum_Invalid;

typedef struct CORBA_DynEnum_InvalidValue {
	int dummy;
} CORBA_DynEnum_InvalidValue;

typedef struct CORBA_DynEnum_TypeMismatch {
	int dummy;
} CORBA_DynEnum_TypeMismatch;

typedef struct CORBA_DynEnum_InvalidSeq {
	int dummy;
} CORBA_DynEnum_InvalidSeq;

struct CORBA_DynEnum_type {
	int fill_me_in;
};

typedef CORBA_char *CORBA_FieldName;

typedef struct CORBA_NameValuePair {
	CORBA_FieldName id;
	CORBA_any value;
} CORBA_NameValuePair;

typedef struct CORBA_DynStruct_Invalid {
	int dummy;
} CORBA_DynStruct_Invalid;

typedef struct CORBA_DynStruct_InvalidValue {
	int dummy;
} CORBA_DynStruct_InvalidValue;

typedef struct CORBA_DynStruct_TypeMismatch {
	int dummy;
} CORBA_DynStruct_TypeMismatch;

typedef struct CORBA_DynStruct_InvalidSeq {
	int dummy;
} CORBA_DynStruct_InvalidSeq;

struct CORBA_DynStruct_type {
	int fill_me_in;
};

typedef struct CORBA_DynUnion_Invalid {
	int dummy;
} CORBA_DynUnion_Invalid;

typedef struct CORBA_DynUnion_InvalidValue {
	int dummy;
} CORBA_DynUnion_InvalidValue;

typedef struct CORBA_DynUnion_TypeMismatch {
	int dummy;
} CORBA_DynUnion_TypeMismatch;

typedef struct CORBA_DynUnion_InvalidSeq {
	int dummy;
} CORBA_DynUnion_InvalidSeq;

struct CORBA_DynUnion_type {
	int fill_me_in;
};

typedef struct CORBA_DynSequence_Invalid {
	int dummy;
} CORBA_DynSequence_Invalid;

typedef struct CORBA_DynSequence_InvalidValue {
	int dummy;
} CORBA_DynSequence_InvalidValue;

typedef struct CORBA_DynSequence_TypeMismatch {
	int dummy;
} CORBA_DynSequence_TypeMismatch;

typedef struct CORBA_DynSequence_InvalidSeq {
	int dummy;
} CORBA_DynSequence_InvalidSeq;

struct CORBA_DynSequence_type {
	int fill_me_in;
};

typedef struct CORBA_DynArray_Invalid {
	int dummy;
} CORBA_DynArray_Invalid;

typedef struct CORBA_DynArray_InvalidValue {
	int dummy;
} CORBA_DynArray_InvalidValue;

typedef struct CORBA_DynArray_TypeMismatch {
	int dummy;
} CORBA_DynArray_TypeMismatch;

typedef struct CORBA_DynArray_InvalidSeq {
	int dummy;
} CORBA_DynArray_InvalidSeq;

struct CORBA_DynArray_type {
	int fill_me_in;
};

typedef enum {
	CORBA_dk_none=0,
	CORBA_dk_all,
	CORBA_dk_Attribute,
	CORBA_dk_Constant,
	CORBA_dk_Exception,
	CORBA_dk_Interface,
	CORBA_dk_Module,
	CORBA_dk_Operation,
	CORBA_dk_Typedef,
	CORBA_dk_Alias,
	CORBA_dk_Struct,
	CORBA_dk_Union,
	CORBA_dk_Enum,
	CORBA_dk_Primitive,
	CORBA_dk_String,
	CORBA_dk_Sequence,
	CORBA_dk_Array,
	CORBA_dk_Repository,
	CORBA_dk_Wstring,
	CORBA_dk_Fixed
} CORBA_DefinitionKind;

struct CORBA_IRObject_type {
	CORBA_DefinitionKind def_kind;
};

typedef CORBA_char *CORBA_VersionSpec;

struct CORBA_Container_type {
	int fill_me_in;
};

struct CORBA_Contained_type {
	int fill_me_in;
};

struct CORBA_Repository_type {
	int fill_me_in;
};

struct CORBA_ModuleDef_type {
	int fill_me_in;
};

struct CORBA_ConstantDef_type {
	int fill_me_in;
};

struct CORBA_TypedefDef_type {
	int fill_me_in;
};

struct CORBA_StructDef_type {
	int fill_me_in;
};

struct CORBA_UnionDef_type {
	int fill_me_in;
};

struct CORBA_EnumDef_type {
	int fill_me_in;
};

struct CORBA_AliasDef_type {
	int fill_me_in;
};

struct CORBA_PrimitiveDef_type {
	int fill_me_in;
};

struct CORBA_StringDef_type {
	int fill_me_in;
};

struct CORBA_WstringDef_type {
	int fill_me_in;
};

struct CORBA_FixedDef_type {
	int fill_me_in;
};

struct CORBA_SequenceDef_type {
	int fill_me_in;
};

struct CORBA_ArrayDef_type {
	int fill_me_in;
};

struct CORBA_ExceptionDef_type {
	int fill_me_in;
};

struct CORBA_AttributeDef_type {
	int fill_me_in;
};

struct CORBA_OperationDef_type {
	int fill_me_in;
};

struct CORBA_InterfaceDef_type {
	int fill_me_in;
};

typedef struct CORBA_Contained_Description {
	CORBA_DefinitionKind kind;
	CORBA_any value;
} CORBA_Contained_Description;

struct CORBA_IDLType_type {
	int fill_me_in;
};

typedef struct CORBA_Container_Description {
	CORBA_Contained contained_object;
	CORBA_DefinitionKind kind;
	CORBA_any value;
} CORBA_Container_Description;

struct CORBA_StructMember_type {
	CORBA_Identifier name;
	CORBA_TypeCode type;
	CORBA_IDLType type_def;
};

struct CORBA_UnionMember_type {
	CORBA_Identifier name;
	CORBA_any label;
	CORBA_TypeCode type;
	CORBA_IDLType type_def;
};

typedef enum {
	CORBA_pk_null=0,
	CORBA_pk_void,
	CORBA_pk_short,
	CORBA_pk_long,
	CORBA_pk_ushort,
	CORBA_pk_ulong,
	CORBA_pk_float,
	CORBA_pk_double,
	CORBA_pk_boolean,
	CORBA_pk_char,
	CORBA_pk_octet,
	CORBA_pk_any,
	CORBA_pk_TypeCode,
	CORBA_pk_Principal,
	CORBA_pk_string,
	CORBA_pk_objref,
	CORBA_pk_longlong,
	CORBA_pk_ulonglong,
	CORBA_pk_longdouble,
	CORBA_pk_wchar,
	CORBA_pk_wstring
} CORBA_PrimitiveKind;

typedef struct CORBA_ModuleDescription {
	CORBA_Identifier name;
	CORBA_RepositoryId id;
	CORBA_RepositoryId defined_in;
	CORBA_VersionSpec version;
} CORBA_ModuleDescription;

typedef struct CORBA_ConstantDescription {
	CORBA_Identifier name;
	CORBA_RepositoryId id;
	CORBA_RepositoryId defined_in;
	CORBA_VersionSpec version;
	CORBA_TypeCode type;
	CORBA_any value;
} CORBA_ConstantDescription;

typedef struct CORBA_TypeDescription {
	CORBA_Identifier name;
	CORBA_RepositoryId id;
	CORBA_RepositoryId defined_in;
	CORBA_VersionSpec version;
	CORBA_TypeCode type;
} CORBA_TypeDescription;

struct CORBA_ExceptionDescription_type {
	CORBA_Identifier name;
	CORBA_RepositoryId id;
	CORBA_RepositoryId defined_in;
	CORBA_VersionSpec version;
	CORBA_TypeCode type;
};

typedef enum {
	CORBA_ATTR_NORMAL=0,
	CORBA_ATTR_READONLY
} CORBA_AttributeMode;

struct CORBA_AttributeDescription_type {
	CORBA_Identifier name;
	CORBA_RepositoryId id;
	CORBA_RepositoryId defined_in;
	CORBA_VersionSpec version;
	CORBA_TypeCode type;
	CORBA_AttributeMode mode;
};

typedef enum {
	CORBA_OP_NORMAL=0,
	CORBA_OP_ONEWAY
} CORBA_OperationMode;

typedef enum {
	CORBA_PARAM_IN=0,
	CORBA_PARAM_OUT,
	CORBA_PARAM_INOUT
} CORBA_ParameterMode;

struct CORBA_ParameterDescription_type {
	CORBA_Identifier name;
	CORBA_TypeCode type;
	CORBA_IDLType type_def;
	CORBA_ParameterMode mode;
};

typedef struct CORBA_OperationDescription {
	CORBA_Identifier name;
	CORBA_RepositoryId id;
	CORBA_RepositoryId defined_in;
	CORBA_VersionSpec version;
	CORBA_TypeCode result;
	CORBA_OperationMode mode;
	CORBA_ContextIdSeq contexts;
	CORBA_ParDescriptionSeq parameters;
	CORBA_ExcDescriptionSeq exceptions;
} CORBA_OperationDescription;

typedef struct CORBA_InterfaceDef_FullInterfaceDescription {
	CORBA_Identifier name;
	CORBA_RepositoryId id;
	CORBA_RepositoryId defined_in;
	CORBA_VersionSpec version;
	CORBA_OpDescriptionSeq operations;
	CORBA_AttrDescriptionSeq attributes;
	CORBA_RepositoryIdSeq base_interfaces;
	CORBA_TypeCode type;
} CORBA_InterfaceDef_FullInterfaceDescription;

typedef struct CORBA_InterfaceDescription {
	CORBA_Identifier name;
	CORBA_RepositoryId id;
	CORBA_RepositoryId defined_in;
	CORBA_VersionSpec version;
	CORBA_RepositoryIdSeq base_interfaces;
} CORBA_InterfaceDescription;

struct CORBA_Current_type {
};

#include "corba_portableserver_type.h"

typedef CORBA_unsigned_short CORBA_ServiceType;

#define CORBA_Security (1)

struct CORBA_ServiceDetail_type {
	CORBA_ServiceDetailType service_detail_type;
	CORBA_sequence_octet service_detail;
};

typedef struct CORBA_ServiceInformation_struct {
	CORBA_sequence_ServiceOption service_options;
	CORBA_sequence_ServiceDetail service_details;
} CORBA_ServiceInformation;

/* Some bits needed for BOA backwards compatibility follow */

/* v2.1, 17.26 */

typedef void (*DynamicImplementationRoutine) (CORBA_Object target,
					      CORBA_ServerRequest request,
					      CORBA_Environment *ev);

/* v2.1, 17.28.2 */

typedef CORBA_char *CORBA_ORB_OAid;

typedef struct {
	gpointer (*alloc)(void);
} ORBit_exception_info;

#endif /* !_ORBIT_TYPES_H_ */
