/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Elliot's stuff */
/* This is somewhat a mess, because I tried to make it easy to add
   select() support, and as a result #ifdef's litter the land. */

#include "orbit.h"
#include "orbit_poa.h"
#include "orbit_poa_type.h"
#include <sys/poll.h>
#include <sys/types.h>
#include <sys/socket.h>

/* We need:
   a way to find out what FD's need to be selected on
   a dummy main loop to implement the CORBA_ORB_run() routine;
*/

gboolean orb_server_keep_running = FALSE;

/* function protos */
static PortableServer_POA ORBit_find_POA_for_request(PortableServer_POA poa,
						     GIOPRecvBuffer *recv_buffer);

static void ORBit_handle_incoming_message(GIOPRecvBuffer *recv_buffer);

void
ORBit_custom_run_setup(CORBA_ORB orb, CORBA_Environment *ev)
{
	IIOPIncomingMessageHandler = ORBit_handle_incoming_message;
}

void
CORBA_ORB_run(CORBA_ORB orb, CORBA_Environment *ev)
{
	ORBit_custom_run_setup(orb, ev);

	orb_server_keep_running = TRUE;

	giop_main();
}

static void
ORBit_handle_incoming_message(GIOPRecvBuffer *recv_buffer)
{
	CORBA_ORB orb;
	PortableServer_POA poa;
	GIOPConnection *connection;

	g_assert(recv_buffer!=NULL);

	connection = GIOP_MESSAGE_BUFFER(recv_buffer)->connection;
	g_return_if_fail(connection != NULL);

	orb = connection->orb_data;

	g_return_if_fail(orb != NULL);

	switch(GIOP_MESSAGE_BUFFER(recv_buffer)->message_header.message_type) {
	case GIOP_REQUEST:
		/* Find the POA for this incoming request */
		poa = ORBit_find_POA_for_request((PortableServer_POA)orb->root_poa,
						 recv_buffer);
		
		g_assert(poa);
		ORBit_POA_handle_request(poa, recv_buffer);
		giop_recv_buffer_unuse(recv_buffer);
		break;
	case GIOP_CLOSECONNECTION:
		giop_connection_unref(connection);
		giop_recv_buffer_unuse(recv_buffer);
		break;
	default:
		g_warning("discarding message type %d (id possibly %d)\n",
			  GIOP_MESSAGE_BUFFER(recv_buffer)->message_header.message_type,
			  GIOP_MESSAGE_BUFFER(recv_buffer)->message_header.message_type?recv_buffer->message.u.reply.request_id:recv_buffer->message.u.request.request_id);
		break;
	}
}

static PortableServer_POA
ORBit_find_POA_for_request(PortableServer_POA poa,
			   GIOPRecvBuffer *recv_buffer)
{
	gpointer retval = NULL;
	GSList *curitem;

	retval = g_hash_table_lookup(poa->active_object_map,
				     recv_buffer->message.u.request.object_key._buffer);

	if(retval)
		return poa;

	for(curitem = poa->child_POAs; curitem;
	    curitem = g_slist_next(curitem)) {
		retval = ORBit_find_POA_for_request(curitem->data, recv_buffer);
		if(retval)
			break;
	}

	return retval;
}
