#include <stdio.h>
#include <orb/orbit.h>
#include "echo.h"

Echo echo_client;

int
main (int argc, char *argv[])
{
    CORBA_Environment ev;
    char *retval;
    CORBA_ORB orb;
    CORBA_long rv;
    int i;

    CORBA_exception_init(&ev);
    orb = CORBA_ORB_init(&argc, argv, "mico-local-orb", &ev);

    if(argc < 2)
      {
	printf("Need a binding ID thing as argv[1]\n");
	return 1;
      }

    /*
     * MICO stuff
     */
    echo_client = CORBA_ORB_string_to_object(orb, argv[1], &ev);
    if (!echo_client) {
	printf("Cannot bind to %s\n", argv[1]);
	return 1;
    }
    for(i = 0; i < 100; i++) {
	    retval = Echo_echoString(echo_client, "hello world", &rv, &ev);
	    if(ev._major == CORBA_NO_EXCEPTION)
	      printf("output was: %s, %d\n", retval, rv);
	    else
	      printf("we got exception %d from it!\n", ev._major);
	    CORBA_free(retval);
    }

    CORBA_Object_release(echo_client, &ev);

    return 0;
}


