#include <stdio.h>
#include <string.h>
#include <orb/orbit.h>
#include "echo.h"

static CORBA_char *do_echoString(PortableServer_Servant servant,
				 CORBA_char *astring,
				 CORBA_long *anum,
				 CORBA_Environment *ev);

PortableServer_ServantBase__epv base_epv = {
  NULL,
  NULL,
  NULL
};
POA_Echo__epv echo_epv = { NULL, do_echoString };
POA_Echo__vepv poa_echo_vepv = { &base_epv, &echo_epv };
POA_Echo poa_echo_servant = { NULL, &poa_echo_vepv };

int
main (int argc, char *argv[])
{
    Echo echo_client;
    PortableServer_ObjectId objid = {0, sizeof("myEchoString"), "myEchoString"};

    CORBA_Environment ev;
    char *retval;
    CORBA_ORB orb;

    CORBA_exception_init(&ev);
    orb = CORBA_ORB_init(&argc, argv, "mico-local-orb", &ev);

    POA_Echo__init(&poa_echo_servant, &ev);

    PortableServer_POA_activate_object_with_id(orb->root_poa,
					       &objid, &poa_echo_servant, &ev);

    echo_client = PortableServer_POA_servant_to_reference(orb->root_poa,
							  &poa_echo_servant,
							  &ev);
    if (!echo_client) {
	printf("Cannot get objref\n");
	return 1;
    }

    retval = CORBA_ORB_object_to_string(orb, echo_client, &ev);

    g_print("%s\n", retval); fflush(stdout);

    CORBA_free(retval);

    CORBA_Object_release(echo_client, &ev);

    CORBA_ORB_run(orb, &ev);

    return 0;
}

static CORBA_char *
do_echoString(PortableServer_Servant servant,
	      CORBA_char *astring,
	      CORBA_long *anum,
	      CORBA_Environment *ev)
{
  char *strings[] = {"hi", "there", "bye", "lear", NULL };
  char *retval;
  int n;

  n = rand() % 4;

  retval = CORBA_string_alloc(strlen(strings[n]));
  strcpy(retval, strings[n]);

  *anum = rand() % 10;

  return retval;
}
