/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_TextExtents
#define _Included_org_freedesktop_cairo_TextExtents
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_TextExtents
 * Method:    get_x_bearing
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_TextExtents_get_1x_1bearing
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_text_extents_t *te = (cairo_text_extents_t*)getPointerFromHandle(env, obj);
	return te->x_bearing;
}

/*
 * Class:     org_freedesktop_cairo_TextExtents
 * Method:    get_y_bearning
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_TextExtents_get_1y_1bearning
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_text_extents_t *te = (cairo_text_extents_t*)getPointerFromHandle(env, obj);
	return te->y_bearing;
}

/*
 * Class:     org_freedesktop_cairo_TextExtents
 * Method:    get_width
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_TextExtents_get_1width
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_text_extents_t *te = (cairo_text_extents_t*)getPointerFromHandle(env, obj);
	return te->width;
}

/*
 * Class:     org_freedesktop_cairo_TextExtents
 * Method:    get_height
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_TextExtents_get_1height
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_text_extents_t *te = (cairo_text_extents_t*)getPointerFromHandle(env, obj);
	return te->height;
}

/*
 * Class:     org_freedesktop_cairo_TextExtents
 * Method:    get_x_advance
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_TextExtents_get_1x_1advance
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_text_extents_t *te = (cairo_text_extents_t*)getPointerFromHandle(env, obj);
	return te->x_advance;
}

/*
 * Class:     org_freedesktop_cairo_TextExtents
 * Method:    get_y_advance
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_TextExtents_get_1y_1advance
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_text_extents_t *te = (cairo_text_extents_t*)getPointerFromHandle(env, obj);
	return te->y_advance;
}

/*
 * Class:     org_freedesktop_cairo_TextExtents
 * Method:    free
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_TextExtents_free
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_text_extents_t *te;
	
	te = (cairo_text_extents_t*)getPointerFromHandle(env, obj);
	g_free(te);
}


#ifdef __cplusplus
}
#endif
#endif
