/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* camel-mbox-store.h : class for an mbox store */

/* 
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of version 2 of the GNU Lesser General Public 
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

#ifndef CAMEL_LOCAL_STORE_H
#define CAMEL_LOCAL_STORE_H 1

#include "camel-store.h"

#define CAMEL_LOCAL_STORE_TYPE     (camel_local_store_get_type ())
#define CAMEL_LOCAL_STORE(obj)     (CAMEL_CHECK_CAST((obj), CAMEL_LOCAL_STORE_TYPE, CamelLocalStore))
#define CAMEL_LOCAL_STORE_CLASS(k) (CAMEL_CHECK_CLASS_CAST ((k), CAMEL_LOCAL_STORE_TYPE, CamelLocalStoreClass))
#define CAMEL_IS_LOCAL_STORE(o)    (CAMEL_CHECK_TYPE((o), CAMEL_LOCAL_STORE_TYPE))

G_BEGIN_DECLS

typedef struct {
	CamelStore parent_object;	

	char *toplevel_dir;
} CamelLocalStore;

typedef struct {
	CamelStoreClass parent_class;

	char *(*get_full_path)(CamelLocalStore *ls, const char *full_name);
	char *(*get_meta_path)(CamelLocalStore *ls, const char *full_name, const char *ext);
} CamelLocalStoreClass;

/* Standard Camel function */
CamelType camel_local_store_get_type (void);

const gchar *camel_local_store_get_toplevel_dir (CamelLocalStore *store);

#define camel_local_store_get_full_path(ls, name) ((CamelLocalStoreClass *)((CamelObject *)ls)->klass)->get_full_path((CamelLocalStore *)ls, name)
#define camel_local_store_get_meta_path(ls, name, ext) ((CamelLocalStoreClass *)((CamelObject *)ls)->klass)->get_meta_path((CamelLocalStore *)ls, name, ext)

G_END_DECLS

#endif /* CAMEL_LOCAL_STORE_H */


