/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.glib;

/**
 * Holds pointer to native peer on 32 bit platforms.
 */
public class Handle32Bits implements Handle {
    
    int pointer;
    private Struct proxiedObject;
    
    public boolean isNull() {
        return pointer == 0;
    }

    public boolean equals(Handle other) {
        if (other instanceof Handle32Bits)
            return pointer == ((Handle32Bits)other).pointer;
        return false;
    }

    public String toString() {
        return "Handle32Bits - pointer = " + String.valueOf( pointer );
    }
    
    public Struct getProxiedObject() {
        return proxiedObject;
    }
    
    public void setProxiedObject(Struct object) {
        this.proxiedObject = object;
    }
}
