/* -*- Mode: C; c-basic-offset: 4 -*- */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* include this first, before NO_IMPORT_PYGOBJECT is defined */
#include <pygobject.h>
#include <libnautilus/nautilus-view.h>

void pynautilus_register_classes(PyObject *d);

extern PyMethodDef pynautilus_functions[];

DL_EXPORT(void)
initnautilus(void)
{
    PyObject *m, *d;
	
    init_pygobject();

    m = Py_InitModule("nautilus", pynautilus_functions);
    d = PyModule_GetDict(m);
	
    pynautilus_register_classes(d);
    PyModule_AddIntConstant(m, "VIEW_LISTEN_TITLE",
			    NAUTILUS_VIEW_LISTEN_TITLE);
    PyModule_AddIntConstant(m, "VIEW_LISTEN_HISTORY",
			    NAUTILUS_VIEW_LISTEN_HISTORY);
    PyModule_AddIntConstant(m, "VIEW_LISTEN_SELECTION",
			    NAUTILUS_VIEW_LISTEN_SELECTION);    

    if (PyErr_Occurred()) {
	Py_FatalError("can't initialise module nautilus");
    }
}
