/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#ifndef MOCK_LOGGER_H
#define MOCK_LOGGER_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _MockLogger        MockLogger;
typedef struct _MockLoggerClass   MockLoggerClass;
typedef struct _MockLoggerPrivate MockLoggerPrivate;

#define MOCK_TYPE_LOGGER         (mock_logger_get_type ())
#define MOCK_LOGGER(i)           (G_TYPE_CHECK_INSTANCE_CAST ((i), MOCK_TYPE_LOGGER, Mocklogger))
#define MOCK_LOGGER_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST ((c), MOCK_TYPE_LOGGER, MockLoggerClass))
#define MOCK_IS_LOGGER(i)        (G_TYPE_CHECK_INSTANCE_TYPE ((i), MOCK_TYPE_LOGGER))
#define MOCK_IS_LOGGER_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE ((c), MOCK_TYPE_LOGGER))
#define MOCK_LOGGER_GET_CLASS(i) (G_TYPE_INSTANCE_GET_CLASS ((i), MOCK_TYPE_LOGGER, MockLoggerClass))

GType        mock_logger_get_type   (void);
MockLogger*  mock_logger_new        (gchar const     * domain);
gchar const* mock_logger_get_domain (MockLogger const* self);

void mock_logger_log_fail (gchar const   * domain,
			   GLogLevelFlags  log_level,
			   gchar const   * message,
			   gpointer        user_data);

struct _MockLogger {
	GObject            base_instance;
	MockLoggerPrivate* priv;
};

struct _MockLoggerClass {
	GObjectClass base_class;
};

G_BEGIN_DECLS

#endif /* !MOCK_LOGGER_H */
