/* AUTHORS:
 *  Canek and Sven */

#include "s-circle.h"
#include <gtk/gtk.h>
#include <ccc.h>

#include "cc-test-view.h"

START_TEST(test_circle_391646)
{
	/* prepare */
	CcItem*    root  = cc_item_new();
	GtkWidget* view  = cc_view_widget_new_root (root);

	CcColor*   color = cc_color_new_rgb(0.0, 0.0, 0.0);
	CcBrush*   brush = cc_brush_color_new(color);
	CcBrush*   fill  = cc_brush_color_new(cc_color_new_rgb(1.0, 1.0, 1.0));

	CcItem* base = cc_rectangle_new();
	cc_rectangle_set_position(CC_RECTANGLE(base), 0, 0, 600, 400);
	cc_shape_set_brush_border(CC_SHAPE(base), brush);
	cc_shape_set_brush_content(CC_SHAPE(base), fill);
	cc_item_append(root, base);

	CcItem* circle = cc_circle_new();
	cc_item_append(base, circle);

	/* check (segfault within this call) */
	cc_circle_set_radius(CC_CIRCLE(circle), 10);
}
END_TEST

TCase*
tcase_circle_391646 (void)
{
	TCase* self = tcase_create ("Bug 391646");
	tcase_add_test (self, test_circle_391646);
	return self;
}

/* </bug.c> */
