/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-item.h"

#include <ccc/cc-line.h>
#include "cc-test-view.h"

static CcView* view = NULL;
static CcItem* root = NULL;
static CcItem* child = NULL;

static void
setup (void)
{
	view = cc_test_view_new ();
	root = g_object_ref_sink (cc_item_new ());
	child = g_object_ref_sink (cc_line_new ());
}

static void
teardown (void)
{
	g_object_unref (child);
	g_object_unref (root);
	g_object_unref (view);
}

static void
test_item_bounds_to_view_cb (CcItem  * item,
			     CcView  * view,
			     CcDRect * bounds,
			     gboolean* passed)
{
	*passed = TRUE;
}

START_TEST(test_item_bounds_to_view)
{
	gboolean passed;

	/* prepare */
	cc_view_set_root (view, child);
	cc_line_line (CC_LINE (child), 0.0, 0.0);
	g_signal_connect (child, "all-bounds-changed",
			  G_CALLBACK (test_item_bounds_to_view_cb), &passed);

	/* check */
	passed = FALSE;
	cc_line_line (CC_LINE (child), 1.0, 1.0);
	fail_unless (passed);

	/* cleanup */
	g_signal_handlers_disconnect_by_func (child, test_item_bounds_to_view_cb, &passed);
}
END_TEST

static void
test_item_bounds_to_view_lazy_cb (CcItem  * item,
				  CcView  * view,
				  CcDRect * bounds,
				  gboolean* passed)
{
	*passed = TRUE;
}

START_TEST(test_item_bounds_to_view_lazy)
{
	gboolean passed;

	/* prepare */
	cc_line_line (CC_LINE (child), 0.0, 0.0);
	cc_line_line (CC_LINE (child), 1.0, 1.0);
	g_signal_connect (child, "all-bounds-changed",
			  G_CALLBACK (test_item_bounds_to_view_lazy_cb), &passed);

	/* check */
	passed = FALSE;
	cc_view_set_root (view, child);
	fail_unless (passed);

	/* cleanup */
	g_signal_handlers_disconnect_by_func (child, test_item_bounds_to_view_lazy_cb, &passed);
}
END_TEST

START_TEST(test_item_bounds_recurse)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME:
	 *
	 * Make sure that an update that causes a bounding box change, gets
	 * propagated to the parent and from that one to the view.
	 */
}
END_TEST

START_TEST(test_item_bounds_recurse_clean)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME:
	 *
	 * Make sure that an update that causes a bounding box change, gets
	 * propagated to the parent and not to the view directly.
	 */
}
END_TEST

TCase*
tcase_item_bounds_updates (void)
{
	TCase* self = tcase_create ("Bounds Updates");
	tcase_add_checked_fixture (self, setup, teardown);
	tcase_add_test (self, test_item_bounds_to_view);
	tcase_add_test (self, test_item_bounds_to_view_lazy);
	tcase_add_test (self, test_item_bounds_recurse);
	tcase_add_test (self, test_item_bounds_recurse_clean);
	return self;
}

