/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-mock-logger.h"

#include <string.h>
#include "mock-logger.h"

static gchar const* domains[] = {
	"SomeDomain",
	"OtherDomain"
};

START_TEST(test_construct_domain)
{
	/* prepare */
	gchar const* checked;
	MockLogger* logger = mock_logger_new (domains[_i]);

	/* check */
	checked = mock_logger_get_domain (logger);
	fail_unless (checked && !strcmp (domains[_i], checked));

	/* cleanup */
}
END_TEST

START_TEST(test_construct_domain_g)
{
	/* prepare */
	gchar const* checked;
	MockLogger* logger = mock_logger_new (domains[_i]);

	/* check */
	checked = mock_logger_get_domain (logger);
	fail_unless (checked && !strcmp (domains[_i], checked));

	/* cleanup */
}
END_TEST

TCase*
tcase_mock_logger_properties (void)
{
	TCase* self = tcase_create ("properties");
	// FIXME: write general property testing code
	tcase_add_loop_test (self, test_construct_domain,   0, G_N_ELEMENTS (domains));
	tcase_add_loop_test (self, test_construct_domain_g, 0, G_N_ELEMENTS (domains));
	return self;
}

