/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-mock-view.h"

#include "cc-test-view.h"

START_TEST(test_set_root)
{
	CcItem* item;
	CcView* view;

	item = cc_item_new ();
	view = cc_test_view_new ();
	cc_view_set_root (view, item);

	fail_unless (item == cc_view_get_root (view));

	cc_view_set_root (view, NULL);
	fail_unless (NULL == cc_view_get_root (view));
}
END_TEST

static void
item_view_register (CcItem  * item,
		    CcView  * view,
		    gboolean* registered)
{
	*registered = TRUE;
}

START_TEST(test_view_register)
{
	CcItem* item;
	CcView* view;

	gboolean registered;

	item = cc_item_new ();
	view = cc_test_view_new ();

	g_signal_connect (item, "view-register",
			  G_CALLBACK (item_view_register), &registered);
	registered = FALSE;
	cc_view_set_root (view, item);
	fail_unless (registered);
}
END_TEST

TCase*
test_mock_view_root (void)
{
	TCase* self = tcase_create ("Root Item handling");
	tcase_add_test (self, test_set_root);
	tcase_add_test (self, test_view_register);
	return self;
}

