/* This file is part of libccc
 *
 * AUTHORS
 *     Canek Peláez Valdés
 *     Sven Herzberg
 *
 * Copyright (C) 2007  Canek Peláez Valdés
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-view-widget.h"

#include <gtk/gtk.h>
#include <ccc.h>


static gboolean
button_press(CcItem *self, CcView *view, GdkEventButton *event, gpointer user_data)
{
	g_print("button_press\n");
	return TRUE;
}

static gboolean
key_press(CcItem *self, CcView *view, GdkEventKey *event, gpointer user_data)
{
	g_print("key_press\n");
	return TRUE;
}

static gboolean
key_release(CcItem *self, CcView *view, GdkEventKey *event, gpointer user_data)
{
	g_print("key_release\n");
	return TRUE;
}

START_TEST(test_view_widget_focus)
{
	GtkWidget* window = NULL;
	gboolean implemented = FALSE;
	fail_unless (implemented);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), "Key related events bug");
	gtk_window_set_default_size(GTK_WINDOW(window), 640, 480);
	
	g_signal_connect(window, "delete-event", G_CALLBACK(gtk_main_quit), NULL);

	CcItem* root = cc_item_new();
	GtkWidget* view = cc_view_widget_new_root(root);

	gtk_container_add(GTK_CONTAINER(window), view);

	CcItem* rect = cc_rectangle_new();
	cc_rectangle_set_position(CC_RECTANGLE(rect), 1, 1, 638, 478);
	cc_shape_set_brush_border(CC_SHAPE(rect), cc_brush_color_new(cc_color_new_rgb(0.0, 0.0, 0.0)));
	cc_shape_set_brush_content(CC_SHAPE(rect), cc_brush_color_new(cc_color_new_rgb(1.0, 1.0, 1.0)));


	g_signal_connect(root, "button-press-event", G_CALLBACK(button_press), NULL);
	g_signal_connect(root, "key-press-event", G_CALLBACK(key_press), NULL);
	g_signal_connect(root, "key-release-event", G_CALLBACK(key_release), NULL);
	
	cc_item_append(root, rect);
	
	gtk_widget_show_all(window);

	gtk_widget_grab_focus(view);

	//gtk_main();
}
END_TEST

TCase*
tcase_view_widget_focus (void)
{
	TCase* self = tcase_create ("focus handling");
	tcase_add_test (self, test_view_widget_focus);
	return self;
}

