package org.gnu.libebook;

import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;
import org.gnu.libedataserver.EDSMemStruct;

public class EContactPhoto extends EDSMemStruct
{
    public EContactPhoto(Handle handle)
    {
        super(handle);
    }

    public static EContactPhoto getEContactPhoto(Handle handle)
    {
        if (handle == null)
            return null;

        EContactPhoto obj = (EContactPhoto) MemStruct.getMemStructFromHandle(handle);
        return obj == null ? new EContactPhoto(handle) : obj;
    }

    public byte[] getData()
    {
        return e_contact_photo_get_data(getHandle());
    }

    public void setData(byte[] bytes)
    {
        e_contact_photo_set_data(getHandle(), bytes, bytes.length);
    }

    public static EContactPhoto createNewContactPhoto()
    {
        return getEContactPhoto(e_contact_photo_new());
    }
    
    native static private Handle e_contact_photo_new();

    native static private void e_contact_photo_set_data(Handle handle, byte[] data, int length);

    native static private byte[] e_contact_photo_get_data(Handle handle);
}