/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "gtk_java.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EVCard.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EVCard
 * Method:    e_vcard_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EVCard_e_1vcard_1new
(JNIEnv *env, jclass cls)
{
    return getGObjectHandle(env, (GObject *)e_vcard_new());
}

/*
 * Class:     org_gnu_libebook_EVCard
 * Method:    e_vcard_new_from_string
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EVCard_e_1vcard_1new_1from_1string
(JNIEnv *env, jclass cls, jstring vcard)
{
    char* vcard_g = (char*)(*env)->GetStringUTFChars(env, vcard, 0);
    EVCard *evcard = e_vcard_new_from_string(vcard_g);
    (*env)->ReleaseStringUTFChars(env, vcard, vcard_g);
    return getGObjectHandle(env, (GObject *)evcard);
}

/*
 * Class:     org_gnu_libebook_EVCard
 * Method:    e_vcard_to_string
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EVCard_e_1vcard_1to_1string
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCard *vcard = (EVCard*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_vcard_to_string(vcard, EVC_FORMAT_VCARD_30));
}

/*
 * Class:     org_gnu_libebook_EVCard
 * Method:    e_vcard_remove_attributes
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCard_e_1vcard_1remove_1attributes
(JNIEnv *env, jclass cls, jobject obj, jstring group, jstring name)
{
    EVCard *vcard = (EVCard*)getPointerFromHandle(env, obj);
    char* group_g = (char*)(*env)->GetStringUTFChars(env, group, 0);
    char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);

    e_vcard_remove_attributes(vcard, group_g, name_g);

    (*env)->ReleaseStringUTFChars(env, group, group_g);
    (*env)->ReleaseStringUTFChars(env, name, name_g);
}

/*
 * Class:     org_gnu_libebook_EVCard
 * Method:    e_vcard_remove_attribute
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCard_e_1vcard_1remove_1attribute
(JNIEnv *env, jclass cls, jobject obj, jobject attribute)
{
    EVCard *vcard = (EVCard*)getPointerFromHandle(env, obj);
    EVCardAttribute *attribute_g = (EVCardAttribute*)getPointerFromHandle(env, attribute);

    e_vcard_remove_attribute(vcard, attribute_g);
}

/*
 * Class:     org_gnu_libebook_EVCard
 * Method:    e_vcard_add_attribute
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCard_e_1vcard_1add_1attribute
(JNIEnv *env, jclass cls, jobject obj, jobject attribute)
{
    EVCard *vcard = (EVCard*)getPointerFromHandle(env, obj);
    EVCardAttribute *attribute_g = (EVCardAttribute*)getPointerFromHandle(env, attribute);

    e_vcard_add_attribute(vcard, e_vcard_attribute_copy(attribute_g));
}

/*
 * Class:     org_gnu_libebook_EVCard
 * Method:    e_vcard_add_attribute_with_value
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EVCard_e_1vcard_1add_1attribute_1with_1value
(JNIEnv *env, jclass cls, jobject obj, jobject attribute, jstring value)
{
    EVCard *vcard = (EVCard*)getPointerFromHandle(env, obj);
    EVCardAttribute *attribute_g = (EVCardAttribute*)getPointerFromHandle(env, attribute);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);

    e_vcard_add_attribute_with_value(vcard, e_vcard_attribute_copy(attribute_g), value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
}


jobject getEVCardAttributeHandle(JNIEnv* env, EVCardAttributeParam* param)
{
    return getHandleFromPointer(env, param);
//    return getStructHandle(env, param, NULL, (JGFreeFunc)e_vcard_attribute_free);
}

/*
 * Class:     org_gnu_libebook_EVCard
 * Method:    e_vcard_get_attributes
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EVCard_e_1vcard_1get_1attributes
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCard *vcard = (EVCard*)getPointerFromHandle(env, obj);
    return getStructHandlesFromGList(env, e_vcard_get_attributes(vcard), (GetHandleFunc)getEVCardAttributeHandle);
}



#ifdef __cplusplus
}

#endif
