/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:33 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The ColorSelectionDialog provides a standard dialog which allows the
 * user to select a color much like the {@link FileSelection} 
 * provides a standard dialog for file selection.
 */
public class ColorSelectionDialog extends Dialog {
	/**
	 * Construct a new ColorSelectionDialog.
	 * 
	 * @param title The text to display on the title bar of the dialog.
	 */
	public ColorSelectionDialog(String title) {
		handle = ColorSelectionDialog.gtk_color_selection_dialog_new(title);
		initializeEventHandlers();
	}
	
	/**
	 * Construct a ColorSelectionDialog using a handle to a 
	 * native resource.
	 */
	public ColorSelectionDialog(int handle) {
	    super(handle);
	}

	protected void noopInit() {}
	
	/**
	 * Return the OK Button widget for this Dialog.
	 * 
	 * @return The OK Button.
	 */
	public Button getOKButton() {
		int hndl = ColorSelectionDialog.getOkButton(handle);
		return new Button(hndl);
	}
	
	/**
	 * Return the Cancel Button widget for this dialog.
	 * 
	 * @return The Cancel Button.
	 */
	public Button getCancelButton() {
		int hndl = ColorSelectionDialog.getCancelButton(handle);
		return new Button(hndl);
	}
	
	/**
	 * Return the Help Button widget for this dialog.
	 * 
	 * @return The Help Button.
	 */
	public Button getHelpButton() {
		int hndl = ColorSelectionDialog.getHelpButton(handle);
		return new Button(hndl);
	}
	
	/**
	 * Return the ColorSelection widget for this dialog.
	 * 
	 * @return The ColorSelection widget.
	 */
	public ColorSelection getColorSelectionWidget() {
		int hndl = ColorSelectionDialog.getColorsel(handle);
		return new ColorSelection(hndl);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_color_selection_dialog_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getColorsel (int cptr);
    native static final protected int getOkButton (int cptr);
    native static final protected int getCancelButton (int cptr);
    native static final protected int getHelpButton (int cptr);
    native static final protected int gtk_color_selection_dialog_get_type ();
    native static final protected int gtk_color_selection_dialog_new (String title);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

