/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:33 EDT
 */

package org.gnu.gtk;

import java.util.Vector;

import org.gnu.glib.EventMap;
import org.gnu.glib.Type;
import org.gnu.gtk.event.GtkEventType;
import org.gnu.gtk.event.ItemEvent;
import org.gnu.gtk.event.ItemListener;

/**
 * This widget is designed to be a base class for widgets that can be
 * selected and deselected. The widgets that inherit from Item are
 * CheckMenuItem, ListItem, MenuItem, and RadioMenuItem.
 */
public class Item extends Bin 
{
	protected Item() {
		if (-1 == handle)
			initializeEventHandlers();
	}
	
	protected Item(int handle) {
	    super(handle);
	    initializeEventHandlers();
	}

	protected void noopInit() {}
	
	/**
	 * Emits the "select" event.
	 */
	public void select() {
		gtk_item_select(handle);
	}
	
	/**
	 * Emits the "deselect" event.
	 */
	public void deselect() {
		gtk_item_deselect(handle);
	}
	
	/**
	 * Emits the "toggle" event.
	 */
	public void toggle() {
		gtk_item_toggle(handle);
	}
	
	/* **************************************
	 * EVENT LISTENERS
	 ****************************************/

	/**
	 * Listeners for handling button events
	 */
	private Vector listeners = null;

	/**
	 * Register an object to handle item events.
	 * @see org.gnu.gtk.event.ItemListener
	 */
	public void addListener(ItemListener listener) {
		// Don't add the listener a second time if it is in the Vector.
		int i = findListener(listeners, listener);
		if (i == -1) {
			if (null == listeners) {
				listeners = new Vector();
			}
			listeners.addElement(listener);
		}
	}
	/**
	 * Removes a listener
	 * @see #addListener(ItemListener)
	 */
	public void removeListener(ItemListener listener) {
		int i = findListener(listeners, listener);
		if (i > -1) {
			listeners.remove(i);
		}
		if (0 == listeners.size()) {
			listeners = null;
		}
	}

	protected void fireItemEvent(ItemEvent event) {
		if (null == listeners) {
			return;
		}
		int size = listeners.size();
		int i = 0;
		while (i < size) {
			ItemListener lis = (ItemListener)listeners.elementAt(i);
			lis.itemEvent(event);
			i++;
		}
	}

	private void handleSelect() {
		fireItemEvent(new ItemEvent(this, ItemEvent.Type.SELECT));
	}

	private void handleDeselect() {
		fireItemEvent(new ItemEvent(this, ItemEvent.Type.DESELECT));
	}

	private void handleToggle() {
		fireItemEvent(new ItemEvent(this, ItemEvent.Type.TOGGLE));
	}

	protected void initializeEventHandlers() {
		super.initializeEventHandlers();
		evtMap.initialize(this);
	}

	public Class getEventListenerClass(String signal) {
		return evtMap.getListenerClass(signal);
	}

	public GtkEventType getEventType(String signal) {
		return evtMap.getEventType(signal);
	}

	private static EventMap evtMap = new EventMap();
	static {
		addEvents(evtMap);
	}

	/**
	 * Implementation method to build an EventMap for this widget class.
	 * Not useful (or supported) for application use.
	 */
	private static void addEvents(EventMap anEvtMap) {
		anEvtMap.addEvent("select", "handleSelect", ItemEvent.Type.SELECT, ItemListener.class);
		anEvtMap.addEvent("deselect", "handleDeselect", ItemEvent.Type.DESELECT, ItemListener.class);
		anEvtMap.addEvent("toggle", "handleToggle", ItemEvent.Type.TOGGLE, ItemListener.class);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_item_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_item_get_type ();
    native static final protected void gtk_item_select (int item);
    native static final protected void gtk_item_deselect (int item);
    native static final protected void gtk_item_toggle (int item);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

