/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.Handle;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;

/**
 * Provides the necessary functionality to display an animation.
 */
public class PixbufAnimationIter extends GObject {

    public PixbufAnimationIter(Handle handle) {
        super(handle);
    }

    /**
     * Possibly advances an animation to a new frame. Chooses the frame based on
     * the start time passed to the getIter method of PixbufAnimation.
     * 
     * @param currentSec
     * @param currentUsec
     */
    public boolean advance(long currentSec, long currentUsec) {
        return gdk_pixbuf_animation_iter_advance(getHandle(), currentSec,
                currentUsec);
    }

    /**
     * Gets the number of milliseconds the current Pixbuf should be displayed or
     * -1 if the current Pixbuf should be displayed forever.
     */
    public int getDelayTime() {
        return gdk_pixbuf_animation_iter_get_delay_time(getHandle());
    }

    /**
     * Returns true if the frame we're on is partially loaded, or the last frame
     */
    public boolean onCurrentlyLoadingFrame() {
        return gdk_pixbuf_animation_iter_on_currently_loading_frame(getHandle());
    }

    /**
     * Gets the current Pixbuf which should be displayed.
     */
    public Pixbuf getPixbuf() {
        return Pixbuf
                .getPixbufFromHandle(gdk_pixbuf_animation_iter_get_pixbuf(getHandle()));
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gdk_pixbuf_animation_iter_get_type());
    }

    native static final protected int gdk_pixbuf_animation_iter_get_type();

    native static final protected boolean gdk_pixbuf_animation_iter_advance(
            Handle iter, long curSec, long curUsec);

    native static final protected int gdk_pixbuf_animation_iter_get_delay_time(
            Handle iter);

    native static final protected Handle gdk_pixbuf_animation_iter_get_pixbuf(
            Handle iter);

    native static final protected boolean gdk_pixbuf_animation_iter_on_currently_loading_frame(
            Handle iter);

}
